/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptExecutorCallable<V>
implements DataSerializable,
Callable<V>,
HazelcastInstanceAware {
    private static final long serialVersionUID = -4729129143589252665L;
    private static final ILogger logger = Logger.getLogger(ScriptExecutorCallable.class.getName());
    private static final String SCRIPT_ENGINE_MANAGER_CLASS = "javax.script.ScriptEngineManager";
    private static final Class scriptEngineManagerClass;
    private static final Object lock;
    private static Object scriptEngineManager;
    private static Method mGetEngineByName;
    private String engineName;
    private String script;
    private Map<String, Object> bindings;
    private transient HazelcastInstance hazelcast;

    public ScriptExecutorCallable() {
    }

    public ScriptExecutorCallable(String engineName, String script) {
        this.engineName = engineName;
        this.script = script;
    }

    public ScriptExecutorCallable(String engineName, String script, Map<String, Object> bindings) {
        this.engineName = engineName;
        this.script = script;
        this.bindings = bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        if (scriptEngineManagerClass == null) {
            throw new ClassNotFoundException("ScriptEngineManager class could not be loaded!");
        }
        Object engine = null;
        Object object = lock;
        synchronized (object) {
            if (scriptEngineManager == null) {
                scriptEngineManager = scriptEngineManagerClass.newInstance();
                mGetEngineByName = scriptEngineManagerClass.getMethod("getEngineByName", String.class);
            }
            engine = mGetEngineByName.invoke(scriptEngineManager, this.engineName);
        }
        if (engine == null) {
            throw new NullPointerException("Could not find ScriptEngine named '" + this.engineName + "'.");
        }
        Method put = engine.getClass().getMethod("put", String.class, Object.class);
        put.invoke(engine, "hazelcast", this.hazelcast);
        if (this.bindings != null) {
            Set<Map.Entry<String, Object>> entries = this.bindings.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                put.invoke(engine, entry.getKey(), entry.getValue());
            }
        }
        Method eval = engine.getClass().getMethod("eval", String.class);
        Object result = eval.invoke(engine, this.script);
        if (result == null) {
            return null;
        }
        return (V)result;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.engineName);
        out.writeUTF(this.script);
        if (this.bindings != null) {
            out.writeInt(this.bindings.size());
            Set<Map.Entry<String, Object>> entries = this.bindings.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                out.writeUTF(entry.getKey());
                SerializationHelper.writeObject(out, entry.getValue());
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.engineName = in.readUTF();
        this.script = in.readUTF();
        int size = in.readInt();
        if (size > 0) {
            this.bindings = new HashMap<String, Object>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                Object value = SerializationHelper.readObject(in);
                this.bindings.put(key, value);
            }
        }
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcast = hazelcastInstance;
    }

    static {
        lock = new Object();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(SCRIPT_ENGINE_MANAGER_CLASS);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ScriptEngineManager class could not be loaded!");
        }
        scriptEngineManagerClass = clazz;
    }
}

