/*
 * Decompiled with CFR 0.152.
 */
package play.modules.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.Transaction;
import com.hazelcast.partition.PartitionService;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.cache.Cache;
import play.inject.BeanSource;
import play.inject.Injector;
import play.modules.hazelcast.HazelcastCacheImpl;
import play.modules.hazelcast.NamedBeanSource;
import play.modules.hazelcast.NamedInjector;
import play.mvc.Router;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastPlugin
extends PlayPlugin
implements BeanSource,
NamedBeanSource {
    private static HazelcastInstance instance;

    public void onApplicationStart() {
        try {
            if (instance == null) {
                VirtualFile confXml = Play.getVirtualFile((String)"conf/hazelcast.xml");
                if (confXml != null) {
                    Logger.info((String)"Building Hazelcast Configuration for: %s", (Object[])new Object[]{confXml.getName()});
                    XmlConfigBuilder conf = new XmlConfigBuilder(confXml.inputstream());
                    instance = Hazelcast.init((Config)conf.build());
                } else {
                    Logger.info((String)"Building Hazelcast Configuration using default values...", (Object[])new Object[0]);
                    instance = Hazelcast.newHazelcastInstance(null);
                }
                Logger.info((String)"Hazelcast Services are now started...\n", (Object[])new Object[0]);
            }
            Logger.info((String)"Replacing EhCacheImpl with HazelcastCacheImpl...", (Object[])new Object[0]);
            Cache.stop();
            Cache.forcedCacheImpl = HazelcastCacheImpl.getInstance();
            Cache.init();
            Logger.info((String)"Cache Impl: %s", (Object[])new Object[]{Cache.cacheImpl.getClass().getName()});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        Injector.inject((BeanSource)this);
        NamedInjector.inject(this);
    }

    public void onApplicationStop() {
        try {
            Hazelcast.shutdownAll();
            instance = null;
            Logger.info((String)"Hazelcast Services are now stopped\n", (Object[])new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRoutesLoaded() {
        Router.prependRoute((String)"GET", (String)"/@hazel", (String)"HazelcastApplication.index");
    }

    public <T> T getBeanOfType(Class<T> clazz) {
        if (clazz.equals(HazelcastInstance.class)) {
            Logger.info((String)"%s Injection...OK", (Object[])new Object[]{clazz.getName()});
            return (T)instance;
        }
        if (clazz.equals(ExecutorService.class)) {
            return (T)instance.getExecutorService();
        }
        if (clazz.equals(Transaction.class)) {
            return (T)instance.getTransaction();
        }
        if (clazz.equals(PartitionService.class)) {
            return (T)instance.getPartitionService();
        }
        Logger.info((String)"%s Injection...KO", (Object[])new Object[]{clazz.getName()});
        return null;
    }

    @Override
    public <T> T getBeanOfType(Class<T> clazz, String name) {
        if (clazz.equals(IMap.class) || clazz.equals(Map.class)) {
            return (T)instance.getMap(name);
        }
        if (clazz.equals(IList.class) || clazz.equals(List.class)) {
            return (T)instance.getList(name);
        }
        if (clazz.equals(ExecutorService.class)) {
            return (T)instance.getExecutorService(name);
        }
        if (clazz.equals(ISet.class) || clazz.equals(Set.class)) {
            return (T)instance.getSet(name);
        }
        if (clazz.equals(IdGenerator.class)) {
            return (T)instance.getIdGenerator(name);
        }
        if (clazz.equals(AtomicNumber.class)) {
            return (T)instance.getAtomicNumber(name);
        }
        if (clazz.equals(MultiMap.class)) {
            return (T)instance.getMultiMap(name);
        }
        if (clazz.equals(IQueue.class) || clazz.equals(Queue.class)) {
            return (T)instance.getQueue(name);
        }
        if (clazz.equals(ITopic.class)) {
            return (T)instance.getTopic(name);
        }
        Logger.info((String)"%s Injection...KO", (Object[])new Object[]{clazz.getName()});
        return null;
    }

    public static HazelcastInstance getHazel() {
        return instance;
    }

    public static Transaction getTransaction() {
        return instance.getTransaction();
    }

    public static ILock getLock(Object o) {
        return instance.getLock(o);
    }
}

