/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class QueueConfig
implements DataSerializable {
    public static final int DEFAULT_MAX_SIZE_PER_JVM = 0;
    public static final int DEFAULT_TTL_SECONDS = 0;
    private String name;
    private int maxSizePerJVM = 0;
    private int timeToLiveSeconds = 0;

    public QueueConfig() {
    }

    public QueueConfig(QueueConfig config) {
        this.name = config.name;
        this.maxSizePerJVM = config.maxSizePerJVM;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
    }

    public String getName() {
        return this.name;
    }

    public QueueConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getMaxSizePerJVM() {
        return this.maxSizePerJVM;
    }

    public QueueConfig setMaxSizePerJVM(int maxSizePerJVM) {
        if (maxSizePerJVM < 0) {
            throw new IllegalArgumentException("queue max size per JVM must be positive");
        }
        this.maxSizePerJVM = maxSizePerJVM;
        return this;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public QueueConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        if (timeToLiveSeconds < 0) {
            throw new IllegalArgumentException("queue TTL must be positive");
        }
        this.timeToLiveSeconds = timeToLiveSeconds;
        return this;
    }

    public boolean isCompatible(QueueConfig queueConfig) {
        if (queueConfig == null) {
            return false;
        }
        return (this.name != null ? this.name.equals(queueConfig.name) : queueConfig.name == null) && this.timeToLiveSeconds == queueConfig.timeToLiveSeconds;
    }

    public String toString() {
        return "QueueConfig [name=" + this.name + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", maxSizePerJVM=" + this.maxSizePerJVM + "]";
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.maxSizePerJVM);
        out.writeInt(this.timeToLiveSeconds);
    }

    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.maxSizePerJVM = in.readInt();
        this.timeToLiveSeconds = in.readInt();
    }
}

