/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.config.QueueConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.impl.BaseManager;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Constants;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.LocalQueueStatsImpl;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.MemberStateImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.impl.Request;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.TransactionImpl;
import com.hazelcast.impl.base.PacketProcessor;
import com.hazelcast.impl.base.RuntimeInterruptedException;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class BlockingQueueManager
extends BaseManager {
    private final int BLOCK_SIZE;
    private final Map<String, Q> mapQueues = new ConcurrentHashMap<String, Q>(10);
    private final Map<Long, List<Data>> mapTxnPolledElements = new HashMap<Long, List<Data>>(10);
    private int nextIndex = 0;

    BlockingQueueManager(Node node) {
        super(node);
        this.BLOCK_SIZE = node.groupProperties.BLOCKING_QUEUE_BLOCK_SIZE.getInteger();
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_POLL, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                try {
                    BlockingQueueManager.this.handlePoll(packet);
                }
                catch (Throwable t) {
                    Request req = Request.copy(packet);
                    BlockingQueueManager.this.printState(req, false, packet.conn.getEndPoint(), 1);
                    t.printStackTrace();
                }
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_OFFER, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleOffer(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_OFFER_FIRST, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleOfferFirst(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_BACKUP_ADD, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleBackup(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_BACKUP_REMOVE, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleBackup(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_SIZE, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleSize(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_PEEK, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handlePoll(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_READ, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleRead(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_REMOVE, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleRemove(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_TXN_BACKUP_POLL, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleTxnBackupPoll(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_TXN_COMMIT, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleTxnCommit(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_ADD_BLOCK, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleAddBlock(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_REMOVE_BLOCK, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleRemoveBlock(packet);
            }
        });
        node.clusterService.registerPacketProcessor(ClusterOperation.BLOCKING_QUEUE_FULL_BLOCK, new QueuePacketProcessor(){

            public void processPacket(Packet packet) {
                BlockingQueueManager.this.handleFullBlock(packet);
            }
        });
    }

    public void collectMemberStats(MemberStateImpl memberStats) {
        Collection<Q> queues = this.mapQueues.values();
        for (Q queue : queues) {
            memberStats.putLocalQueueStats(queue.getName(), queue.getQueueStats());
        }
    }

    public void syncForDead(Address deadAddress) {
        if (deadAddress.equals(this.thisAddress)) {
            return;
        }
        MemberImpl member = this.getNextMemberBeforeSync(deadAddress, true, 1);
        Address addressNewOwner = member == null ? this.thisAddress : member.getAddress();
        Collection<Q> queues = this.mapQueues.values();
        for (Q q : queues) {
            q.ensureBlocks();
            List<Block> lsBlocks = q.lsBlocks;
            for (Block block : lsBlocks) {
                int size;
                MemberImpl memberBackupWas;
                if (block.address.equals(deadAddress)) {
                    int size2;
                    block.address = addressNewOwner;
                    block.resetAddIndex();
                    if (this.lsMembers.size() <= 1 || !addressNewOwner.equals(this.thisAddress) || (size2 = block.size()) <= 0) continue;
                    this.executeLocally(new BlockBackupSyncRunner(new BlockBackupSync(q, block)));
                    continue;
                }
                if (!block.address.equals(this.thisAddress) || this.lsMembers.size() <= 1 || (memberBackupWas = this.getNextMemberBeforeSync(this.thisAddress, true, 1)) != null && !memberBackupWas.getAddress().equals(deadAddress) || (size = block.size()) <= 0) continue;
                this.executeLocally(new BlockBackupSyncRunner(new BlockBackupSync(q, block)));
            }
            List<Q.ScheduledPollAction> scheduledPollActions = q.lsScheduledPollActions;
            for (Q.ScheduledPollAction scheduledAction : scheduledPollActions) {
                if (!deadAddress.equals(scheduledAction.getRequest().caller)) continue;
                scheduledAction.setValid(false);
                this.node.clusterManager.deregisterScheduledAction(scheduledAction);
            }
            List<Q.ScheduledOfferAction> scheduledOfferActions = q.lsScheduledOfferActions;
            for (Q.ScheduledOfferAction scheduledAction : scheduledOfferActions) {
                if (!deadAddress.equals(scheduledAction.getRequest().caller)) continue;
                scheduledAction.setValid(false);
                this.node.clusterManager.deregisterScheduledAction(scheduledAction);
            }
        }
        this.doResetBlockSizes();
    }

    public void syncForAdd() {
        List<Block> lsBlocks;
        Collection<Q> queues;
        if (this.isMaster()) {
            queues = this.mapQueues.values();
            for (Q q : queues) {
                lsBlocks = q.lsBlocks;
                for (Block block : lsBlocks) {
                    int fullBlockId = -1;
                    if (block.isFull()) {
                        fullBlockId = block.blockId;
                    }
                    this.sendAddBlockMessageToOthers(block, fullBlockId, null, true);
                }
            }
        }
        queues = this.mapQueues.values();
        for (Q q : queues) {
            lsBlocks = q.lsBlocks;
            for (Block block : lsBlocks) {
                int size;
                if (!block.address.equals(this.thisAddress) || this.lsMembers.size() <= 1) continue;
                MemberImpl memberBackupWas = this.getNextMemberBeforeSync(this.thisAddress, true, 1);
                MemberImpl memberBackupIs = this.getNextMemberAfter(this.thisAddress, true, 1);
                if (memberBackupWas != null && memberBackupWas.equals(memberBackupIs) || (size = block.size()) <= 0) continue;
                this.executeLocally(new BlockBackupSyncRunner(new BlockBackupSync(q, block)));
            }
        }
        this.doResetBlockSizes();
    }

    void doResetBlockSizes() {
        Collection<Q> queues = this.mapQueues.values();
        for (Q q : queues) {
            List<Block> lsBlocks = q.lsBlocks;
            int size = 0;
            for (Block block : lsBlocks) {
                if (!block.address.equals(this.thisAddress)) continue;
                size += block.size();
            }
        }
    }

    final void handleSize(Packet packet) {
        Q q = this.getQ(packet.name);
        packet.longValue = q.size();
        this.sendResponse(packet);
    }

    final void handleListenerRegistrations(boolean add, String name, Data key, Address address, boolean includeValue) {
        Q q = this.getQ(name);
        if (add) {
            q.addListener(address, includeValue);
        } else {
            q.removeListener(address);
        }
    }

    final void handleTxnBackupPoll(Packet packet) {
        this.doTxnBackupPoll(packet.txnId, packet.getValueData());
    }

    final void handleTxnCommit(Packet packet) {
        this.mapTxnPolledElements.remove(packet.txnId);
    }

    final void doTxnBackupPoll(long txnId, Data value) {
        List<Data> lsTxnPolledElements = this.mapTxnPolledElements.get(txnId);
        if (lsTxnPolledElements == null) {
            lsTxnPolledElements = new ArrayList<Data>(1);
            this.mapTxnPolledElements.put(txnId, lsTxnPolledElements);
        }
        lsTxnPolledElements.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleBackup(Packet packet) {
        try {
            String name = packet.name;
            int blockId = packet.blockId;
            Q q = this.getQ(name);
            if (packet.operation == ClusterOperation.BLOCKING_QUEUE_BACKUP_ADD) {
                Data data = packet.getValueData();
                q.doBackup(true, data, blockId, (int)packet.longValue);
            } else if (packet.operation == ClusterOperation.BLOCKING_QUEUE_BACKUP_REMOVE) {
                q.doBackup(false, null, blockId, (int)packet.longValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releasePacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleRemoveBlock(Packet packet) {
        try {
            BlockUpdate addRemove = (BlockUpdate)ThreadContext.get().toObject(packet.getValueData());
            String name = packet.name;
            Q q = this.getQ(name);
            this.doRemoveBlock(q, packet.conn.getEndPoint(), addRemove.removeBlockId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releasePacket(packet);
        }
    }

    public void doRemoveBlock(Q q, Address originalRemover, int blockId) {
        Block blockRemoved = q.removeBlock(blockId);
        if (this.isMaster()) {
            this.sendAddBlockMessageToOthers(q.name, null, blockId, -1, originalRemover, false);
        }
    }

    final void handleFullBlock(Packet packet) {
        if (this.isMaster()) {
            String name = packet.name;
            Q q = this.getQ(name);
            this.doFullBlock(q, packet.blockId, packet.conn.getEndPoint());
        }
        this.releasePacket(packet);
    }

    final void doFullBlock(Q q, int fullBlockId, Address originalFuller) {
        int blockId = q.getLatestAddedBlock() + 1;
        Address target = this.nextTarget();
        Block newBlock = this.setFullAndCreateNewBlock(q, fullBlockId, target, blockId);
        if (newBlock != null) {
            this.sendAddBlockMessageToOthers(newBlock, fullBlockId, originalFuller, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleAddBlock(Packet packet) {
        try {
            BlockUpdate addRemove = (BlockUpdate)ThreadContext.get().toObject(packet.getValueData());
            String name = packet.name;
            int blockId = addRemove.addBlockId;
            Address addressOwner = addRemove.addAddress;
            Q q = this.getQ(name);
            this.setFullAndCreateNewBlock(q, addRemove.fullBlockId, addressOwner, blockId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releasePacket(packet);
        }
    }

    Block setFullAndCreateNewBlock(Q q, int fullBlockId, Address newBlockOwner, int newBlockId) {
        List<Block> lsBlocks = q.lsBlocks;
        boolean exist = false;
        for (Block block : lsBlocks) {
            if (block.blockId != newBlockId) continue;
            exist = true;
        }
        Block newBlock = null;
        if (!exist) {
            newBlock = q.createBlock(newBlockOwner, newBlockId);
            q.addBlock(newBlock);
        }
        if (fullBlockId != -1) {
            q.setBlockFull(fullBlockId);
        }
        return newBlock;
    }

    final void handleOffer(Packet packet) {
        if (this.rightRemoteOfferTarget(packet)) {
            Request request = Request.copy(packet);
            this.doOffer(request);
            packet.longValue = request.longValue;
            if (!request.scheduled) {
                if (request.response == Boolean.TRUE) {
                    this.sendResponse(packet);
                } else {
                    this.sendResponseFailure(packet);
                }
            } else {
                this.releasePacket(packet);
            }
        }
    }

    final void handleOfferFirst(Packet packet) {
        if (this.rightRemotePollTarget(packet)) {
            Request request = Request.copy(packet);
            this.doOfferFirst(request);
            packet.longValue = request.longValue;
            if (!request.scheduled) {
                if (request.response == Boolean.TRUE) {
                    this.sendResponse(packet);
                } else {
                    this.sendResponseFailure(packet);
                }
            } else {
                this.releasePacket(packet);
            }
        }
    }

    final boolean rightRemoteOfferTarget(Packet packet) {
        Q q = this.getQ(packet.name);
        boolean valid = q.rightPutTarget(packet.blockId);
        if (!valid) {
            this.sendRedoResponse(packet);
        }
        return valid;
    }

    boolean rightRemotePollTarget(Packet packet) {
        Q q = this.getQ(packet.name);
        boolean valid = q.rightTakeTarget(packet.blockId);
        if (!valid) {
            boolean sent = this.sendRedoResponse(packet);
        }
        return valid;
    }

    final void handlePoll(Packet packet) {
        if (this.rightRemotePollTarget(packet)) {
            Request request = Request.copy(packet);
            this.doPoll(request);
            packet.longValue = request.longValue;
            if (!request.scheduled) {
                Data oldValue = (Data)request.response;
                if (oldValue != null && oldValue.size() > 0) {
                    packet.setValue(oldValue);
                }
                this.sendResponse(packet);
            } else {
                this.releasePacket(packet);
            }
        }
    }

    final void handleRead(Packet packet) {
        Q q = this.getQ(packet.name);
        q.read(packet);
    }

    final void handleRemove(Packet packet) {
        Q q = this.getQ(packet.name);
        q.remove(packet);
    }

    final Address nextTarget() {
        int size = this.lsMembers.size();
        int index = this.nextIndex++ % size;
        if (this.nextIndex >= size) {
            this.nextIndex = 0;
        }
        return ((MemberImpl)this.lsMembers.get(index)).getAddress();
    }

    public Q getQ(String name) {
        if (name == null) {
            return null;
        }
        Q q = this.mapQueues.get(name);
        if (q == null) {
            q = new Q(name);
            this.mapQueues.put(name, q);
        }
        return q;
    }

    public void destroy(String name) {
        Q q = this.mapQueues.remove(name);
        if (q != null) {
            q.destroy();
        }
    }

    public Address getTargetForOffer(Request request) {
        Address target = null;
        Q q = this.getQ(request.name);
        Block block = q.getCurrentPutBlock();
        if (block == null) {
            target = this.getMasterAddress();
            request.blockId = 0;
        } else {
            target = block.address;
            request.blockId = block.blockId;
        }
        return target;
    }

    void printState(Request request, boolean local, Address address, int doCount) {
        Q q = this.getQ(request.name);
        q.printStack();
        System.out.println(local + " ===== CurrentRequest === " + doCount);
        System.out.println("blockId: " + request.blockId);
        System.out.println("operation: " + (Object)((Object)request.operation));
        System.out.println("version: " + request.version);
        System.out.println("timeout: " + request.timeout);
        System.out.println("target: " + address);
        System.out.println("=========== DONE =======");
    }

    void doOffer(Request req) {
        if (req.value == null) {
            throw new RuntimeException("Offer request value cannot be null. Local:" + req.local);
        }
        if (req.value.size() == 0) {
            throw new RuntimeException("Offer request value size cannot be zero. Local:" + req.local);
        }
        Q q = this.getQ(req.name);
        if (q.blCurrentPut == null) {
            q.setCurrentPut();
        }
        if (q.quickSize() >= q.maxSizePerJVM) {
            if (req.hasEnoughTimeToSchedule()) {
                Request reqScheduled;
                req.scheduled = true;
                Request request = reqScheduled = req.local ? req : req.hardCopy();
                if (reqScheduled.local && reqScheduled.attachment == null) {
                    throw new RuntimeException("Scheduled local but attachment is null");
                }
                q.scheduleOffer(reqScheduled);
            } else {
                req.response = Boolean.FALSE;
            }
            return;
        }
        q.offer(req, false);
        req.response = Boolean.TRUE;
    }

    void doOfferFirst(Request req) {
        if (req.value == null) {
            throw new RuntimeException("OfferFirst request value cannot be null. Local:" + req.local);
        }
        if (req.value.size() == 0) {
            throw new RuntimeException("OfferFirst request value size cannot be zero. Local:" + req.local);
        }
        Q q = this.getQ(req.name);
        if (q.blCurrentTake == null) {
            q.setCurrentTake();
        }
        if (q.quickSize() >= q.maxSizePerJVM || q.blCurrentTake.hasNoSpace()) {
            if (req.hasEnoughTimeToSchedule()) {
                Request reqScheduled;
                req.scheduled = true;
                Request request = reqScheduled = req.local ? req : req.hardCopy();
                if (reqScheduled.local && reqScheduled.attachment == null) {
                    throw new RuntimeException("Scheduled local but attachment is null");
                }
                q.scheduleOfferFirst(reqScheduled);
            } else {
                req.response = Boolean.FALSE;
            }
            return;
        }
        q.offer(req, true);
        req.response = Boolean.TRUE;
    }

    void doPoll(Request req) {
        Q q = this.getQ(req.name);
        if (q.blCurrentTake == null) {
            q.setCurrentTake();
        }
        if (!q.blCurrentTake.containsValidItem() && !q.blCurrentTake.isFull()) {
            if (req.hasEnoughTimeToSchedule()) {
                req.scheduled = true;
                if (req.local && req.attachment == null) {
                    throw new RuntimeException("Scheduled local but attachment is null");
                }
                q.schedulePoll(req);
            } else {
                req.response = null;
            }
            return;
        }
        Data value = null;
        value = req.operation == ClusterOperation.BLOCKING_QUEUE_PEEK ? q.peek() : q.poll(req);
        req.response = value;
    }

    public void sendAddBlockMessageToOthers(Block block, int fullBlockId, Address except, boolean add) {
        this.sendAddBlockMessageToOthers(block.name, block.address, block.blockId, fullBlockId, except, add);
    }

    public void sendAddBlockMessageToOthers(String name, Address addAddress, int blockId, int fullBlockId, Address except, boolean add) {
        ClusterOperation operation = ClusterOperation.BLOCKING_QUEUE_ADD_BLOCK;
        if (!add) {
            operation = ClusterOperation.BLOCKING_QUEUE_REMOVE_BLOCK;
        }
        if (this.lsMembers.size() > 1) {
            int addBlockId = -1;
            int removeBlockId = -1;
            if (add) {
                addBlockId = blockId;
                except = null;
            } else {
                removeBlockId = blockId;
            }
            BlockUpdate addRemove = new BlockUpdate(addAddress, addBlockId, fullBlockId, removeBlockId);
            for (MemberImpl member : this.lsMembers) {
                Address dest;
                if (member.localMember() || (dest = member.getAddress()).equals(except)) continue;
                this.send(name, operation, addRemove, dest);
            }
        }
    }

    public void sendFullMessageToMaster(Block block) {
        Packet packet = this.obtainPacket();
        packet.set(block.name, ClusterOperation.BLOCKING_QUEUE_FULL_BLOCK, null, null);
        packet.blockId = block.blockId;
        Address master = this.getMasterAddress();
        boolean sent = this.send(packet, master);
        if (!sent) {
            this.releasePacket(packet);
        }
    }

    public void appendState(StringBuffer sb) {
        Collection<Q> queues = this.mapQueues.values();
        for (Q queue : queues) {
            queue.appendState(sb);
        }
    }

    public static class BlockUpdate
    implements DataSerializable {
        int addBlockId = -1;
        int removeBlockId = -1;
        int fullBlockId = -1;
        Address addAddress = null;

        public BlockUpdate(Address addAddress, int addBlockId, int fullBlockId, int removeBlockId) {
            this.addAddress = addAddress;
            this.addBlockId = addBlockId;
            this.fullBlockId = fullBlockId;
            this.removeBlockId = removeBlockId;
        }

        public BlockUpdate() {
        }

        public void readData(DataInput in) throws IOException {
            this.addBlockId = in.readInt();
            this.removeBlockId = in.readInt();
            this.fullBlockId = in.readInt();
            if (this.addBlockId != -1) {
                this.addAddress = new Address();
                this.addAddress.readData(in);
            }
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeInt(this.addBlockId);
            out.writeInt(this.removeBlockId);
            out.writeInt(this.fullBlockId);
            if (this.addBlockId != -1) {
                this.addAddress.writeData(out);
            }
        }
    }

    class Block {
        final int blockId;
        final String name;
        final QData[] values;
        final long maxAge;
        Address address;
        int addIndex = 0;
        int removeIndex = 0;
        boolean full = false;

        public Block(Address address, int blockId, long maxAge, String name) {
            this.address = address;
            this.blockId = blockId;
            this.maxAge = maxAge;
            this.name = name;
            this.values = new QData[BlockingQueueManager.this.BLOCK_SIZE];
        }

        public QData peek() {
            for (int i = this.removeIndex; i < BlockingQueueManager.this.BLOCK_SIZE; ++i) {
                if (this.values[i] == null) continue;
                QData value = this.values[i];
                this.removeIndex = i;
                return value;
            }
            return null;
        }

        public QData[] getValues() {
            return this.values;
        }

        public QData get(int index) {
            return this.values[index];
        }

        void resetAddIndex() {
            int index;
            for (index = BlockingQueueManager.this.BLOCK_SIZE - 1; index >= 0; --index) {
                if (this.values[index] == null) continue;
                this.addIndex = index + 1;
                if (this.addIndex >= BlockingQueueManager.this.BLOCK_SIZE) {
                    this.full = true;
                }
                return;
            }
            index = 0;
        }

        public int addFirst(Data item) {
            QData data = new QData(item);
            ArrayList<QData> ordered = new ArrayList<QData>(BlockingQueueManager.this.BLOCK_SIZE);
            for (QData d : this.values) {
                if (d == null) continue;
                ordered.add(d);
            }
            this.values[0] = data;
            int i = 1;
            for (QData d : ordered) {
                this.values[i++] = d;
            }
            this.addIndex = i;
            this.removeIndex = 0;
            return 0;
        }

        public int add(Data item) {
            QData data = new QData(item);
            if (this.values != null) {
                if (this.values[this.addIndex] != null) {
                    return -1;
                }
                this.values[this.addIndex] = data;
            }
            int addedCurrentIndex = this.addIndex++;
            if (this.addIndex >= BlockingQueueManager.this.BLOCK_SIZE) {
                this.full = true;
            }
            return addedCurrentIndex;
        }

        public boolean add(int index, Data item) {
            QData data = new QData(item);
            if (this.values[index] != null) {
                return false;
            }
            this.values[index] = data;
            return true;
        }

        boolean isFull() {
            return this.full;
        }

        public void setFull(boolean full) {
            this.full = full;
        }

        public QData remove(int index) {
            QData value = this.values[index];
            this.values[index] = null;
            return value;
        }

        public QData remove() {
            for (int i = this.removeIndex; i < this.addIndex; ++i) {
                if (this.values[i] == null) continue;
                QData value = this.values[i];
                this.values[i] = null;
                this.removeIndex = i + 1;
                return value;
            }
            return null;
        }

        public boolean hasNoSpace() {
            for (int i = 0; i < BlockingQueueManager.this.BLOCK_SIZE; ++i) {
                if (this.values[i] != null) continue;
                return false;
            }
            return true;
        }

        public boolean containsValidItem() {
            for (int i = this.removeIndex; i < this.addIndex; ++i) {
                if (this.values[i] == null) continue;
                QData value = this.values[i];
                long age = System.currentTimeMillis() - value.createDate;
                if (age > this.maxAge) {
                    this.values[i] = null;
                    continue;
                }
                return true;
            }
            return false;
        }

        public int size() {
            int s = 0;
            boolean owner = BlockingQueueManager.this.thisAddress.equals(this.address);
            int start = owner ? this.removeIndex : 0;
            int end = owner ? this.addIndex : BlockingQueueManager.this.BLOCK_SIZE;
            for (int i = start; i < end; ++i) {
                if (this.values[i] == null) continue;
                QData value = this.values[i];
                long age = System.currentTimeMillis() - value.createDate;
                if (age > this.maxAge) {
                    this.values[i] = null;
                    continue;
                }
                ++s;
            }
            return s;
        }

        public int quickSize() {
            return this.addIndex - this.removeIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Block block = (Block)o;
            if (this.blockId != block.blockId) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(block.name) : block.name != null);
        }

        public int hashCode() {
            int result = this.blockId;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Block [" + this.blockId + "] full=" + this.isFull() + ", size=" + this.size() + ", " + this.address;
        }
    }

    class QData {
        final Data data;
        final long createDate;

        QData(Data data) {
            this.data = data;
            this.createDate = System.currentTimeMillis();
        }
    }

    public final class Q {
        static final int blocksLimit = 10;
        String name;
        final List<Block> lsBlocks;
        Block blCurrentPut = null;
        Block blCurrentTake = null;
        int latestAddedBlock = -1;
        final List<ScheduledPollAction> lsScheduledPollActions = new ArrayList<ScheduledPollAction>(100);
        final List<ScheduledOfferAction> lsScheduledOfferActions = new ArrayList<ScheduledOfferAction>(100);
        final int maxSizePerJVM;
        Map<Address, Boolean> mapListeners = new HashMap<Address, Boolean>(2);
        final long maxAge;

        public Q(String name) {
            QueueConfig qconfig = BlockingQueueManager.this.node.getConfig().getQueueConfig(name.substring("q:".length()));
            this.maxSizePerJVM = qconfig.getMaxSizePerJVM() == 0 ? Integer.MAX_VALUE : qconfig.getMaxSizePerJVM();
            this.maxAge = qconfig.getTimeToLiveSeconds() == 0 ? Integer.MAX_VALUE : TimeUnit.SECONDS.toMillis(qconfig.getTimeToLiveSeconds());
            BlockingQueueManager.this.logger.log(Level.FINEST, name + ".maxSizePerJVM=" + this.maxSizePerJVM);
            BlockingQueueManager.this.logger.log(Level.FINEST, name + ".maxAge=" + this.maxAge);
            this.name = name;
            this.lsBlocks = new ArrayList<Block>(10);
            this.ensureBlocks();
        }

        void ensureBlocks() {
            if (BlockingQueueManager.this.node.isActive()) {
                Address master = BlockingQueueManager.this.getMasterAddress();
                if (master == null) {
                    throw new IllegalStateException("Master is " + master);
                }
                if (BlockingQueueManager.this.isMaster() && this.lsBlocks.size() == 0) {
                    Block block = this.createBlock(master, 0);
                    this.addBlock(block);
                    BlockingQueueManager.this.sendAddBlockMessageToOthers(block, -1, null, true);
                    for (int i = 1; i < 10; ++i) {
                        Address target = BlockingQueueManager.this.nextTarget();
                        block = this.createBlock(target, i);
                        this.addBlock(block);
                        BlockingQueueManager.this.sendAddBlockMessageToOthers(block, -1, null, true);
                    }
                }
            }
        }

        public void destroy() {
            this.lsBlocks.clear();
            this.mapListeners.clear();
            for (ScheduledPollAction scheduledPollAction : this.lsScheduledPollActions) {
                scheduledPollAction.setValid(false);
            }
            this.lsScheduledPollActions.clear();
            for (ScheduledOfferAction scheduledOfferAction : this.lsScheduledOfferActions) {
                scheduledOfferAction.setValid(false);
            }
            this.lsScheduledOfferActions.clear();
        }

        public LocalQueueStatsImpl getQueueStats() {
            long now = System.currentTimeMillis();
            int ownedCount = 0;
            int backupCount = 0;
            long minAge = Long.MAX_VALUE;
            long maxAge = Long.MIN_VALUE;
            long totalAge = 0L;
            for (Block block : this.lsBlocks) {
                if (BlockingQueueManager.this.thisAddress.equals(block.address)) {
                    QData[] values;
                    for (QData value : values = block.getValues()) {
                        if (value == null) continue;
                        ++ownedCount;
                        long age = now - value.createDate;
                        minAge = Math.min(minAge, age);
                        maxAge = Math.max(maxAge, age);
                        totalAge += age;
                    }
                    continue;
                }
                backupCount += block.size();
            }
            long aveAge = ownedCount == 0 ? 0L : totalAge / (long)ownedCount;
            return new LocalQueueStatsImpl(ownedCount, backupCount, minAge, maxAge, aveAge);
        }

        public void appendState(StringBuffer sb) {
            sb.append("\nQ.name: ").append(this.name).append(" this:").append(BlockingQueueManager.this.thisAddress);
            sb.append("\n\tlatestAdded:").append(this.latestAddedBlock);
            sb.append(" put:").append(this.blCurrentPut);
            sb.append(" take:").append(this.blCurrentTake);
            sb.append(" s.polls:").append(this.lsScheduledPollActions.size());
            sb.append(", s.offers:").append(this.lsScheduledOfferActions.size());
            sb.append(", lsBlocks:").append(this.lsBlocks.size());
            for (Block block : this.lsBlocks) {
                sb.append("\n\t").append(block.blockId).append(":").append(block.size()).append(" ").append(block.address);
            }
        }

        public Block createBlock(Address address, int blockId) {
            return new Block(address, blockId, this.maxAge, this.name);
        }

        public Address getBlockOwner(int blockId) {
            for (Block block : this.lsBlocks) {
                if (block.blockId != blockId) continue;
                return block.address;
            }
            return null;
        }

        public void addListener(Address address, boolean includeValue) {
            this.mapListeners.put(address, includeValue);
        }

        public void removeListener(Address address) {
            this.mapListeners.remove(address);
        }

        public void scheduleOffer(Request request) {
            ScheduledOfferAction action = new ScheduledOfferAction(request);
            this.lsScheduledOfferActions.add(action);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(action);
        }

        public void scheduleOfferFirst(Request request) {
            ScheduledOfferFirstAction action = new ScheduledOfferFirstAction(request);
            this.lsScheduledOfferActions.add(action);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(action);
        }

        public void schedulePoll(Request request) {
            ScheduledPollAction action = new ScheduledPollAction(request);
            this.lsScheduledPollActions.add(action);
            BlockingQueueManager.this.node.clusterManager.registerScheduledAction(action);
        }

        public int getMaxSizePerJVM() {
            return this.maxSizePerJVM;
        }

        public String getName() {
            return this.name;
        }

        public Block getBlock(int blockId) {
            int size = this.lsBlocks.size();
            for (int i = 0; i < size; ++i) {
                Block block = this.lsBlocks.get(i);
                if (block.blockId != blockId) continue;
                return block;
            }
            return null;
        }

        public void setBlockFull(int fullBlockId) {
            if (this.blCurrentPut != null && this.blCurrentPut.blockId == fullBlockId) {
                this.blCurrentPut.setFull(true);
                this.blCurrentPut = null;
            }
            if (this.blCurrentTake != null && this.blCurrentTake.blockId == fullBlockId) {
                this.blCurrentTake.setFull(true);
            }
            int size = this.lsBlocks.size();
            for (int i = 0; i < size; ++i) {
                Block block = this.lsBlocks.get(i);
                if (block.blockId != fullBlockId) continue;
                block.setFull(true);
                this.blCurrentPut = null;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Block removeBlock(int blockId) {
            try {
                if (this.blCurrentPut != null && this.blCurrentPut.blockId == blockId) {
                    this.blCurrentPut = null;
                }
                if (this.blCurrentTake != null && this.blCurrentTake.blockId == blockId) {
                    this.blCurrentTake = null;
                }
                int size = this.lsBlocks.size();
                for (int i = 0; i < size; ++i) {
                    Block b = this.lsBlocks.get(i);
                    if (b.blockId != blockId) continue;
                    this.blCurrentTake = null;
                    Block block = this.lsBlocks.remove(i);
                    return block;
                }
                Block block = null;
                return block;
            }
            finally {
                if (this.blCurrentPut == null) {
                    this.setCurrentPut();
                }
            }
        }

        public void addBlock(Block newBlock) {
            this.lsBlocks.add(newBlock);
            this.latestAddedBlock = Math.max(newBlock.blockId, this.latestAddedBlock);
        }

        int getLatestAddedBlock() {
            return this.latestAddedBlock;
        }

        void remove(Remove remove) {
            Block block = this.getBlock(remove.blockId);
            if (block != null) {
                block.remove(remove.index);
            }
            remove.setResponse();
        }

        void remove(Packet packet) {
            int index = (int)packet.longValue;
            int blockId = packet.blockId;
            Block block = this.getBlock(blockId);
            packet.longValue = -1L;
            if (block != null) {
                block.remove(index);
            }
            BlockingQueueManager.this.sendResponse(packet);
        }

        void read(Read read) {
            Block block = this.getBlock(read.blockId);
            if (block == null) {
                read.setResponse(null, -1);
                return;
            }
            for (int i = read.index; i < BlockingQueueManager.this.BLOCK_SIZE; ++i) {
                QData data = block.get(i);
                if (data == null) continue;
                read.setResponse(data.data, i);
                return;
            }
            read.setResponse(null, -1);
        }

        void read(Packet packet) {
            int index = (int)packet.longValue;
            int blockId = packet.blockId;
            Block block = this.getBlock(blockId);
            packet.longValue = -1L;
            if (block != null) {
                for (int i = index; i < BlockingQueueManager.this.BLOCK_SIZE; ++i) {
                    QData data = block.get(i);
                    if (data == null) continue;
                    packet.setValue(data.data);
                    packet.longValue = i;
                    break;
                }
            }
            BlockingQueueManager.this.sendResponse(packet);
        }

        void doFireEntryEvent(boolean add, Data value, Address callerAddress) {
            if (this.mapListeners.size() == 0) {
                return;
            }
            if (add) {
                BlockingQueueManager.this.fireMapEvent(this.mapListeners, this.name, EntryEvent.TYPE_ADDED, value, callerAddress);
            } else {
                BlockingQueueManager.this.fireMapEvent(this.mapListeners, this.name, EntryEvent.TYPE_REMOVED, value, callerAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int offer(Request req, boolean first) {
            if (req.value == null) {
                throw new RuntimeException("Offer request value cannot be null. Local:" + req.local);
            }
            if (req.value.size() == 0) {
                throw new RuntimeException("Offer request value size cannot be zero. Local:" + req.local);
            }
            try {
                int addIndex = first ? this.blCurrentTake.addFirst(req.value) : this.blCurrentPut.add(req.value);
                this.doFireEntryEvent(true, req.value, req.caller);
                this.sendBackup(true, req.caller, req.value, this.blCurrentPut.blockId, addIndex);
                req.longValue = addIndex;
                if (this.blCurrentPut.isFull()) {
                    this.fireBlockFullEvent(this.blCurrentPut);
                    this.blCurrentPut = null;
                    this.setCurrentPut();
                }
                int n = addIndex;
                return n;
            }
            finally {
                boolean consumed = false;
                while (!consumed && this.lsScheduledPollActions.size() > 0) {
                    ScheduledAction pollAction = this.lsScheduledPollActions.remove(0);
                    if (pollAction.expired()) continue;
                    consumed = pollAction.consume();
                    BlockingQueueManager.this.node.clusterManager.deregisterScheduledAction(pollAction);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Data poll(Request request) {
            try {
                DataSerializable backup;
                Data value;
                this.setCurrentTake();
                QData qdata = this.blCurrentTake.remove();
                int removeIndex = this.blCurrentTake.removeIndex - 1;
                request.longValue = removeIndex;
                Data data = value = qdata == null ? null : qdata.data;
                if (request.txnId != -1L) {
                    backup = null;
                    backup = request.caller.equals(BlockingQueueManager.this.thisAddress) ? BlockingQueueManager.this.getNextMemberAfter(BlockingQueueManager.this.thisAddress, true, 1) : BlockingQueueManager.this.getNextMemberAfter(request.caller, true, 1);
                    if (backup != null) {
                        if (((MemberImpl)backup).getAddress().equals(BlockingQueueManager.this.thisAddress)) {
                            BlockingQueueManager.this.doTxnBackupPoll(request.txnId, value);
                        } else {
                            this.sendTxnBackup(((MemberImpl)backup).getAddress(), value, request.txnId);
                        }
                    }
                }
                this.doFireEntryEvent(false, value, request.caller);
                this.sendBackup(false, request.caller, null, this.blCurrentTake.blockId, removeIndex);
                if (!this.blCurrentTake.containsValidItem() && this.blCurrentTake.isFull()) {
                    this.fireBlockRemoveEvent(this.blCurrentTake);
                    this.blCurrentTake = null;
                }
                backup = value;
                return backup;
            }
            catch (Throwable t) {
                t.printStackTrace();
                Data data = null;
                return data;
            }
            finally {
                boolean consumed = false;
                while (!consumed && this.lsScheduledOfferActions.size() > 0) {
                    ScheduledOfferAction offerAction = this.lsScheduledOfferActions.remove(0);
                    if (offerAction.expired()) continue;
                    consumed = offerAction.consume();
                    BlockingQueueManager.this.node.clusterManager.deregisterScheduledAction(offerAction);
                }
            }
        }

        public Data peek() {
            this.setCurrentTake();
            if (this.blCurrentTake == null) {
                return null;
            }
            QData value = this.blCurrentTake.peek();
            if (value == null) {
                return null;
            }
            return value.data;
        }

        boolean doBackup(boolean add, Data data, int blockId, int itemIndex) {
            Block block = this.getBlock(blockId);
            if (block == null) {
                return false;
            }
            if (BlockingQueueManager.this.thisAddress.equals(block.address)) {
                return false;
            }
            if (add) {
                boolean added = block.add(itemIndex, data);
                return true;
            }
            if (block.size() <= 0) {
                return false;
            }
            block.remove(itemIndex);
            return true;
        }

        boolean sendTxnBackup(Address address, Data value, long txnId) {
            Packet packet = BlockingQueueManager.this.obtainPacket(this.name, null, value, ClusterOperation.BLOCKING_QUEUE_TXN_BACKUP_POLL, 0L);
            packet.txnId = txnId;
            boolean sent = BlockingQueueManager.this.send(packet, address);
            if (!sent) {
                BlockingQueueManager.this.releasePacket(packet);
            }
            return sent;
        }

        boolean sendBackup(boolean add, Address caller, Data data, int blockId, int addIndex) {
            if (addIndex == -1) {
                throw new RuntimeException("addIndex cannot be -1");
            }
            if (BlockingQueueManager.this.lsMembers.size() > 1) {
                MemberImpl memberBackup = BlockingQueueManager.this.getNextMemberAfter(BlockingQueueManager.this.thisAddress, true, 1);
                if (memberBackup == null) {
                    return true;
                }
                ClusterOperation operation = ClusterOperation.BLOCKING_QUEUE_BACKUP_REMOVE;
                if (add) {
                    operation = ClusterOperation.BLOCKING_QUEUE_BACKUP_ADD;
                }
                Packet packet = BlockingQueueManager.this.obtainPacket(this.name, null, data, operation, 0L);
                packet.blockId = blockId;
                if (addIndex >= 1000) {
                    throw new RuntimeException("Invalid sendBackup.addIndex " + addIndex);
                }
                packet.longValue = addIndex;
                boolean sent = BlockingQueueManager.this.send(packet, memberBackup.getAddress());
                if (!sent) {
                    BlockingQueueManager.this.releasePacket(packet);
                }
                return sent;
            }
            return true;
        }

        void fireBlockRemoveEvent(Block block) {
            if (BlockingQueueManager.this.isMaster()) {
                BlockingQueueManager.this.doRemoveBlock(this, null, block.blockId);
            } else {
                this.removeBlock(block.blockId);
                BlockingQueueManager.this.sendAddBlockMessageToOthers(block, -1, null, false);
            }
        }

        void fireBlockFullEvent(Block block) {
            if (BlockingQueueManager.this.isMaster()) {
                BlockingQueueManager.this.doFullBlock(this, block.blockId, null);
            } else {
                this.setBlockFull(block.blockId);
                BlockingQueueManager.this.sendFullMessageToMaster(block);
            }
        }

        int quickSize() {
            int size = 0;
            int length = this.lsBlocks.size();
            for (int i = 0; i < length; ++i) {
                Block block = this.lsBlocks.get(i);
                if (!BlockingQueueManager.this.thisAddress.equals(block.address)) continue;
                size += block.quickSize();
            }
            return size;
        }

        int size() {
            int size = 0;
            int length = this.lsBlocks.size();
            for (int i = 0; i < length; ++i) {
                Block block = this.lsBlocks.get(i);
                if (!BlockingQueueManager.this.thisAddress.equals(block.address)) continue;
                size += block.size();
            }
            return size;
        }

        boolean rightPutTarget(int blockId) {
            this.setCurrentPut();
            return this.blCurrentPut != null && this.blCurrentPut.blockId == blockId && BlockingQueueManager.this.thisAddress.equals(this.blCurrentPut.address) && !this.blCurrentPut.isFull();
        }

        boolean rightTakeTarget(int blockId) {
            this.setCurrentTake();
            return this.blCurrentTake != null && this.blCurrentTake.blockId == blockId && BlockingQueueManager.this.thisAddress.equals(this.blCurrentTake.address) && (this.blCurrentTake.containsValidItem() || !this.blCurrentTake.isFull());
        }

        void setCurrentPut() {
            if (this.blCurrentPut == null || this.blCurrentPut.isFull()) {
                int size = this.lsBlocks.size();
                for (int i = 0; i < size; ++i) {
                    Block block = this.lsBlocks.get(i);
                    if (block == null || block.isFull()) continue;
                    this.blCurrentPut = block;
                    return;
                }
            }
        }

        Block getCurrentPutBlock() {
            this.setCurrentPut();
            return this.blCurrentPut;
        }

        Block getCurrentTakeBlock() {
            this.setCurrentTake();
            return this.blCurrentTake;
        }

        public void setCurrentTake() {
            if (!(this.blCurrentTake != null && this.blCurrentTake.containsValidItem() || this.lsBlocks.size() <= 0)) {
                this.blCurrentTake = this.lsBlocks.get(0);
            }
        }

        public String toString() {
            return "Q{name='" + this.name + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Q)) {
                return false;
            }
            Q q = (Q)o;
            return this.name == null ? q.name == null : this.name.equals(q.name);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        void printStack() {
            System.out.println("=========================");
            System.out.println(Hazelcast.getCluster());
            System.out.println("== " + BlockingQueueManager.this.thisAddress + " ==");
            for (Block block : this.lsBlocks) {
                System.out.println(block);
            }
            System.out.println("--------------------");
            System.out.println("CurrentTake " + this.blCurrentTake);
            System.out.println("CurrentPut " + this.blCurrentPut);
            System.out.println("== " + new Date() + " ==");
        }

        public class ScheduledOfferAction
        extends ScheduledAction {
            public ScheduledOfferAction(Request request) {
                super(request);
            }

            public boolean consume() {
                this.valid = Q.this.rightPutTarget(this.request.blockId);
                if (this.valid) {
                    Q.this.offer(this.request, false);
                    this.request.response = Boolean.TRUE;
                    BlockingQueueManager.this.returnScheduledAsBoolean(this.request);
                    return true;
                }
                this.request.response = Constants.Objects.OBJECT_REDO;
                BlockingQueueManager.this.returnResponse(this.request);
                return false;
            }

            public void onExpire() {
                this.request.response = Boolean.FALSE;
                BlockingQueueManager.this.returnScheduledAsBoolean(this.request);
                Q.this.lsScheduledOfferActions.remove(this);
            }
        }

        public class ScheduledOfferFirstAction
        extends ScheduledOfferAction {
            public ScheduledOfferFirstAction(Request request) {
                super(request);
            }

            public boolean consume() {
                this.valid = Q.this.rightTakeTarget(this.request.blockId);
                if (this.valid) {
                    Q.this.offer(this.request, true);
                    this.request.response = Boolean.TRUE;
                    BlockingQueueManager.this.returnScheduledAsBoolean(this.request);
                    return true;
                }
                this.request.response = Constants.Objects.OBJECT_REDO;
                BlockingQueueManager.this.returnResponse(this.request);
                return false;
            }
        }

        public class ScheduledPollAction
        extends ScheduledAction {
            public ScheduledPollAction(Request request) {
                super(request);
            }

            public boolean consume() {
                this.valid = Q.this.rightTakeTarget(this.request.blockId);
                if (this.valid) {
                    this.request.response = Q.this.poll(this.request);
                    BlockingQueueManager.this.returnScheduledAsSuccess(this.request);
                    return true;
                }
                this.request.response = Constants.Objects.OBJECT_REDO;
                BlockingQueueManager.this.returnResponse(this.request);
                return false;
            }

            public void onExpire() {
                this.request.response = null;
                BlockingQueueManager.this.returnScheduledAsSuccess(this.request);
                Q.this.lsScheduledPollActions.remove(this);
            }
        }
    }

    class Poll
    extends BaseManager.TargetAwareOp {
        Poll() {
        }

        public Object peek(String name) {
            return this.objectCall(ClusterOperation.BLOCKING_QUEUE_PEEK, name, null, null, 0L, -1L);
        }

        public Object poll(String name, long timeout) throws InterruptedException {
            try {
                Object value = this.objectCall(ClusterOperation.BLOCKING_QUEUE_POLL, name, null, null, timeout, -1L);
                ThreadContext threadContext = ThreadContext.get();
                TransactionImpl txn = threadContext.getCallContext().getTransaction();
                if (txn != null && txn.getStatus() == 1) {
                    txn.attachRemoveOp(name, null, value, false);
                }
                return value;
            }
            catch (RuntimeInterruptedException rie) {
                throw new InterruptedException();
            }
        }

        public void setTarget() {
            Q q = BlockingQueueManager.this.getQ(this.request.name);
            Block takeBlock = q.getCurrentTakeBlock();
            if (takeBlock == null) {
                this.target = BlockingQueueManager.this.getMasterAddress();
                this.request.blockId = 0;
            } else {
                this.target = takeBlock.address;
                this.request.blockId = takeBlock.blockId;
            }
        }

        public void doLocalOp() {
            Q q = BlockingQueueManager.this.getQ(this.request.name);
            if (q.rightTakeTarget(this.request.blockId)) {
                BlockingQueueManager.this.doPoll(this.request);
                if (!this.request.scheduled) {
                    this.setResult(this.request.response);
                }
            } else {
                this.setResult(Constants.Objects.OBJECT_REDO);
            }
        }
    }

    class OfferFirst
    extends Offer {
        OfferFirst() {
        }

        public boolean offer(String name, Object value, long timeout) throws InterruptedException {
            return this.offer(name, value, timeout, true);
        }

        public boolean offer(String name, Object value, long timeout, boolean transactional) throws InterruptedException {
            return this.offer(ClusterOperation.BLOCKING_QUEUE_OFFER_FIRST, name, value, timeout, transactional);
        }

        public void setTarget() {
            Q q = BlockingQueueManager.this.getQ(this.request.name);
            Block takeBlock = q.getCurrentTakeBlock();
            if (takeBlock == null) {
                this.target = BlockingQueueManager.this.getMasterAddress();
                this.request.blockId = 0;
            } else {
                this.target = takeBlock.address;
                this.request.blockId = takeBlock.blockId;
            }
        }

        public void doLocalOp() {
            Q q = BlockingQueueManager.this.getQ(this.request.name);
            if (q.rightTakeTarget(this.request.blockId)) {
                BlockingQueueManager.this.doOfferFirst(this.request);
                if (!this.request.scheduled) {
                    this.setResult(this.request.response);
                }
            } else {
                this.setResult(Constants.Objects.OBJECT_REDO);
            }
        }
    }

    class Offer
    extends BaseManager.TargetAwareOp {
        Offer() {
        }

        public boolean offer(String name, Object value, long timeout) throws InterruptedException {
            return this.offer(ClusterOperation.BLOCKING_QUEUE_OFFER, name, value, timeout, true);
        }

        public boolean offer(String name, Object value, long timeout, boolean transactional) throws InterruptedException {
            return this.offer(ClusterOperation.BLOCKING_QUEUE_OFFER, name, value, timeout, transactional);
        }

        protected boolean offer(ClusterOperation operation, String name, Object value, long timeout, boolean transactional) throws InterruptedException {
            try {
                ThreadContext threadContext = ThreadContext.get();
                TransactionImpl txn = threadContext.getCallContext().getTransaction();
                if (!transactional || txn == null || txn.getStatus() != 1) {
                    return this.booleanCall(operation, name, null, value, timeout, -1L);
                }
                txn.attachPutOp(name, null, value, timeout, true);
                return true;
            }
            catch (RuntimeInterruptedException e) {
                throw new InterruptedException();
            }
        }

        public void setTarget() {
            this.target = BlockingQueueManager.this.getTargetForOffer(this.request);
        }

        public void doLocalOp() {
            Q q = BlockingQueueManager.this.getQ(this.request.name);
            if (q.rightPutTarget(this.request.blockId)) {
                BlockingQueueManager.this.doOffer(this.request);
                if (!this.request.scheduled) {
                    this.setResult(this.request.response);
                }
            } else {
                this.setResult(Constants.Objects.OBJECT_REDO);
            }
        }
    }

    public class Read
    extends BaseManager.QueueBasedCall {
        String name;
        int blockId;
        int index;
        int readIndex = 0;

        public Object read(String name, int blockId, int index) {
            this.name = name;
            this.blockId = blockId;
            this.index = index;
            BlockingQueueManager.this.enqueueAndReturn(this);
            try {
                Object result = this.responses.take();
                if (result == Constants.Objects.OBJECT_NULL) {
                    return null;
                }
                return ThreadContext.get().toObject((Data)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void setResponse(Data value, int index) {
            this.responses.clear();
            this.readIndex = index;
            this.responses.add(value == null ? Constants.Objects.OBJECT_NULL : value);
        }

        public void handleResponse(Packet packet) {
            Data value = packet.getValueData();
            int indexRead = (int)packet.longValue;
            this.setResponse(value, indexRead);
            BlockingQueueManager.this.removeCall(this.getCallId());
            BlockingQueueManager.this.releasePacket(packet);
        }

        public void onDisconnect(Address dead) {
            BlockingQueueManager.this.removeCall(this.getCallId());
            BlockingQueueManager.this.enqueueAndReturn(this);
        }

        public void process() {
            this.responses.clear();
            Q q = BlockingQueueManager.this.getQ(this.name);
            Address target = q.getBlockOwner(this.blockId);
            if (target == null) {
                this.responses.add(Constants.Objects.OBJECT_NULL);
            } else if (target.equals(BlockingQueueManager.this.thisAddress)) {
                q.read(this);
            } else {
                BlockingQueueManager.this.addCall(this);
                Packet packet = BlockingQueueManager.this.obtainPacket();
                packet.name = this.name;
                packet.operation = this.getOperation();
                packet.callId = this.getCallId();
                packet.blockId = this.blockId;
                packet.timeout = 0L;
                packet.longValue = this.index;
                boolean sent = BlockingQueueManager.this.send(packet, target);
                if (!sent) {
                    BlockingQueueManager.this.releasePacket(packet);
                    this.onDisconnect(target);
                }
            }
        }

        public ClusterOperation getOperation() {
            return ClusterOperation.BLOCKING_QUEUE_READ;
        }
    }

    public class Remove
    extends BaseManager.QueueBasedCall {
        String name;
        int blockId;
        int index;

        public Object remove(String name, int blockId, int index) {
            this.name = name;
            this.blockId = blockId;
            this.index = index;
            BlockingQueueManager.this.enqueueAndReturn(this);
            try {
                Object result = this.responses.take();
                if (result == Constants.Objects.OBJECT_NULL) {
                    return null;
                }
                return IOUtil.toObject((Data)result);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        void setResponse() {
            this.responses.add(Constants.Objects.OBJECT_NULL);
        }

        public void handleResponse(Packet packet) {
            this.setResponse();
            BlockingQueueManager.this.releasePacket(packet);
        }

        public void onDisconnect(Address dead) {
            this.process();
        }

        public void process() {
            Q q = BlockingQueueManager.this.getQ(this.name);
            Address target = q.getBlockOwner(this.blockId);
            if (target == null) {
                this.responses.add(Constants.Objects.OBJECT_NULL);
            } else if (target.equals(BlockingQueueManager.this.thisAddress)) {
                q.remove(this);
            } else {
                BlockingQueueManager.this.addCall(this);
                Packet packet = BlockingQueueManager.this.obtainPacket();
                packet.name = this.name;
                packet.operation = this.getOperation();
                packet.callId = this.getCallId();
                packet.blockId = this.blockId;
                packet.timeout = 0L;
                packet.longValue = this.index;
                boolean sent = false;
                if (target != null) {
                    sent = BlockingQueueManager.this.send(packet, target);
                }
                if (target == null || !sent) {
                    BlockingQueueManager.this.releasePacket(packet);
                    this.responses.add(Constants.Objects.OBJECT_NULL);
                }
            }
        }

        public ClusterOperation getOperation() {
            return ClusterOperation.BLOCKING_QUEUE_REMOVE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QIterator<E>
    implements Iterator<E>,
    Processable {
        volatile String name;
        volatile List<Integer> blocks = null;
        int currentBlockId = -1;
        int currentIndex = -1;
        Object next = null;
        int nextBlockId = -1;
        int nextIndex = -1;
        boolean hasNextCalled = false;
        Iterator txnOffers = null;

        QIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String name) {
            List<Map.Entry> txnOfferItems;
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null && (txnOfferItems = txn.newEntries(name)) != null) {
                this.txnOffers = txnOfferItems.iterator();
            }
            QIterator qIterator = this;
            synchronized (qIterator) {
                this.name = name;
                BlockingQueueManager.this.enqueueAndReturn(this);
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process() {
            Q q = BlockingQueueManager.this.getQ(this.name);
            List<Block> lsBlocks = q.lsBlocks;
            this.blocks = new ArrayList<Integer>(lsBlocks.size());
            for (Block block : lsBlocks) {
                this.blocks.add(block.blockId);
            }
            QIterator qIterator = this;
            synchronized (qIterator) {
                this.notify();
            }
        }

        @Override
        public boolean hasNext() {
            this.next = null;
            if (this.txnOffers != null) {
                boolean hasInTxn = this.txnOffers.hasNext();
                this.hasNextCalled = true;
                if (hasInTxn) {
                    this.next = this.txnOffers.next();
                    return true;
                }
                this.txnOffers = null;
            }
            while (this.next == null) {
                boolean canRead = this.setNextBlock();
                if (!canRead) {
                    return false;
                }
                Read read = new Read();
                this.next = read.read(this.name, this.currentBlockId, this.currentIndex);
                if (this.next == null) {
                    this.currentIndex = -1;
                    continue;
                }
                this.currentIndex = read.readIndex;
                this.nextBlockId = this.currentBlockId;
                this.nextIndex = this.currentIndex++;
            }
            this.hasNextCalled = true;
            return true;
        }

        boolean setNextBlock() {
            if (this.currentIndex == -1 || this.currentIndex >= BlockingQueueManager.this.BLOCK_SIZE) {
                if (this.blocks.size() == 0) {
                    return false;
                }
                this.currentBlockId = this.blocks.remove(0);
                this.currentIndex = 0;
                return true;
            }
            return true;
        }

        @Override
        public E next() {
            boolean hasNext;
            if (!this.hasNextCalled && !(hasNext = this.hasNext())) {
                return null;
            }
            if (this.next != null) {
                this.hasNextCalled = false;
            }
            return (E)this.next;
        }

        @Override
        public void remove() {
            if (this.nextBlockId != -1 && this.nextIndex != -1) {
                Remove remove = new Remove();
                remove.remove(this.name, this.nextBlockId, this.nextIndex);
            }
        }
    }

    public class QSize
    extends BaseManager.MultiCall {
        int size = 0;
        final String name;

        public int getSize() {
            int size = (Integer)this.call();
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            if (txn != null) {
                size += txn.size(this.name);
            }
            return size < 0 ? 0 : size;
        }

        public QSize(String name) {
            this.name = name;
        }

        BaseManager.SubCall createNewTargetAwareOp(Address target) {
            return new MGetSize(target);
        }

        boolean onResponse(Object response) {
            this.size += ((Long)response).intValue();
            return true;
        }

        void onCall() {
            this.size = 0;
        }

        Object returnResult() {
            return this.size;
        }

        class MGetSize
        extends BaseManager.SubCall {
            public MGetSize(Address target) {
                super(target);
                this.request.name = QSize.this.name;
                this.request.operation = ClusterOperation.BLOCKING_QUEUE_SIZE;
                this.request.setLongRequest();
            }

            public void doLocalOp() {
                Q q = BlockingQueueManager.this.getQ(QSize.this.name);
                this.request.response = (long)q.size();
                this.setResult(this.request.response);
            }
        }
    }

    public class CommitPoll
    extends BaseManager.AbstractCall {
        volatile long txnId = -1L;
        String name = null;

        public ClusterOperation getOperation() {
            return ClusterOperation.BLOCKING_QUEUE_TXN_COMMIT;
        }

        public void commitPoll(String name) {
            this.name = name;
            TransactionImpl txn = ThreadContext.get().getCallContext().getTransaction();
            this.txnId = txn.getId();
            BlockingQueueManager.this.enqueueAndReturn(this);
        }

        public void handleResponse(Packet packet) {
        }

        public void process() {
            MemberImpl nextMember = BlockingQueueManager.this.getNextMemberAfter(BlockingQueueManager.this.thisAddress, true, 1);
            if (nextMember != null) {
                Address next = nextMember.getAddress();
                Packet packet = BlockingQueueManager.this.obtainPacket();
                packet.name = this.name;
                packet.operation = this.getOperation();
                packet.txnId = this.txnId;
                boolean sent = BlockingQueueManager.this.send(packet, next);
                if (!sent) {
                    BlockingQueueManager.this.releasePacket(packet);
                }
            }
        }
    }

    class BlockBackupSync
    implements Processable {
        final Block block;
        final Q q;
        int index = 0;
        volatile boolean done = false;

        public BlockBackupSync(Q q, Block block) {
            this.q = q;
            this.block = block;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            BackupData backupdata = this.next();
            if (backupdata != null) {
                this.q.sendBackup(true, BlockingQueueManager.this.thisAddress, backupdata.data, this.block.blockId, backupdata.index);
            } else {
                this.done = true;
            }
            BlockBackupSync blockBackupSync = this;
            synchronized (blockBackupSync) {
                this.notify();
            }
        }

        private BackupData next() {
            while (this.index < BlockingQueueManager.this.BLOCK_SIZE) {
                Data data;
                int dataIndex;
                ++this.index;
                QData qData = this.block.get(dataIndex);
                if (qData == null || (data = qData.data) == null || data.size() == 0) continue;
                return new BackupData(data, dataIndex);
            }
            return null;
        }

        class BackupData {
            final Data data;
            final int index;

            BackupData(Data data, int index) {
                this.data = data;
                this.index = index;
            }
        }
    }

    class BlockBackupSyncRunner
    extends FallThroughRunnable {
        final BlockBackupSync blockSync;

        public BlockBackupSyncRunner(BlockBackupSync blockSync) {
            this.blockSync = blockSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            while (!this.blockSync.done) {
                try {
                    BlockBackupSync blockBackupSync = this.blockSync;
                    synchronized (blockBackupSync) {
                        BlockingQueueManager.this.enqueueAndReturn(this.blockSync);
                        this.blockSync.wait();
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    abstract class QueuePacketProcessor
    implements PacketProcessor {
        QueuePacketProcessor() {
        }

        public void process(Packet packet) {
            boolean callerKnownMember;
            boolean bl = callerKnownMember = BlockingQueueManager.this.getMember(packet.conn.getEndPoint()) != null;
            if (!callerKnownMember) {
                BlockingQueueManager.this.sendRedoResponse(packet);
            } else {
                this.processPacket(packet);
            }
        }

        abstract void processPacket(Packet var1);
    }
}

