/*
 * Decompiled with CFR 0.152.
 */
package play.modules.hazelcast;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import play.cache.CacheImpl;
import play.exceptions.CacheException;
import play.modules.hazelcast.HazelcastPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastCacheImpl
implements CacheImpl {
    private static HazelcastInstance manager = HazelcastPlugin.getHazel();
    private static HazelcastCacheImpl instance = new HazelcastCacheImpl();
    private static IMap<String, Object> cache;

    private HazelcastCacheImpl() {
        cache = manager.getMap("cache");
    }

    public static synchronized HazelcastCacheImpl getInstance() {
        if (instance == null) {
            instance = new HazelcastCacheImpl();
        }
        return instance;
    }

    public void add(String key, Object value, int expiration) {
        cache.putIfAbsent((Object)key, value, (long)expiration, TimeUnit.SECONDS);
    }

    public void clear() {
        if (cache != null) {
            try {
                cache.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public long decr(String key, int by) {
        AtomicNumber count = manager.getAtomicNumber(key);
        count.set(count.get() - (long)by);
        return count.get();
    }

    public void delete(String key) {
        cache.remove((Object)key);
    }

    public Object get(String key) {
        return cache.get((Object)key);
    }

    public Map<String, Object> get(String[] keys) {
        HashMap<String, Object> result = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            result.put(key, this.get(key));
        }
        return result;
    }

    public long incr(String key, int by) {
        AtomicNumber count = manager.getAtomicNumber(key);
        count.set(count.get() + (long)by);
        return count.get();
    }

    public void replace(String key, Object value, int expiration) {
        if (cache.containsKey((Object)key)) {
            cache.put((Object)key, value, (long)expiration, TimeUnit.SECONDS);
        }
    }

    public boolean safeAdd(String key, Object value, int expiration) {
        try {
            this.add(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean safeDelete(String key) {
        try {
            this.delete(key);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean safeReplace(String key, Object value, int expiration) {
        try {
            this.replace(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean safeSet(String key, Object value, int expiration) {
        try {
            this.set(key, value, expiration);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void set(String key, Object value, int expiration) {
        cache.put((Object)key, value, (long)expiration, TimeUnit.SECONDS);
    }

    public void stop() {
        instance = null;
        cache = null;
    }

    static void checkSerializable(Object value) {
        if (value != null && !(value instanceof Serializable)) {
            throw new CacheException("Cannot cache a non-serializable value of type " + value.getClass().getName(), (Throwable)new NotSerializableException(value.getClass().getName()));
        }
    }
}

