/*
 * Decompiled with CFR 0.152.
 */
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import play.cache.Cache;
import play.modules.hazelcast.HazelcastCacheImpl;
import play.test.UnitTest;

public class CacheTest
extends UnitTest {
    @Before
    public void before() {
        Cache.clear();
    }

    @After
    public void after() {
        Cache.clear();
    }

    @Test
    public void testCacheName() {
        String cacheName = Cache.cacheImpl.getClass().getName();
        CacheTest.assertEquals((String)"Instance Cache is NOT OK", (Object)HazelcastCacheImpl.class.getName(), (Object)cacheName);
    }

    @Test
    public void testCache() {
        Cache.add((String)"test", (Object)"bidon de daube");
        String test = (String)Cache.get((String)"test", String.class);
        CacheTest.assertEquals((Object)"bidon de daube", (Object)test);
    }

    @Test
    public void testIncr() {
        long a = Cache.incr((String)"counteur");
        CacheTest.assertTrue((a > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testDecr() {
        long a = Cache.decr((String)"counteur");
        CacheTest.assertTrue((a == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testIncrBy2() {
        long a = Cache.incr((String)"counteur", (int)2);
        CacheTest.assertTrue((a == 2L ? 1 : 0) != 0);
    }

    @Test
    public void testDecrBy2() {
        long a = Cache.decr((String)"counteur", (int)2);
        CacheTest.assertTrue((a == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testIncrBy10() {
        long a = Cache.incr((String)"counteur", (int)10);
        CacheTest.assertTrue((a == 10L ? 1 : 0) != 0);
    }

    @Test
    public void testDecrBy5() {
        long a = Cache.decr((String)"counteur", (int)5);
        CacheTest.assertTrue((a == 5L ? 1 : 0) != 0);
    }

    @Test
    public void testDecrBy5Again() {
        long a = Cache.decr((String)"counteur", (int)5);
        CacheTest.assertTrue((a == 0L ? 1 : 0) != 0);
    }

    @Test
    public void testDelete() {
        Cache.delete((String)"counteur");
        CacheTest.assertNull((Object)Cache.get((String)"counteur"));
    }

    @Test
    public void testAddExisting() {
        Cache.add((String)"testAddExisting", (Object)"value1");
        Cache.add((String)"testAddExisting", (Object)"value2");
        String actual = (String)Cache.get((String)"testAddExisting", String.class);
        CacheTest.assertEquals((Object)"value1", (Object)actual);
    }

    @Test
    public void testReplace() {
        Cache.add((String)"testReplace", (Object)"value1");
        Cache.replace((String)"testReplace", (Object)"value2");
        String actual = (String)Cache.get((String)"testReplace", String.class);
        CacheTest.assertEquals((Object)"value2", (Object)actual);
    }

    @Test
    public void testExpiration() {
        Cache.set((String)"testExpiration", (Object)"testExpiration", (String)"1s");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String actual = (String)Cache.get((String)"testExpiration", String.class);
        CacheTest.assertNull((Object)actual);
    }
}

