/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.NoMemberAvailableException;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalCountDownLatchStats;
import java.util.concurrent.TimeUnit;

public class CountDownLatchClientProxy
implements ICountDownLatch {
    private final String name;
    private final ProxyHelper proxyHelper;

    public CountDownLatchClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    public void await() throws InstanceDestroyedException, MemberLeftException, InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean await(long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException, InterruptedException {
        try {
            return (Boolean)this.proxyHelper.doOp(ClusterOperation.COUNT_DOWN_LATCH_AWAIT, null, null, timeout, unit);
        }
        catch (RuntimeException re) {
            Throwable e = re.getCause();
            if (e instanceof InstanceDestroyedException) {
                throw (InstanceDestroyedException)e;
            }
            if (e instanceof MemberLeftException) {
                throw (MemberLeftException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (re instanceof NoMemberAvailableException) {
                throw new IllegalStateException();
            }
            throw re;
        }
    }

    public void countDown() {
        this.proxyHelper.doOp(ClusterOperation.COUNT_DOWN_LATCH_COUNT_DOWN, null, null);
    }

    public int getCount() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.COUNT_DOWN_LATCH_GET_COUNT, null, null);
    }

    public Member getOwner() {
        return (Member)this.proxyHelper.doOp(ClusterOperation.COUNT_DOWN_LATCH_GET_OWNER, null, null);
    }

    public boolean hasCount() {
        return this.getCount() > 0;
    }

    public boolean setCount(int count) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.COUNT_DOWN_LATCH_SET_COUNT, null, count);
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.COUNT_DOWN_LATCH;
    }

    public String getName() {
        return this.name.substring("d:".length());
    }

    public LocalCountDownLatchStats getLocalCountDownLatchStats() {
        throw new UnsupportedOperationException();
    }
}

