/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.connection;

import com.heroku.api.Heroku;
import com.heroku.api.LoginVerification;
import com.heroku.api.connection.AsyncConnection;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionProvider;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.LoginRequest;
import com.heroku.api.request.Request;
import com.heroku.api.request.login.BasicAuthLogin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;

public class HttpClientConnection
implements AsyncConnection<Future<?>> {
    private DefaultHttpClient httpClient = this.getHttpClient();
    private volatile ExecutorService executorService;
    private Object lock = new Object();
    private final String apiKey;

    public HttpClientConnection() {
        this.apiKey = null;
    }

    public HttpClientConnection(LoginRequest login) {
        LoginVerification loginVerification = (LoginVerification)this.execute((Request)login);
        this.apiKey = loginVerification.getApiKey();
        this.setHttpClientCredentials(this.apiKey);
    }

    public HttpClientConnection(String apiKey) {
        this.apiKey = apiKey;
        this.setHttpClientCredentials(this.apiKey);
    }

    private void setHttpClientCredentials(String apiKey) {
        URL endpoint = HttpUtil.toURL((String)Heroku.Config.ENDPOINT.value);
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(endpoint.getHost(), endpoint.getPort()), (Credentials)new UsernamePasswordCredentials("", apiKey));
    }

    public <T> Future<T> executeAsync(final Request<T> request) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return HttpClientConnection.this.execute(request);
            }
        };
        return this.getExecutorService().submit(callable);
    }

    public <T> T execute(Request<T> request) {
        try {
            HttpRequestBase message = this.getHttpRequestBase(request.getHttpMethod(), Heroku.Config.ENDPOINT.value + request.getEndpoint());
            message.setHeader("X-Heroku-API-Version", String.valueOf(Heroku.ApiVersion.v2.version));
            message.setHeader(request.getResponseType().getHeaderName(), request.getResponseType().getHeaderValue());
            for (Map.Entry header : request.getHeaders().entrySet()) {
                message.setHeader((String)header.getKey(), (String)header.getValue());
            }
            if (request.hasBody()) {
                ((HttpEntityEnclosingRequestBase)message).setEntity((HttpEntity)new StringEntity(request.getBody()));
            }
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)message);
            return (T)request.getResponse(HttpUtil.getBytes((InputStream)httpResponse.getEntity().getContent()), httpResponse.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException("exception while executing request", e);
        }
    }

    private HttpRequestBase getHttpRequestBase(Http.Method httpMethod, String endpoint) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(endpoint);
            }
            case PUT: {
                return new HttpPut(endpoint);
            }
            case POST: {
                return new HttpPost(endpoint);
            }
            case DELETE: {
                return new HttpDelete(endpoint);
            }
        }
        throw new UnsupportedOperationException(httpMethod + " is not a supported request type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = this.createExecutorService();
                }
            }
        }
        return this.executorService;
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setDaemon(true);
                return t;
            }
        });
    }

    protected DefaultHttpClient getHttpClient() {
        SSLSocketFactory ssf = new SSLSocketFactory(Heroku.herokuSSLContext());
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager();
        if (!Heroku.Config.ENDPOINT.isDefault()) {
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
        }
        return new DefaultHttpClient((ClientConnectionManager)ccm);
    }

    public void close() {
        this.getExecutorService().shutdownNow();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public static class Provider
    implements ConnectionProvider {
        public Connection get(String username, String password) {
            return new HttpClientConnection((LoginRequest)new BasicAuthLogin(username, password));
        }

        public Connection get(String apiKey) {
            return new HttpClientConnection(apiKey);
        }
    }
}

