/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api;

import com.heroku.api.Addon;
import com.heroku.api.AddonChange;
import com.heroku.api.App;
import com.heroku.api.Collaborator;
import com.heroku.api.Heroku;
import com.heroku.api.Key;
import com.heroku.api.Proc;
import com.heroku.api.Release;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionFactory;
import com.heroku.api.request.addon.AddonInstall;
import com.heroku.api.request.addon.AddonList;
import com.heroku.api.request.addon.AddonRemove;
import com.heroku.api.request.addon.AppAddonsList;
import com.heroku.api.request.app.AppCreate;
import com.heroku.api.request.app.AppDestroy;
import com.heroku.api.request.app.AppInfo;
import com.heroku.api.request.app.AppList;
import com.heroku.api.request.app.AppRename;
import com.heroku.api.request.config.ConfigAdd;
import com.heroku.api.request.config.ConfigList;
import com.heroku.api.request.config.ConfigRemove;
import com.heroku.api.request.key.KeyAdd;
import com.heroku.api.request.key.KeyList;
import com.heroku.api.request.key.KeyRemove;
import com.heroku.api.request.log.Log;
import com.heroku.api.request.log.LogStreamResponse;
import com.heroku.api.request.ps.ProcessList;
import com.heroku.api.request.ps.Restart;
import com.heroku.api.request.ps.Scale;
import com.heroku.api.request.releases.ListReleases;
import com.heroku.api.request.releases.ReleaseInfo;
import com.heroku.api.request.releases.Rollback;
import com.heroku.api.request.run.Run;
import com.heroku.api.request.run.RunResponse;
import com.heroku.api.request.sharing.CollabList;
import com.heroku.api.request.sharing.SharingAdd;
import com.heroku.api.request.sharing.SharingRemove;
import com.heroku.api.request.sharing.SharingTransfer;
import java.util.List;
import java.util.Map;

public class HerokuAPI {
    final Connection connection;

    public static String obtainApiKey(String username, String password) {
        return ConnectionFactory.get(username, password).getApiKey();
    }

    public HerokuAPI(String apiKey) {
        this(ConnectionFactory.get(apiKey));
    }

    public HerokuAPI(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getApiKey() {
        return this.connection.getApiKey();
    }

    public void addKey(String sshKey) {
        this.connection.execute(new KeyAdd(sshKey));
    }

    public void removeKey(String sshKey) {
        this.connection.execute(new KeyRemove(sshKey));
    }

    public List<Key> listKeys() {
        return this.connection.execute(new KeyList());
    }

    public List<App> listApps() {
        return this.connection.execute(new AppList());
    }

    public App getApp(String name) {
        return this.connection.execute(new AppInfo(name));
    }

    public App createApp() {
        return this.connection.execute(new AppCreate(new App().on(Heroku.Stack.Cedar)));
    }

    public App createApp(App app) {
        return this.connection.execute(new AppCreate(app));
    }

    public String renameApp(String appName, String newName) {
        return this.connection.execute(new AppRename(appName, newName)).getName();
    }

    public void destroyApp(String appName) {
        this.connection.execute(new AppDestroy(appName));
    }

    public AddonChange addAddon(String appName, String addonName) {
        return this.connection.execute(new AddonInstall(appName, addonName));
    }

    public List<Addon> listAllAddons() {
        return this.connection.execute(new AddonList());
    }

    public List<Addon> listAppAddons(String appName) {
        return this.connection.execute(new AppAddonsList(appName));
    }

    public AddonChange removeAddon(String appName, String addonName) {
        return this.connection.execute(new AddonRemove(appName, addonName));
    }

    public void scaleProcess(String appName, String processType, int quantity) {
        this.connection.execute(new Scale(appName, processType, quantity));
    }

    public List<Proc> listProcesses(String appName) {
        return this.connection.execute(new ProcessList(appName));
    }

    public List<Release> listReleases(String appName) {
        return this.connection.execute(new ListReleases(appName));
    }

    public String rollback(String appName, String releaseName) {
        return this.connection.execute(new Rollback(appName, releaseName));
    }

    public Release getReleaseInfo(String appName, String releaseName) {
        return this.connection.execute(new ReleaseInfo(appName, releaseName));
    }

    public List<Collaborator> listCollaborators(String appName) {
        return this.connection.execute(new CollabList(appName));
    }

    public void addCollaborator(String appName, String collaborator) {
        this.connection.execute(new SharingAdd(appName, collaborator));
    }

    public void removeCollaborator(String appName, String collaborator) {
        this.connection.execute(new SharingRemove(appName, collaborator));
    }

    public void addConfig(String appName, Map<String, String> config) {
        String jsonConfig = "{";
        String separator = "";
        for (Map.Entry<String, String> configEntry : config.entrySet()) {
            jsonConfig = jsonConfig.concat(String.format("%s \"%s\":\"%s\"", separator, configEntry.getKey(), configEntry.getValue()));
            separator = ",";
        }
        jsonConfig = jsonConfig.concat("}");
        this.connection.execute(new ConfigAdd(appName, jsonConfig));
    }

    public Map<String, String> listConfig(String appName) {
        return this.connection.execute(new ConfigList(appName));
    }

    public Map<String, String> removeConfig(String appName, String configVarName) {
        return this.connection.execute(new ConfigRemove(appName, configVarName));
    }

    public void transferApp(String appName, String to) {
        this.connection.execute(new SharingTransfer(appName, to));
    }

    public LogStreamResponse getLogs(String appName) {
        return this.connection.execute(new Log(appName));
    }

    public LogStreamResponse getLogs(Log.LogRequestBuilder logRequest) {
        return this.connection.execute(new Log(logRequest));
    }

    public void run(String appName, String command) {
        this.connection.execute(new Run(appName, command));
    }

    public RunResponse runAttached(String appName, String command) {
        return this.connection.execute(new Run(appName, command, true));
    }

    public void restart(String appName) {
        this.connection.execute(new Restart(appName));
    }

    public void restartProcessByType(String appName, String type) {
        this.connection.execute(new Restart.ProcessTypeRestart(appName, type));
    }

    public void restartProcessByName(String appName, String procName) {
        this.connection.execute(new Restart.NamedProcessRestart(appName, procName));
    }
}

