/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.connection;

import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionProvider;
import java.util.ServiceLoader;

public class ConnectionFactory {
    static final ServiceLoader<ConnectionProvider> loader = ServiceLoader.load(ConnectionProvider.class, ConnectionFactory.class.getClassLoader());

    public static Connection get(String username, String password) {
        for (ConnectionProvider cp : loader) {
            Connection conn = cp.get(username, password);
            if (conn == null) continue;
            return conn;
        }
        throw new IllegalArgumentException("ConnectionProvider not found for " + username);
    }

    public static Connection get(String apiKey) {
        for (ConnectionProvider cp : loader) {
            Connection conn = cp.get(apiKey);
            if (conn == null) continue;
            return conn;
        }
        throw new IllegalArgumentException("ConnectionProvider not found for " + apiKey);
    }
}

