/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.parser;

import com.heroku.api.exception.ParseException;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Parser;
import com.heroku.api.request.Request;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.ServiceLoader;

public class Json {
    public static <T> T parse(byte[] data, Class<? extends Request<T>> classType) {
        ParameterizedType parameterizedType = Json.findParameterizedType(classType);
        Type type = parameterizedType.getActualTypeArguments()[0];
        try {
            return Holder.parser.parse(data, type);
        }
        catch (RuntimeException e) {
            String json = HttpUtil.getUTF8String(data);
            throw new RuntimeException("Failed to parse JSON:" + json, e);
        }
    }

    private static ParameterizedType findParameterizedType(Class<?> classType) {
        Type[] genericInterfaces;
        for (Type interfaceType : genericInterfaces = classType.getGenericInterfaces()) {
            if (interfaceType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)interfaceType;
                if (!Request.class.equals((Object)parameterizedType.getRawType())) continue;
                return parameterizedType;
            }
            if (!(interfaceType instanceof Class)) continue;
            return Json.findParameterizedType((Class)interfaceType);
        }
        throw new ParseException("Request<T> was not found for " + classType.toString());
    }

    static class Holder {
        static Parser parser;

        Holder() {
        }

        static {
            ServiceLoader<Parser> loader = ServiceLoader.load(Parser.class, Parser.class.getClassLoader());
            Iterator<Parser> iterator = loader.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Unable to load a JSONProvider, please make sure you have a com.heroku.api.json.JSONParser implementationon your classpath that can be discovered and loaded via java.util.ServiceLoader");
            }
            parser = iterator.next();
        }
    }
}

