/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.app;

import com.heroku.api.App;
import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.XmlParser;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class AppInfo
implements Request<App> {
    private final RequestConfig config;

    public AppInfo(String appName) {
        this.config = new RequestConfig().app(appName);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.App.format(this.config.get(Heroku.RequestKey.AppName));
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.XML;
    }

    @Override
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>();
    }

    @Override
    public App getResponse(byte[] data, int code) {
        if (code == 200) {
            return (App)new XmlParser().parse(data, (Type)((Object)App.class));
        }
        throw new RequestFailedException("Unable to get app appInfo", code, data);
    }
}

