/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.key;

import com.heroku.api.Heroku;
import com.heroku.api.Key;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.XmlParser;
import com.heroku.api.request.Request;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;

public class KeyList
implements Request<List<Key>> {
    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Keys.value;
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.XML;
    }

    @Override
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>();
    }

    @Override
    public List<Key> getResponse(byte[] bytes, int status) {
        if (status == Http.Status.OK.statusCode) {
            if (new String(bytes).contains("nil-classes")) {
                return new ArrayList<Key>();
            }
            Keys keys = (Keys)new XmlParser().parse(bytes, (Type)((Object)Keys.class));
            return keys.getKey();
        }
        throw new RequestFailedException("Unable to list keys.", status, bytes);
    }

    @XmlRootElement
    static class Keys {
        List<Key> keys;

        Keys() {
        }

        public List<Key> getKey() {
            return this.keys;
        }

        public void setKey(List<Key> keylist) {
            this.keys = keylist;
        }
    }
}

