/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.run;

import com.heroku.api.exception.HerokuAPIException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URI;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class RunResponse {
    String slug;
    String command;
    String upid;
    String process;
    String action;
    URI rendezvous_url;
    String type;
    int elapsed;
    boolean attached;
    String transitioned_at;
    String state;

    public String getSlug() {
        return this.slug;
    }

    private void setSlug(String slug) {
        this.slug = slug;
    }

    public String getCommand() {
        return this.command;
    }

    private void setCommand(String command) {
        this.command = command;
    }

    public String getUpid() {
        return this.upid;
    }

    private void setUpid(String upid) {
        this.upid = upid;
    }

    public String getProcess() {
        return this.process;
    }

    private void setProcess(String process) {
        this.process = process;
    }

    public String getAction() {
        return this.action;
    }

    private void setAction(String action) {
        this.action = action;
    }

    public URI getRendezvous_url() {
        return this.rendezvous_url;
    }

    private void setRendezvous_url(URI rendezvous_url) {
        this.rendezvous_url = rendezvous_url;
    }

    public String getType() {
        return this.type;
    }

    private void setType(String type) {
        this.type = type;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    private void setElapsed(int elapsed) {
        this.elapsed = elapsed;
    }

    public boolean isAttached() {
        return this.attached;
    }

    private void setAttached(boolean attached) {
        this.attached = attached;
    }

    public String getTransitioned_at() {
        return this.transitioned_at;
    }

    private void setTransitioned_at(String transitioned_at) {
        this.transitioned_at = transitioned_at;
    }

    public String getState() {
        return this.state;
    }

    private void setState(String state) {
        this.state = state;
    }

    public InputStream attach() {
        if (!this.attached) {
            throw new IllegalStateException("The process was not started as attached, and has probably already executed. Check your app logs");
        }
        try {
            String host = this.rendezvous_url.getHost();
            int port = this.rendezvous_url.getPort();
            String secret = this.rendezvous_url.getPath().substring(1);
            SocketFactory socketFactory = SSLSocketFactory.getDefault();
            Socket socket = socketFactory.createSocket(host, port);
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            OutputStreamWriter owriter = new OutputStreamWriter(out);
            BufferedWriter writer = new BufferedWriter(owriter);
            writer.write(secret);
            writer.flush();
            InputStreamReader ireader = new InputStreamReader(in);
            BufferedReader reader = new BufferedReader(ireader);
            reader.readLine();
            return in;
        }
        catch (IOException e) {
            throw new HerokuAPIException("IOException while running process", e);
        }
    }
}

