/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.herokudeployer;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschSession;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;

public class HerokuSshSessionFactory
extends SshSessionFactory {
    public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        String user = uri.getUser();
        String pass = uri.getPass();
        String host = uri.getHost();
        int port = uri.getPort();
        try {
            File herokuKey = new File(System.getProperty("user.home") + File.separator + ".ssh", "heroku_rsa");
            JSch jsch = new JSch();
            jsch.addIdentity(herokuKey.getAbsolutePath());
            jsch.setKnownHosts(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("known_hosts"));
            Session session = jsch.getSession(user, host);
            if (!session.isConnected()) {
                session.connect(tms);
            }
            return new JschSession(session, uri);
        }
        catch (JSchException je) {
            Throwable c = je.getCause();
            if (c instanceof UnknownHostException) {
                throw new TransportException(uri, JGitText.get().unknownHost);
            }
            if (c instanceof ConnectException) {
                throw new TransportException(uri, c.getMessage());
            }
            throw new TransportException(uri, je.getMessage(), (Throwable)je);
        }
    }
}

