/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.addon;

import com.heroku.api.Addon;
import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AppAddonsList
implements Request<List<Addon>> {
    private final RequestConfig config;

    public AppAddonsList(String appName) {
        this.config = new RequestConfig().app(appName);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.AppAddons.format(this.config.get(Heroku.RequestKey.AppName));
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public List<Addon> getResponse(byte[] bytes, int status) {
        if (status == Http.Status.OK.statusCode) {
            return (List)Json.parse(bytes, this.getClass());
        }
        throw new RequestFailedException("Unable to get addons for " + this.config.get(Heroku.RequestKey.AppName), status, bytes);
    }
}

