/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.key;

import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import com.heroku.api.response.Unit;
import java.util.Collections;
import java.util.Map;

public class KeyRemove
implements Request<Unit> {
    private final RequestConfig config;

    public KeyRemove(String keyName) {
        this.config = new RequestConfig().with(Heroku.RequestKey.SSHKey, keyName);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.DELETE;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Key.format(this.config.get(Heroku.RequestKey.SSHKey));
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public Unit getResponse(byte[] in, int code) {
        if (code == Http.Status.OK.statusCode) {
            return Unit.unit;
        }
        throw new RequestFailedException("KeysRemove failed", code, in);
    }
}

