/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.log;

import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import com.heroku.api.request.log.LogStreamResponse;
import java.net.URL;
import java.util.Collections;
import java.util.Map;

public class Log
implements Request<LogStreamResponse> {
    private final RequestConfig config;

    public Log(String app) {
        this(Log.logFor(app).getConfig());
    }

    public Log(String app, boolean tail) {
        this(Log.logFor(app).tail(tail).getConfig());
    }

    Log(RequestConfig config) {
        this.config = config;
    }

    public Log(LogRequestBuilder logRequest) {
        this(logRequest.getConfig());
    }

    public static LogRequestBuilder logFor(String app) {
        return new LogRequestBuilder().app(app);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Logs.format(this.config.get(Heroku.RequestKey.AppName), HttpUtil.encodeParameters(this.config, Heroku.RequestKey.Logplex, Heroku.RequestKey.LogNum, Heroku.RequestKey.ProcessName, Heroku.RequestKey.LogSource, Heroku.RequestKey.LogTail));
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        return null;
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.TEXT;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public LogStreamResponse getResponse(byte[] bytes, int status) {
        if (status == 200) {
            try {
                URL logs = HttpUtil.toURL(new String(bytes));
                return new LogStreamResponse(logs);
            }
            catch (RuntimeException e) {
                throw new RequestFailedException(e.getMessage(), status, bytes);
            }
        }
        throw new RequestFailedException("Unable to get logs", status, bytes);
    }

    public static class LogRequestBuilder {
        RequestConfig config = new RequestConfig().with(Heroku.RequestKey.Logplex, "true");

        public Log getRequest() {
            return new Log(this.config);
        }

        RequestConfig getConfig() {
            return this.config;
        }

        LogRequestBuilder add(Heroku.RequestKey key, String val) {
            this.config = this.config.with(key, val);
            return this;
        }

        public LogRequestBuilder app(String app) {
            return this.add(Heroku.RequestKey.AppName, app);
        }

        public LogRequestBuilder num(int num) {
            return this.add(Heroku.RequestKey.LogNum, String.valueOf(num));
        }

        public LogRequestBuilder ps(String processName) {
            return this.add(Heroku.RequestKey.ProcessName, processName);
        }

        public LogRequestBuilder source(String source) {
            return this.add(Heroku.RequestKey.LogSource, source);
        }

        public LogRequestBuilder tail(boolean tail) {
            return tail ? this.add(Heroku.RequestKey.LogTail, "1") : this;
        }
    }
}

