/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api;

import com.heroku.api.exception.HerokuAPIException;
import com.heroku.api.http.Http;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Heroku {
    public static SSLContext herokuSSLContext() {
        return Heroku.sslContext(Config.ENDPOINT.isDefault());
    }

    public static SSLContext sslContext(boolean verify) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            TrustManager[] tmgrs = null;
            if (!verify) {
                tmgrs = Heroku.trustAllTrustManagers();
            }
            ctx.init(null, tmgrs, null);
            return ctx;
        }
        catch (NoSuchAlgorithmException e) {
            throw new HerokuAPIException("NoSuchAlgorithmException while trying to setup SSLContext", e);
        }
        catch (KeyManagementException e) {
            throw new HerokuAPIException("KeyManagementException while trying to setup SSLContext", e);
        }
    }

    public static HostnameVerifier hostnameVerifier(boolean verify) {
        HostnameVerifier verifier = HttpsURLConnection.getDefaultHostnameVerifier();
        if (!verify) {
            verifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            };
        }
        return verifier;
    }

    public static HostnameVerifier herokuHostnameVerifier() {
        return Heroku.hostnameVerifier(Config.ENDPOINT.isDefault());
    }

    public static TrustManager[] trustAllTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
    }

    public static enum ApiVersion implements Http.Header
    {
        v2(2),
        v3(3);

        public static final String HEADER = "X-Heroku-API-Version";
        public final int version;

        private ApiVersion(int version) {
            this.version = version;
        }

        @Override
        public String getHeaderName() {
            return HEADER;
        }

        @Override
        public String getHeaderValue() {
            return Integer.toString(this.version);
        }
    }

    public static enum Resource {
        Login("/login"),
        Apps("/apps"),
        App("/apps/%s"),
        Addons("/addons"),
        AppAddons(Resource.App.value + "/addons"),
        AppAddon(Resource.AppAddons.value + "/%s"),
        User("/user"),
        Key(Resource.User.value + "/keys/%s"),
        Keys(Resource.User.value + "/keys"),
        Collaborators(Resource.App.value + "/collaborators"),
        Collaborator(Resource.Collaborators.value + "/%s"),
        ConfigVars(Resource.App.value + "/config_vars"),
        ConfigVar(Resource.ConfigVars.value + "/%s"),
        Logs(Resource.App.value + "/logs?%s"),
        Process(Resource.App.value + "/ps"),
        Restart(Resource.Process.value + "/restart"),
        Stop(Resource.Process.value + "/stop"),
        Scale(Resource.Process.value + "/scale"),
        Releases(Resource.App.value + "/releases"),
        Release(Resource.Releases.value + "/%s"),
        Status(Resource.App.value + "/status"),
        AppStack(Resource.App.value + "/stack");

        public final String value;

        private Resource(String value) {
            this.value = value;
        }

        public String format(String ... values) {
            return String.format(this.value, values);
        }
    }

    public static enum Stack {
        Aspen("aspen-mri-1.8.6"),
        Bamboo192("bamboo-mri-1.9.2"),
        Bamboo187("bamboo-ree-1.8.7"),
        Cedar("cedar");

        public final String value;
        private static final Map<String, Stack> stringToEnum;

        private Stack(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Stack fromString(String stackName) {
            return stringToEnum.get(stackName);
        }

        static {
            stringToEnum = new HashMap<String, Stack>();
            for (Stack s : Stack.values()) {
                stringToEnum.put(s.toString(), s);
            }
        }
    }

    public static enum RequestKey {
        Stack("app[stack]"),
        CreateAppName("app[name]"),
        Remote("remote"),
        Timeout("timeout"),
        Addons("addons"),
        AddonName("addon"),
        Attach("attach"),
        Requested("requested"),
        Beta("beta"),
        AppName("name"),
        SSHKey("sshkey"),
        Config("config"),
        Command("command"),
        Collaborator("collaborator[email]"),
        TransferOwner("app[transfer_owner]"),
        ConfigVars("config_vars"),
        ConfigVarName("key"),
        ProcessType("type"),
        ProcessName("ps"),
        Quantity("qty"),
        Username("username"),
        Password("password"),
        Logplex("logplex"),
        LogNum("num"),
        LogSource("source"),
        LogTail("tail"),
        Release("release"),
        Rollback("rollback");

        public final String queryParameter;

        private RequestKey(String queryParameter) {
            this.queryParameter = queryParameter;
        }
    }

    public static enum ResponseKey {
        Name("name"),
        DomainName("domain_name"),
        CreateStatus("create_status"),
        Stack("stack"),
        SlugSize("slug_size"),
        RequestedStack("requested_stack"),
        CreatedAt("created_at"),
        WebUrl("web_url"),
        RepoMigrateStatus("repo_migrate_status"),
        Id("id"),
        GitUrl("git_url"),
        RepoSize("repo_size"),
        Dynos("dynos"),
        Workers("workers");

        public final String value;
        private static final Map<String, ResponseKey> stringToResponseKey;

        private ResponseKey(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static ResponseKey fromString(String keyName) {
            return stringToResponseKey.get(keyName);
        }

        static {
            stringToResponseKey = new HashMap<String, ResponseKey>();
            for (ResponseKey key : ResponseKey.values()) {
                stringToResponseKey.put(key.toString(), key);
            }
        }
    }

    public static enum JarProperties {

        static final Properties properties = new Properties();

        public static String getProperty(String propName) {
            return properties.getProperty(propName);
        }

        public static Properties getProperties() {
            return properties;
        }

        static {
            try {
                InputStream jarProps = JarProperties.class.getResourceAsStream("/heroku.jar.properties");
                properties.load(jarProps);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Config {
        ENDPOINT("HEROKU_HOST", "heroku.host", "heroku.com");

        public final String environmentVariable;
        public final String systemProperty;
        public final String defaultValue;
        public final String value;

        private Config(String environmentVariable, String systemProperty, String defaultValue) {
            this.environmentVariable = environmentVariable;
            this.systemProperty = systemProperty;
            this.defaultValue = defaultValue;
            String envVal = System.getenv(environmentVariable);
            String configVal = System.getProperty(systemProperty, envVal == null ? defaultValue : envVal);
            this.value = configVal.matches("^https?:\\/\\/.*") ? configVal : "https://api." + configVal;
        }

        public boolean isDefault() {
            return this.defaultValue.equals(this.value);
        }
    }
}

