/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api;

import com.heroku.api.Addon;
import com.heroku.api.AddonChange;
import com.heroku.api.App;
import com.heroku.api.Collaborator;
import com.heroku.api.Heroku;
import com.heroku.api.Key;
import com.heroku.api.Proc;
import com.heroku.api.Release;
import com.heroku.api.StackInfo;
import com.heroku.api.User;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionFactory;
import com.heroku.api.request.addon.AddonInstall;
import com.heroku.api.request.addon.AddonList;
import com.heroku.api.request.addon.AddonRemove;
import com.heroku.api.request.addon.AppAddonsList;
import com.heroku.api.request.app.AppCreate;
import com.heroku.api.request.app.AppDestroy;
import com.heroku.api.request.app.AppInfo;
import com.heroku.api.request.app.AppList;
import com.heroku.api.request.app.AppRename;
import com.heroku.api.request.config.ConfigAdd;
import com.heroku.api.request.config.ConfigList;
import com.heroku.api.request.config.ConfigRemove;
import com.heroku.api.request.key.KeyAdd;
import com.heroku.api.request.key.KeyList;
import com.heroku.api.request.key.KeyRemove;
import com.heroku.api.request.log.Log;
import com.heroku.api.request.log.LogStreamResponse;
import com.heroku.api.request.ps.ProcessList;
import com.heroku.api.request.ps.Restart;
import com.heroku.api.request.ps.Scale;
import com.heroku.api.request.releases.ListReleases;
import com.heroku.api.request.releases.ReleaseInfo;
import com.heroku.api.request.releases.Rollback;
import com.heroku.api.request.run.Run;
import com.heroku.api.request.run.RunResponse;
import com.heroku.api.request.sharing.CollabList;
import com.heroku.api.request.sharing.SharingAdd;
import com.heroku.api.request.sharing.SharingRemove;
import com.heroku.api.request.sharing.SharingTransfer;
import com.heroku.api.request.stack.StackList;
import com.heroku.api.request.stack.StackMigrate;
import com.heroku.api.request.user.UserInfo;
import java.util.List;
import java.util.Map;

public class HerokuAPI {
    protected final Connection connection;
    protected final String apiKey;

    public HerokuAPI(String apiKey) {
        this(ConnectionFactory.get(), apiKey);
    }

    public HerokuAPI(Connection connection, String apiKey) {
        this.connection = connection;
        this.apiKey = apiKey;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public User getUserInfo() {
        return this.connection.execute(new UserInfo(), this.apiKey);
    }

    public void addKey(String sshKey) {
        this.connection.execute(new KeyAdd(sshKey), this.apiKey);
    }

    public void removeKey(String sshKey) {
        this.connection.execute(new KeyRemove(sshKey), this.apiKey);
    }

    public List<Key> listKeys() {
        return this.connection.execute(new KeyList(), this.apiKey);
    }

    public List<App> listApps() {
        return this.connection.execute(new AppList(), this.apiKey);
    }

    public App getApp(String name) {
        return this.connection.execute(new AppInfo(name), this.apiKey);
    }

    public App createApp() {
        return this.connection.execute(new AppCreate(new App().on(Heroku.Stack.Cedar)), this.apiKey);
    }

    public App createApp(App app) {
        return this.connection.execute(new AppCreate(app), this.apiKey);
    }

    public String renameApp(String appName, String newName) {
        return this.connection.execute(new AppRename(appName, newName), this.apiKey).getName();
    }

    public void destroyApp(String appName) {
        this.connection.execute(new AppDestroy(appName), this.apiKey);
    }

    public AddonChange addAddon(String appName, String addonName) {
        return this.connection.execute(new AddonInstall(appName, addonName), this.apiKey);
    }

    public List<Addon> listAllAddons() {
        return this.connection.execute(new AddonList(), this.apiKey);
    }

    public List<Addon> listAppAddons(String appName) {
        return this.connection.execute(new AppAddonsList(appName), this.apiKey);
    }

    public AddonChange removeAddon(String appName, String addonName) {
        return this.connection.execute(new AddonRemove(appName, addonName), this.apiKey);
    }

    public void scaleProcess(String appName, String processType, int quantity) {
        this.connection.execute(new Scale(appName, processType, quantity), this.apiKey);
    }

    public List<Proc> listProcesses(String appName) {
        return this.connection.execute(new ProcessList(appName), this.apiKey);
    }

    public List<Release> listReleases(String appName) {
        return this.connection.execute(new ListReleases(appName), this.apiKey);
    }

    public String rollback(String appName, String releaseName) {
        return this.connection.execute(new Rollback(appName, releaseName), this.apiKey);
    }

    public Release getReleaseInfo(String appName, String releaseName) {
        return this.connection.execute(new ReleaseInfo(appName, releaseName), this.apiKey);
    }

    public List<Collaborator> listCollaborators(String appName) {
        return this.connection.execute(new CollabList(appName), this.apiKey);
    }

    public void addCollaborator(String appName, String collaborator) {
        this.connection.execute(new SharingAdd(appName, collaborator), this.apiKey);
    }

    public void removeCollaborator(String appName, String collaborator) {
        this.connection.execute(new SharingRemove(appName, collaborator), this.apiKey);
    }

    public void addConfig(String appName, Map<String, String> config) {
        String jsonConfig = "{";
        String separator = "";
        for (Map.Entry<String, String> configEntry : config.entrySet()) {
            jsonConfig = jsonConfig.concat(String.format("%s \"%s\":\"%s\"", separator, configEntry.getKey(), configEntry.getValue()));
            separator = ",";
        }
        jsonConfig = jsonConfig.concat("}");
        this.connection.execute(new ConfigAdd(appName, jsonConfig), this.apiKey);
    }

    public Map<String, String> listConfig(String appName) {
        return this.connection.execute(new ConfigList(appName), this.apiKey);
    }

    public Map<String, String> removeConfig(String appName, String configVarName) {
        return this.connection.execute(new ConfigRemove(appName, configVarName), this.apiKey);
    }

    public void transferApp(String appName, String to) {
        this.connection.execute(new SharingTransfer(appName, to), this.apiKey);
    }

    public LogStreamResponse getLogs(String appName) {
        return this.connection.execute(new Log(appName), this.apiKey);
    }

    public LogStreamResponse getLogs(Log.LogRequestBuilder logRequest) {
        return this.connection.execute(new Log(logRequest), this.apiKey);
    }

    public void run(String appName, String command) {
        this.connection.execute(new Run(appName, command), this.apiKey);
    }

    public RunResponse runAttached(String appName, String command) {
        return this.connection.execute(new Run(appName, command, true), this.apiKey);
    }

    public void restart(String appName) {
        this.connection.execute(new Restart(appName), this.apiKey);
    }

    public void restartProcessByType(String appName, String type) {
        this.connection.execute(new Restart.ProcessTypeRestart(appName, type), this.apiKey);
    }

    public void restartProcessByName(String appName, String procName) {
        this.connection.execute(new Restart.NamedProcessRestart(appName, procName), this.apiKey);
    }

    public String migrateStack(String appName, Heroku.Stack migrateTo) {
        return this.connection.execute(new StackMigrate(appName, migrateTo), this.apiKey);
    }

    public List<StackInfo> listAppStacks(String appName) {
        return this.connection.execute(new StackList(appName), this.apiKey);
    }
}

