/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.sharing;

import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.Request;
import com.heroku.api.request.RequestConfig;
import com.heroku.api.response.Unit;
import java.util.Map;

public class SharingTransfer
implements Request<Unit> {
    private final RequestConfig config;

    public SharingTransfer(String appName, String newOwnerEmail) {
        this.config = new RequestConfig().app(appName).with(Heroku.RequestKey.TransferOwner, newOwnerEmail);
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.PUT;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.App.format(this.config.get(Heroku.RequestKey.AppName));
    }

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public String getBody() {
        return HttpUtil.encodeParameters(this.config, Heroku.RequestKey.TransferOwner);
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.XML;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Http.Header.Util.setHeaders(Http.ContentType.FORM_URLENCODED);
    }

    @Override
    public Unit getResponse(byte[] in, int code) {
        if (code == Http.Status.OK.statusCode) {
            return Unit.unit;
        }
        throw new RequestFailedException("SharingTransfer failed", code, in);
    }
}

