/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.herokudeployer;

import com.heroku.api.App;
import com.heroku.api.Heroku;
import com.heroku.api.HerokuAPI;
import com.heroku.api.Key;
import com.heroku.api.connection.HttpClientConnection;
import com.heroku.api.request.LoginRequest;
import com.heroku.api.request.Request;
import com.heroku.api.request.key.KeyAdd;
import com.heroku.api.request.key.KeyList;
import com.heroku.api.request.login.BasicAuthLogin;
import com.heroku.api.response.Unit;
import com.heroku.herokudeployer.HerokuSshSessionFactory;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.SshSessionFactory;

public class HerokuDeployer {
    private static final String SSH_KEY_COMMENT = "heroku@localhost";
    public static final String HEROKU = "heroku";

    public static void main(String[] args) {
        try {
            File projectDir = HerokuDeployer.getProjectDir(args, true);
            String herokuApiKey = HerokuDeployer.getHerokuApiKey(true);
            File sshKey = HerokuDeployer.getSshKey(herokuApiKey, true);
            HerokuDeployer.commitProjectToLocalGit(projectDir, true);
            HerokuDeployer.getOrCreateApp(herokuApiKey, projectDir, true);
            HerokuDeployer.deployApp(sshKey, projectDir, true);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static File getProjectDir(String[] args, boolean interactive) {
        File projectDirectory = null;
        if (args.length == 0) {
            projectDirectory = new File(System.getProperty("user.dir"));
        } else if (args.length == 1) {
            projectDirectory = new File(args[0]);
        }
        if (!projectDirectory.exists()) {
            throw new RuntimeException("Project directory does not exist: " + projectDirectory.getAbsolutePath());
        }
        if (interactive) {
            System.out.println("Project directory: " + projectDirectory.getAbsolutePath());
        }
        return projectDirectory;
    }

    public static String getHerokuApiKey(boolean interactive) throws IOException {
        File herokuCredentialsFile;
        String herokuApiKey = null;
        File userHome = new File(System.getProperty("user.home"));
        File dotHeroku = new File(userHome.getAbsolutePath() + File.separator + ".heroku");
        if (!dotHeroku.exists()) {
            dotHeroku.mkdir();
        }
        if (!(herokuCredentialsFile = new File(dotHeroku.getAbsolutePath() + File.separator + "credentials")).exists()) {
            String herokuUsername = null;
            String herokuPassword = null;
            if (interactive) {
                System.out.println("Please login with your Heroku.com credentials");
                System.out.print("Email: ");
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                herokuUsername = in.readLine();
                System.out.print("Password: ");
                herokuPassword = in.readLine();
            } else {
                if (System.getProperty("heroku.username") != null) {
                    herokuUsername = System.getProperty("heroku.username");
                } else if (System.getenv("HEROKU_USERNAME") != null) {
                    herokuUsername = System.getenv("HEROKU_USERNAME");
                }
                if (System.getProperty("heroku.password") != null) {
                    herokuUsername = System.getProperty("heroku.password");
                } else if (System.getenv("HEROKU_PASSWORD") != null) {
                    herokuUsername = System.getenv("HEROKU_PASSWORD");
                }
            }
            if (herokuUsername == null || herokuPassword == null) {
                throw new RuntimeException("Could not get the Heroku username and/or password.");
            }
            HttpClientConnection herokuConnection = new HttpClientConnection((LoginRequest)new BasicAuthLogin(herokuUsername, herokuPassword));
            herokuApiKey = herokuConnection.getApiKey();
            if (interactive) {
                System.out.println("Logged into Heroku");
            }
            herokuCredentialsFile.createNewFile();
            FileUtils.writeStringToFile((File)herokuCredentialsFile, (String)(herokuUsername + IOUtils.LINE_SEPARATOR + herokuApiKey));
            if (interactive) {
                System.out.println("Stored Heroku API key in " + herokuCredentialsFile.getAbsolutePath());
            }
        } else {
            herokuApiKey = (String)FileUtils.readLines((File)herokuCredentialsFile).get(1);
            if (interactive) {
                System.out.println("Read Heroku API key from " + herokuCredentialsFile.getAbsolutePath());
            }
        }
        return herokuApiKey;
    }

    private static File getSshKey(String herokuApiKey, boolean interactive) throws JSchException, IOException {
        File sshKey = null;
        File sshDir = new File(System.getProperty("user.home") + File.separator + ".ssh");
        if (!sshDir.exists()) {
            sshDir.mkdir();
        }
        HttpClientConnection herokuConnection = new HttpClientConnection(herokuApiKey);
        KeyList keyListReq = new KeyList();
        List keys = (List)herokuConnection.execute((Request)keyListReq);
        for (Key key : keys) {
            Collection files = FileUtils.listFiles((File)sshDir, (String[])new String[]{"pub"}, (boolean)false);
            for (File file : files) {
                String sshKeyString = FileUtils.readFileToString((File)file).replaceAll("\n", "");
                if (!sshKeyString.equals(key.getContents())) continue;
                sshKey = file;
                if (interactive) {
                    System.out.println("Using ssh key from: " + file.getAbsolutePath());
                }
                return sshKey;
            }
        }
        if (sshKey == null) {
            JSch jsch = new JSch();
            KeyPair keyPair = KeyPair.genKeyPair((JSch)jsch, (int)2);
            File privateSshKey = new File(sshDir.getAbsolutePath() + File.separator + "heroku_rsa");
            keyPair.writePrivateKey(privateSshKey.getAbsolutePath());
            privateSshKey.setReadable(false, false);
            privateSshKey.setReadable(true, true);
            sshKey = new File(sshDir.getAbsolutePath() + File.separator + "heroku_rsa.pub");
            keyPair.writePublicKey(sshKey.getAbsolutePath(), SSH_KEY_COMMENT);
            sshKey.setReadable(false, false);
            sshKey.setReadable(true, true);
            if (interactive) {
                System.out.println("Created new ssh key pair (heroku_rsa) in: " + sshDir.getAbsolutePath());
            }
            ByteArrayOutputStream publicKeyOutputStream = new ByteArrayOutputStream();
            keyPair.writePublicKey((OutputStream)publicKeyOutputStream, SSH_KEY_COMMENT);
            publicKeyOutputStream.close();
            String sshPublicKey = new String(publicKeyOutputStream.toByteArray());
            KeyAdd keyAddReq = new KeyAdd(sshPublicKey);
            Unit keyAddResp = (Unit)herokuConnection.execute((Request)keyAddReq);
            if (keyAddResp == null) {
                throw new RuntimeException("Could not associate the ssh key with the Heroku account");
            }
            if (interactive) {
                System.out.println("Added the heroku_rsa.pub ssh public key to your Heroku account");
            }
        }
        return sshKey;
    }

    private static void commitProjectToLocalGit(File projectDir, boolean interactive) throws IOException, NoFilepatternException, NoHeadException, NoMessageException, ConcurrentRefUpdateException, WrongRepositoryStateException {
        File gitIgnore;
        Repository gitRepo = HerokuDeployer.getGitRepository(projectDir);
        if (!gitRepo.getDirectory().exists()) {
            gitRepo.create();
            if (interactive) {
                System.out.println("Created a .git directory for your project");
            }
        }
        if (!(gitIgnore = new File(projectDir, ".gitignore")).exists()) {
            FileUtils.copyInputStreamToFile((InputStream)HerokuDeployer.class.getClassLoader().getResourceAsStream("gitignore"), (File)gitIgnore);
        }
        Git git = new Git(gitRepo);
        git.add().addFilepattern(".").call();
        git.commit().setMessage("Auto-Commit at " + new Date().toString()).call();
        if (interactive) {
            System.out.println("Added and committed all of the local changes to the git repo");
        }
    }

    private static String getOrCreateApp(String herokuApiKey, File projectDir, boolean interactive) throws IOException {
        String gitUrl = null;
        Repository gitRepo = HerokuDeployer.getGitRepository(projectDir);
        StoredConfig storedConfig = gitRepo.getConfig();
        Set remotes = storedConfig.getSubsections("remote");
        for (String remoteName : remotes) {
            if (!remoteName.equals(HEROKU)) continue;
            gitUrl = storedConfig.getString("remote", remoteName, "url");
            if (!interactive) continue;
            System.out.println("Heroku application appears to exist already with a git url of: " + gitUrl);
        }
        if (gitUrl == null) {
            HerokuAPI api = new HerokuAPI(herokuApiKey);
            App app = api.createApp(new App().on(Heroku.Stack.Cedar));
            if (interactive) {
                System.out.println("Created app: " + app.getName() + "\n" + app.getWebUrl());
            }
            gitUrl = app.getGitUrl();
            storedConfig.setString("remote", HEROKU, "url", gitUrl);
            storedConfig.save();
            if (interactive) {
                System.out.println("Added git remote: " + gitUrl);
            }
        }
        return gitUrl;
    }

    public static void deployApp(File sshKey, File projectDir, boolean interactive) throws IOException, InvalidRemoteException {
        SshSessionFactory.setInstance((SshSessionFactory)new HerokuSshSessionFactory());
        if (interactive) {
            System.out.println("Deploying application via git push");
        }
        Repository gitRepo = HerokuDeployer.getGitRepository(projectDir);
        Git git = new Git(gitRepo);
        git.push().setRemote(HEROKU).call();
        if (interactive) {
            System.out.println("Application deployed");
        }
    }

    private static Repository getGitRepository(File projectDir) throws IOException {
        File projectGitDir = new File(projectDir.getAbsoluteFile() + File.separator + ".git");
        Repository repository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(projectGitDir)).build();
        return repository;
    }
}

