/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseCommand
extends GitCommand<RebaseResult> {
    public static final String REBASE_MERGE = "rebase-merge";
    public static final String STOPPED_SHA = "stopped-sha";
    private static final String AUTHOR_SCRIPT = "author-script";
    private static final String DONE = "done";
    private static final String GIT_AUTHOR_DATE = "GIT_AUTHOR_DATE";
    private static final String GIT_AUTHOR_EMAIL = "GIT_AUTHOR_EMAIL";
    private static final String GIT_AUTHOR_NAME = "GIT_AUTHOR_NAME";
    private static final String GIT_REBASE_TODO = "git-rebase-todo";
    private static final String HEAD_NAME = "head-name";
    private static final String INTERACTIVE = "interactive";
    private static final String MESSAGE = "message";
    private static final String ONTO = "onto";
    private static final String PATCH = "patch";
    private static final String REBASE_HEAD = "head";
    private Operation operation = Operation.BEGIN;
    private RevCommit upstreamCommit;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private final RevWalk walk;
    private final File rebaseDir;

    protected RebaseCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
        this.rebaseDir = new File(repo.getDirectory(), REBASE_MERGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RebaseResult call() throws NoHeadException, RefNotFoundException, JGitInternalException, GitAPIException {
        newHead = null;
        lastStepWasForward = false;
        this.checkCallable();
        this.checkParameters();
        try {
            switch (1.$SwitchMap$org$eclipse$jgit$api$RebaseCommand$Operation[this.operation.ordinal()]) {
                case 1: {
                    try {
                        return this.abort(RebaseResult.ABORTED_RESULT);
                    }
                    catch (IOException ioe) {
                        throw new JGitInternalException(ioe.getMessage(), ioe);
                    }
                }
                case 2: 
                case 3: {
                    upstreamCommitName = this.readFile(this.rebaseDir, "onto");
                    this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(upstreamCommitName));
                    break;
                }
                case 4: {
                    res = this.initFilesAndRewind();
                    if (res == null) break;
                    return res;
                }
            }
            if (this.monitor.isCancelled()) {
                return this.abort(RebaseResult.ABORTED_RESULT);
            }
            if (this.operation == Operation.CONTINUE) {
                newHead = this.continueRebase();
            }
            if (this.operation == Operation.SKIP) {
                newHead = this.checkoutCurrentHead();
            }
            or = this.repo.newObjectReader();
            steps = this.loadSteps();
            i$ = steps.iterator();
            while (true) lbl-1000:
            // 5 sources

            {
                if (!i$.hasNext()) {
                    if (newHead == null) return RebaseResult.FAST_FORWARD_RESULT;
                    headName = this.readFile(this.rebaseDir, "head-name");
                    this.updateHead(headName, newHead);
                    FileUtils.delete(this.rebaseDir, 1);
                    if (lastStepWasForward == false) return RebaseResult.OK_RESULT;
                    return RebaseResult.FAST_FORWARD_RESULT;
                }
                step = i$.next();
                this.popSteps(1);
                ids = or.resolve(step.commit);
                if (ids.size() != 1) {
                    throw new JGitInternalException("Could not resolve uniquely the abbreviated object ID");
                }
                commitToPick = this.walk.parseCommit(ids.iterator().next());
                if (this.monitor.isCancelled()) {
                    return new RebaseResult(commitToPick);
                }
                try {
                    this.monitor.beginTask(MessageFormat.format(JGitText.get().applyingCommit, new Object[]{commitToPick.getShortMessage()}), 0);
                    newHead = this.tryFastForward(commitToPick);
                    lastStepWasForward = newHead != null;
                    if (lastStepWasForward) ** GOTO lbl-1000
                    cherryPickResult = new Git(this.repo).cherryPick().include(commitToPick).call();
                    switch (1.$SwitchMap$org$eclipse$jgit$api$CherryPickResult$CherryPickStatus[cherryPickResult.getStatus().ordinal()]) {
                        case 1: {
                            if (this.operation == Operation.BEGIN) {
                                var10_12 = this.abort(new RebaseResult(cherryPickResult.getFailingPaths()));
                                return var10_12;
                            }
                            var10_13 = this.stop(commitToPick);
                            return var10_13;
                        }
                        case 2: {
                            var10_14 = this.stop(commitToPick);
                            return var10_14;
                        }
                        case 3: {
                            newHead = cherryPickResult.getNewHead();
                        }
                    }
                }
                finally {
                    this.monitor.endTask();
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        ** GOTO lbl-1000
    }

    private void updateHead(String headName, RevCommit newHead) throws IOException {
        if (headName.startsWith("refs/")) {
            RefUpdate rup = this.repo.updateRef(headName);
            rup.setNewObjectId(newHead);
            RefUpdate.Result res = rup.forceUpdate();
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException("Updating HEAD failed");
                }
            }
            rup = this.repo.updateRef("HEAD");
            res = rup.link(headName);
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException("Updating HEAD failed");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit checkoutCurrentHead() throws IOException, NoHeadException, JGitInternalException {
        ObjectId headTree = this.repo.resolve("HEAD^{tree}");
        if (headTree == null) {
            throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
        }
        DirCache dc = this.repo.lockDirCache();
        try {
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, dc, headTree);
            dco.setFailOnConflict(false);
            boolean needsDeleteFiles = dco.checkout();
            if (needsDeleteFiles) {
                List<String> fileList = dco.getToBeDeleted();
                for (String filePath : fileList) {
                    File fileToDelete = new File(this.repo.getWorkTree(), filePath);
                    if (!fileToDelete.exists()) continue;
                    FileUtils.delete(fileToDelete, 3);
                }
            }
        }
        finally {
            dc.unlock();
        }
        RevWalk rw = new RevWalk(this.repo);
        RevCommit commit = rw.parseCommit(this.repo.resolve("HEAD"));
        rw.release();
        return commit;
    }

    private RevCommit continueRebase() throws GitAPIException, IOException {
        DirCache dc = this.repo.readDirCache();
        boolean hasUnmergedPaths = dc.hasUnmergedPaths();
        if (hasUnmergedPaths) {
            throw new UnmergedPathsException();
        }
        TreeWalk treeWalk = new TreeWalk(this.repo);
        treeWalk.reset();
        treeWalk.setRecursive(true);
        treeWalk.addTree(new DirCacheIterator(dc));
        ObjectId id = this.repo.resolve("HEAD^{tree}");
        if (id == null) {
            throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
        }
        treeWalk.addTree(id);
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        boolean needsCommit = treeWalk.next();
        treeWalk.release();
        if (needsCommit) {
            CommitCommand commit = new Git(this.repo).commit();
            commit.setMessage(this.readFile(this.rebaseDir, MESSAGE));
            commit.setAuthor(this.parseAuthor());
            return commit.call();
        }
        return null;
    }

    private PersonIdent parseAuthor() throws IOException {
        byte[] raw;
        File authorScriptFile = new File(this.rebaseDir, AUTHOR_SCRIPT);
        try {
            raw = IO.readFully(authorScriptFile);
        }
        catch (FileNotFoundException notFound) {
            return null;
        }
        return this.parseAuthor(raw);
    }

    private RebaseResult stop(RevCommit commitToPick) throws IOException {
        PersonIdent author = commitToPick.getAuthorIdent();
        String authorScript = this.toAuthorScript(author);
        this.createFile(this.rebaseDir, AUTHOR_SCRIPT, authorScript);
        this.createFile(this.rebaseDir, MESSAGE, commitToPick.getFullMessage());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DiffFormatter df = new DiffFormatter(bos);
        df.setRepository(this.repo);
        df.format(commitToPick.getParent(0), commitToPick);
        this.createFile(this.rebaseDir, PATCH, new String(bos.toByteArray(), "UTF-8"));
        this.createFile(this.rebaseDir, STOPPED_SHA, this.repo.newObjectReader().abbreviate(commitToPick).name());
        this.repo.writeCherryPickHead(null);
        return new RebaseResult(commitToPick);
    }

    String toAuthorScript(PersonIdent author) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(GIT_AUTHOR_NAME);
        sb.append("='");
        sb.append(author.getName());
        sb.append("'\n");
        sb.append(GIT_AUTHOR_EMAIL);
        sb.append("='");
        sb.append(author.getEmailAddress());
        sb.append("'\n");
        sb.append(GIT_AUTHOR_DATE);
        sb.append("='");
        String externalString = author.toExternalString();
        sb.append(externalString.substring(externalString.lastIndexOf(62) + 2));
        sb.append("'\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popSteps(int numSteps) throws IOException {
        if (numSteps == 0) {
            return;
        }
        ArrayList<String> todoLines = new ArrayList<String>();
        ArrayList<String> poppedLines = new ArrayList<String>();
        File todoFile = new File(this.rebaseDir, GIT_REBASE_TODO);
        File doneFile = new File(this.rebaseDir, DONE);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(todoFile), "UTF-8"));
        try {
            String popCandidate;
            while (poppedLines.size() < numSteps && (popCandidate = br.readLine()) != null) {
                if (popCandidate.charAt(0) == '#') continue;
                int spaceIndex = popCandidate.indexOf(32);
                boolean pop = false;
                if (spaceIndex >= 0) {
                    String actionToken = popCandidate.substring(0, spaceIndex);
                    boolean bl = pop = Action.parse(actionToken) != null;
                }
                if (pop) {
                    poppedLines.add(popCandidate);
                    continue;
                }
                todoLines.add(popCandidate);
            }
            String readLine = br.readLine();
            while (readLine != null) {
                todoLines.add(readLine);
                readLine = br.readLine();
            }
        }
        finally {
            br.close();
        }
        BufferedWriter todoWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(todoFile), "UTF-8"));
        try {
            for (String writeLine : todoLines) {
                todoWriter.write(writeLine);
                todoWriter.newLine();
            }
        }
        finally {
            todoWriter.close();
        }
        if (poppedLines.size() > 0) {
            BufferedWriter doneWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(doneFile, true), "UTF-8"));
            try {
                for (String writeLine : poppedLines) {
                    doneWriter.write(writeLine);
                    doneWriter.newLine();
                }
            }
            finally {
                doneWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult initFilesAndRewind() throws RefNotFoundException, IOException, NoHeadException, JGitInternalException {
        Ref head = this.repo.getRef("HEAD");
        if (head == null || head.getObjectId() == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        String headName = head.isSymbolic() ? head.getTarget().getName() : "detached HEAD";
        ObjectId headId = head.getObjectId();
        if (headId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        RevCommit headCommit = this.walk.lookupCommit(headId);
        RevCommit upstream = this.walk.lookupCommit(this.upstreamCommit.getId());
        if (this.walk.isMergedInto(upstream, headCommit)) {
            return RebaseResult.UP_TO_DATE_RESULT;
        }
        if (this.walk.isMergedInto(headCommit, upstream)) {
            this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, this.upstreamCommit.getShortMessage()), 0);
            this.checkoutCommit(this.upstreamCommit);
            this.monitor.endTask();
            this.updateHead(headName, this.upstreamCommit);
            return RebaseResult.FAST_FORWARD_RESULT;
        }
        this.monitor.beginTask(JGitText.get().obtainingCommitsForCherryPick, 0);
        LogCommand cmd = new Git(this.repo).log().addRange(this.upstreamCommit, headCommit);
        Object commitsToUse = cmd.call();
        ArrayList<RevCommit> cherryPickList = new ArrayList<RevCommit>();
        Iterator i$ = commitsToUse.iterator();
        while (i$.hasNext()) {
            RevCommit commit = (RevCommit)i$.next();
            if (commit.getParentCount() != 1) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, commit.name(), commit.getParentCount()));
            }
            cherryPickList.add(commit);
        }
        Collections.reverse(cherryPickList);
        FileUtils.mkdir(this.rebaseDir);
        this.createFile(this.repo.getDirectory(), "ORIG_HEAD", headId.name());
        this.createFile(this.rebaseDir, REBASE_HEAD, headId.name());
        this.createFile(this.rebaseDir, HEAD_NAME, headName);
        this.createFile(this.rebaseDir, ONTO, this.upstreamCommit.name());
        this.createFile(this.rebaseDir, INTERACTIVE, "");
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.rebaseDir, GIT_REBASE_TODO)), "UTF-8"));
        fw.write("# Created by EGit: rebasing " + this.upstreamCommit.name() + " onto " + headId.name());
        fw.newLine();
        try {
            StringBuilder sb = new StringBuilder();
            ObjectReader reader = this.walk.getObjectReader();
            for (RevCommit commit : cherryPickList) {
                sb.setLength(0);
                sb.append(Action.PICK.toToken());
                sb.append(" ");
                sb.append(reader.abbreviate(commit).name());
                sb.append(" ");
                sb.append(commit.getShortMessage());
                fw.write(sb.toString());
                fw.newLine();
            }
        }
        finally {
            fw.close();
        }
        this.monitor.endTask();
        this.monitor.beginTask(MessageFormat.format(JGitText.get().rewinding, this.upstreamCommit.getShortMessage()), 0);
        boolean checkoutOk = false;
        try {
            checkoutOk = this.checkoutCommit(this.upstreamCommit);
        }
        finally {
            if (!checkoutOk) {
                FileUtils.delete(this.rebaseDir, 1);
            }
        }
        this.monitor.endTask();
        return null;
    }

    public RevCommit tryFastForward(RevCommit newCommit) throws RefNotFoundException, IOException {
        Ref head = this.repo.getRef("HEAD");
        if (head == null || head.getObjectId() == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        ObjectId headId = head.getObjectId();
        if (headId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        RevCommit headCommit = this.walk.lookupCommit(headId);
        if (this.walk.isMergedInto(newCommit, headCommit)) {
            return newCommit;
        }
        String headName = head.isSymbolic() ? head.getTarget().getName() : "detached HEAD";
        return this.tryFastForward(headName, headCommit, newCommit);
    }

    private RevCommit tryFastForward(String headName, RevCommit oldCommit, RevCommit newCommit) throws IOException, JGitInternalException {
        boolean tryRebase = false;
        for (RevCommit parentCommit : newCommit.getParents()) {
            if (!parentCommit.equals(oldCommit)) continue;
            tryRebase = true;
        }
        if (!tryRebase) {
            return null;
        }
        CheckoutCommand co = new CheckoutCommand(this.repo);
        try {
            co.setName(newCommit.name()).call();
            if (headName.startsWith("refs/heads/")) {
                RefUpdate rup = this.repo.updateRef(headName);
                rup.setExpectedOldObjectId(oldCommit);
                rup.setNewObjectId(newCommit);
                rup.setRefLogMessage("Fast-foward from " + oldCommit.name() + " to " + newCommit.name(), false);
                RefUpdate.Result res = rup.update(this.walk);
                switch (res) {
                    case FAST_FORWARD: 
                    case FORCED: 
                    case NO_CHANGE: {
                        break;
                    }
                    default: {
                        throw new IOException("Could not fast-forward");
                    }
                }
            }
            return newCommit;
        }
        catch (RefAlreadyExistsException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (RefNotFoundException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (InvalidRefNameException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void checkParameters() throws WrongRepositoryStateException {
        block8: {
            block7: {
                if (this.operation == Operation.BEGIN) break block7;
                switch (this.repo.getRepositoryState()) {
                    case REBASING_INTERACTIVE: {
                        break block8;
                    }
                    default: {
                        throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
                    }
                }
            }
            switch (this.repo.getRepositoryState()) {
                case SAFE: {
                    if (this.upstreamCommit == null) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().missingRequiredParameter, "upstream"));
                    }
                    return;
                }
            }
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(File parentDir, String name, String content) throws IOException {
        File file = new File(parentDir, name);
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(content.getBytes("UTF-8"));
            fos.write(10);
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult abort(RebaseResult result) throws IOException {
        try {
            DirCacheCheckout dco;
            String commitId = this.readFile(this.repo.getDirectory(), "ORIG_HEAD");
            this.monitor.beginTask(MessageFormat.format(JGitText.get().abortingRebase, commitId), 0);
            RevCommit commit = this.walk.parseCommit(this.repo.resolve(commitId));
            if (result.getStatus().equals((Object)RebaseResult.Status.FAILED)) {
                RevCommit head = this.walk.parseCommit(this.repo.resolve("HEAD"));
                dco = new DirCacheCheckout(this.repo, head.getTree(), this.repo.lockDirCache(), commit.getTree());
            } else {
                dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), commit.getTree());
            }
            dco.setFailOnConflict(false);
            dco.checkout();
            this.walk.release();
        }
        finally {
            this.monitor.endTask();
        }
        try {
            String headName = this.readFile(this.rebaseDir, HEAD_NAME);
            if (headName.startsWith("refs/")) {
                this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, headName), 0);
                RefUpdate refUpdate = this.repo.updateRef("HEAD", false);
                RefUpdate.Result res = refUpdate.link(headName);
                switch (res) {
                    case FAST_FORWARD: 
                    case FORCED: 
                    case NO_CHANGE: {
                        break;
                    }
                    default: {
                        throw new JGitInternalException(JGitText.get().abortingRebaseFailed);
                    }
                }
            }
            FileUtils.delete(this.rebaseDir, 1);
            this.repo.writeCherryPickHead(null);
            RebaseResult rebaseResult = result;
            return rebaseResult;
        }
        finally {
            this.monitor.endTask();
        }
    }

    private String readFile(File directory, String fileName) throws IOException {
        int end;
        byte[] content = IO.readFully(new File(directory, fileName));
        for (end = content.length; 0 < end && content[end - 1] == 10; --end) {
        }
        return RawParseUtils.decode(content, 0, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkoutCommit(RevCommit commit) throws IOException {
        try {
            RevCommit head = this.walk.parseCommit(this.repo.resolve("HEAD"));
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, head.getTree(), this.repo.lockDirCache(), commit.getTree());
            dco.setFailOnConflict(true);
            dco.checkout();
            RefUpdate refUpdate = this.repo.updateRef("HEAD", true);
            refUpdate.setExpectedOldObjectId(head);
            refUpdate.setNewObjectId(commit);
            RefUpdate.Result res = refUpdate.forceUpdate();
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
                default: {
                    throw new IOException("Could not rewind to upstream commit");
                }
            }
        }
        finally {
            this.walk.release();
            this.monitor.endTask();
        }
    }

    private List<Step> loadSteps() throws IOException {
        byte[] buf = IO.readFully(new File(this.rebaseDir, GIT_REBASE_TODO));
        int ptr = 0;
        int tokenBegin = 0;
        ArrayList<Step> r = new ArrayList<Step>();
        while (ptr < buf.length) {
            tokenBegin = ptr;
            ptr = RawParseUtils.nextLF(buf, ptr);
            int nextSpace = 0;
            Step current = null;
            block6: for (int tokenCount = 0; tokenCount < 3 && nextSpace < ptr; ++tokenCount) {
                switch (tokenCount) {
                    case 0: {
                        nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
                        String actionToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1);
                        tokenBegin = nextSpace;
                        if (actionToken.charAt(0) == '#') {
                            tokenCount = 3;
                            continue block6;
                        }
                        Action action = Action.parse(actionToken);
                        if (action == null) continue block6;
                        current = new Step(Action.parse(actionToken));
                        continue block6;
                    }
                    case 1: {
                        if (current == null) continue block6;
                        nextSpace = RawParseUtils.next(buf, tokenBegin, ' ');
                        String commitToken = new String(buf, tokenBegin, nextSpace - tokenBegin - 1);
                        tokenBegin = nextSpace;
                        current.commit = AbbreviatedObjectId.fromString(commitToken);
                        continue block6;
                    }
                    case 2: {
                        if (current == null) continue block6;
                        nextSpace = ptr;
                        int length = ptr - tokenBegin;
                        current.shortMessage = new byte[length];
                        System.arraycopy(buf, tokenBegin, current.shortMessage, 0, length);
                        r.add(current);
                    }
                }
            }
        }
        return r;
    }

    public RebaseCommand setUpstream(RevCommit upstream) {
        this.upstreamCommit = upstream;
        return this;
    }

    public RebaseCommand setUpstream(AnyObjectId upstream) {
        try {
            this.upstreamCommit = this.walk.parseCommit(upstream);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().couldNotReadObjectWhileParsingCommit, upstream.name()), e);
        }
        return this;
    }

    public RebaseCommand setUpstream(String upstream) throws RefNotFoundException {
        try {
            ObjectId upstreamId = this.repo.resolve(upstream);
            if (upstreamId == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, upstream));
            }
            this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(upstream));
            return this;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public RebaseCommand setOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    public RebaseCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    PersonIdent parseAuthor(byte[] raw) {
        int equalsIndex;
        int end;
        if (raw.length == 0) {
            return null;
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        int p = 0;
        while (p < raw.length && (end = RawParseUtils.nextLF(raw, p)) != p && (equalsIndex = RawParseUtils.next(raw, p, '=')) != end) {
            String key = RawParseUtils.decode(raw, p, equalsIndex - 1);
            String value = RawParseUtils.decode(raw, equalsIndex + 1, end - 2);
            p = end;
            keyValueMap.put(key, value);
        }
        String name = (String)keyValueMap.get(GIT_AUTHOR_NAME);
        String email = (String)keyValueMap.get(GIT_AUTHOR_EMAIL);
        String time = (String)keyValueMap.get(GIT_AUTHOR_DATE);
        long when = Long.parseLong(time.substring(0, time.indexOf(32))) * 1000L;
        String tzOffsetString = time.substring(time.indexOf(32) + 1);
        int multiplier = -1;
        if (tzOffsetString.charAt(0) == '+') {
            multiplier = 1;
        }
        int hours = Integer.parseInt(tzOffsetString.substring(1, 3));
        int minutes = Integer.parseInt(tzOffsetString.substring(3, 5));
        int tz = (hours * 60 + minutes) * multiplier;
        if (name != null && email != null) {
            return new PersonIdent(name, email, when, tz);
        }
        return null;
    }

    static class Step {
        Action action;
        AbbreviatedObjectId commit;
        byte[] shortMessage;

        Step(Action action) {
            this.action = action;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        PICK("pick");

        private final String token;

        private Action(String token) {
            this.token = token;
        }

        public String toToken() {
            return this.token;
        }

        static Action parse(String token) {
            if (token.equals("pick") || token.equals("p")) {
                return PICK;
            }
            throw new JGitInternalException(MessageFormat.format("Unknown or unsupported command \"{0}\", only  \"pick\" is allowed", token));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        BEGIN,
        CONTINUE,
        SKIP,
        ABORT;

    }
}

