/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.storage.dfs.DfsBlock;
import org.eclipse.jgit.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsPackKey;
import org.eclipse.jgit.storage.dfs.DfsPackParser;
import org.eclipse.jgit.storage.file.PackIndex;
import org.eclipse.jgit.storage.file.PackIndexWriter;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.CountingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsInserter
extends ObjectInserter {
    private static final int INDEX_VERSION = 2;
    private final DfsObjDatabase db;
    private List<PackedObjectInfo> objectList;
    private ObjectIdOwnerMap<PackedObjectInfo> objectMap;
    private DfsBlockCache cache;
    private DfsPackKey packKey;
    private DfsPackDescription packDsc;
    private PackStream packOut;
    private boolean rollback;

    protected DfsInserter(DfsObjDatabase db) {
        this.db = db;
    }

    @Override
    public DfsPackParser newPackParser(InputStream in) throws IOException {
        return new DfsPackParser(this.db, this, in);
    }

    @Override
    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        ObjectId id = this.idFor(type, data, off, len);
        if (this.objectMap != null && this.objectMap.contains(id)) {
            return id;
        }
        if (this.db.has(id)) {
            return id;
        }
        long offset = this.beginObject(type, len);
        this.packOut.compress.write(data, off, len);
        this.packOut.compress.finish();
        return this.endObject(id, offset);
    }

    @Override
    public ObjectId insert(int type, long len, InputStream in) throws IOException {
        byte[] buf = this.buffer();
        if (len <= (long)buf.length) {
            IO.readFully(in, buf, 0, (int)len);
            return this.insert(type, buf, 0, (int)len);
        }
        long offset = this.beginObject(type, len);
        MessageDigest md = this.digest();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        while (0L < len) {
            int n = in.read(buf, 0, (int)Math.min((long)buf.length, len));
            if (n <= 0) {
                throw new EOFException();
            }
            md.update(buf, 0, n);
            this.packOut.compress.write(buf, 0, n);
            len -= (long)n;
        }
        this.packOut.compress.finish();
        return this.endObject(ObjectId.fromRaw(md.digest()), offset);
    }

    @Override
    public void flush() throws IOException {
        if (this.packDsc == null) {
            return;
        }
        if (this.packOut == null) {
            throw new IOException();
        }
        byte[] packHash = this.packOut.writePackFooter();
        this.packDsc.setPackSize(this.packOut.getCount());
        this.packOut.close();
        this.packOut = null;
        this.sortObjectsById();
        PackIndex index = this.writePackIndex(this.packDsc, packHash, this.objectList);
        this.db.commitPack(Collections.singletonList(this.packDsc), null);
        this.rollback = false;
        DfsPackFile p = this.cache.getOrCreate(this.packDsc, this.packKey);
        if (index != null) {
            p.setPackIndex(index);
        }
        this.db.addPack(p);
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.packOut != null) {
            try {
                this.packOut.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.packOut = null;
            }
        }
        if (this.rollback && this.packDsc != null) {
            try {
                this.db.rollbackPack(Collections.singletonList(this.packDsc));
            }
            finally {
                this.packDsc = null;
                this.rollback = false;
            }
        }
        this.clear();
    }

    private void clear() {
        this.objectList = null;
        this.objectMap = null;
        this.packKey = null;
        this.packDsc = null;
    }

    private long beginObject(int type, long len) throws IOException {
        if (this.packOut == null) {
            this.beginPack();
        }
        long offset = this.packOut.getCount();
        this.packOut.beginObject(type, len);
        return offset;
    }

    private ObjectId endObject(ObjectId id, long offset) {
        PackedObjectInfo obj = new PackedObjectInfo(id);
        obj.setOffset(offset);
        obj.setCRC((int)this.packOut.crc32.getValue());
        this.objectList.add(obj);
        this.objectMap.addIfAbsent(obj);
        return id;
    }

    private void beginPack() throws IOException {
        this.objectList = new BlockList<PackedObjectInfo>();
        this.objectMap = new ObjectIdOwnerMap();
        this.cache = DfsBlockCache.getInstance();
        this.rollback = true;
        this.packDsc = this.db.newPack(DfsObjDatabase.PackSource.INSERT);
        this.packOut = new PackStream(this.db.writePackFile(this.packDsc));
        this.packKey = new DfsPackKey();
        byte[] buf = this.packOut.hdrBuf;
        System.arraycopy(Constants.PACK_SIGNATURE, 0, buf, 0, 4);
        NB.encodeInt32(buf, 4, 2);
        NB.encodeInt32(buf, 8, 1);
        this.packOut.write(buf, 0, 12);
    }

    private void sortObjectsById() {
        Collections.sort(this.objectList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackIndex writePackIndex(DfsPackDescription pack, byte[] packHash, List<PackedObjectInfo> list) throws IOException {
        pack.setObjectCount(list.size());
        TemporaryBuffer.Heap buf = null;
        PackIndex packIndex = null;
        if (list.size() <= 58000) {
            buf = new TemporaryBuffer.Heap(0x200000);
            DfsInserter.index(buf, packHash, list);
            packIndex = PackIndex.read(buf.openInputStream());
        }
        DfsOutputStream os = this.db.writePackIndex(pack);
        try {
            CountingOutputStream cnt = new CountingOutputStream(os);
            if (buf != null) {
                buf.writeTo(cnt, null);
            } else {
                DfsInserter.index(cnt, packHash, list);
            }
            pack.setIndexSize(cnt.getCount());
        }
        finally {
            os.close();
        }
        return packIndex;
    }

    private static void index(OutputStream out, byte[] packHash, List<PackedObjectInfo> list) throws IOException {
        PackIndexWriter.createVersion(out, 2).write(list, packHash);
    }

    private class PackStream
    extends OutputStream {
        private final DfsOutputStream out;
        private final MessageDigest md;
        private final byte[] hdrBuf;
        private final Deflater deflater;
        private final int blockSize;
        private long currPos;
        private int currPtr;
        private byte[] currBuf;
        final CRC32 crc32;
        final DeflaterOutputStream compress;

        PackStream(DfsOutputStream out) {
            this.out = out;
            this.hdrBuf = new byte[32];
            this.md = Constants.newMessageDigest();
            this.crc32 = new CRC32();
            this.deflater = new Deflater(9);
            this.compress = new DeflaterOutputStream((OutputStream)this, this.deflater, 8192);
            int size = out.blockSize();
            if (size <= 0) {
                size = DfsInserter.this.cache.getBlockSize();
            } else if (size < DfsInserter.this.cache.getBlockSize()) {
                size = DfsInserter.this.cache.getBlockSize() / size * size;
            }
            this.blockSize = size;
            this.currBuf = new byte[this.blockSize];
        }

        long getCount() {
            return this.currPos + (long)this.currPtr;
        }

        void beginObject(int objectType, long length) throws IOException {
            this.crc32.reset();
            this.deflater.reset();
            this.write(this.hdrBuf, 0, this.encodeTypeSize(objectType, length));
        }

        private int encodeTypeSize(int type, long rawLength) {
            long nextLength = rawLength >>> 4;
            this.hdrBuf[0] = (byte)((long)((nextLength > 0L ? 128 : 0) | type << 4) | rawLength & 0xFL);
            rawLength = nextLength;
            int n = 1;
            while (rawLength > 0L) {
                this.hdrBuf[n++] = (byte)((long)((nextLength >>>= 7) > 0L ? 128 : 0) | rawLength & 0x7FL);
                rawLength = nextLength;
            }
            return n;
        }

        public void write(int b) throws IOException {
            this.hdrBuf[0] = (byte)b;
            this.write(this.hdrBuf, 0, 1);
        }

        public void write(byte[] data, int off, int len) throws IOException {
            this.crc32.update(data, off, len);
            this.md.update(data, off, len);
            this.writeNoHash(data, off, len);
        }

        private void writeNoHash(byte[] data, int off, int len) throws IOException {
            while (0 < len) {
                int n = Math.min(len, this.currBuf.length - this.currPtr);
                if (n == 0) {
                    this.flushBlock();
                    this.currBuf = new byte[this.blockSize];
                    continue;
                }
                System.arraycopy(data, off, this.currBuf, this.currPtr, n);
                off += n;
                len -= n;
                this.currPtr += n;
            }
        }

        private void flushBlock() throws IOException {
            this.out.write(this.currBuf, 0, this.currPtr);
            byte[] buf = this.currPtr == this.currBuf.length ? this.currBuf : this.copyOf(this.currBuf, 0, this.currPtr);
            DfsInserter.this.cache.put(new DfsBlock(DfsInserter.this.packKey, this.currPos, buf));
            this.currPos += (long)this.currPtr;
            this.currPtr = 0;
            this.currBuf = null;
        }

        private byte[] copyOf(byte[] src, int ptr, int cnt) {
            byte[] dst = new byte[cnt];
            System.arraycopy(src, ptr, dst, 0, cnt);
            return dst;
        }

        byte[] writePackFooter() throws IOException {
            byte[] packHash = this.md.digest();
            this.writeNoHash(packHash, 0, packHash.length);
            if (this.currPtr != 0) {
                this.flushBlock();
            }
            return packHash;
        }

        public void close() throws IOException {
            this.deflater.end();
            this.out.close();
        }
    }
}

