/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.connection;

import com.heroku.api.Heroku;
import com.heroku.api.connection.AsyncConnection;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionProvider;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.request.Request;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpClientConnection
implements AsyncConnection<Future<?>> {
    private URL endpoint;
    private DefaultHttpClient httpClient;
    private volatile ExecutorService executorService;
    private Object lock;

    public HttpClientConnection() {
        this.endpoint = HttpUtil.toURL((String)Heroku.Config.ENDPOINT.value);
        this.httpClient = this.getHttpClient();
        this.lock = new Object();
    }

    public <T> Future<T> executeAsync(final Request<T> request, final String apiKey) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return HttpClientConnection.this.execute(request, apiKey);
            }
        };
        return this.getExecutorService().submit(callable);
    }

    public <T> T execute(Request<T> request, String key) {
        try {
            HttpRequestBase message = this.getHttpRequestBase(request.getHttpMethod(), Heroku.Config.ENDPOINT.value + request.getEndpoint());
            message.setHeader("X-Heroku-API-Version", String.valueOf(Heroku.ApiVersion.v2.version));
            message.setHeader(request.getResponseType().getHeaderName(), request.getResponseType().getHeaderValue());
            message.setHeader(Http.UserAgent.LATEST.getHeaderName(), Http.UserAgent.LATEST.getHeaderValue("httpclient"));
            for (Map.Entry header : request.getHeaders().entrySet()) {
                message.setHeader((String)header.getKey(), (String)header.getValue());
            }
            if (request.hasBody()) {
                ((HttpEntityEnclosingRequestBase)message).setEntity((HttpEntity)new StringEntity(request.getBody()));
            }
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.endpoint.getHost(), this.endpoint.getPort()), (Credentials)new UsernamePasswordCredentials("", key));
            BasicHttpContext ctx = new BasicHttpContext();
            ctx.setAttribute("preemptive-auth", (Object)new BasicScheme());
            this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)message, (HttpContext)ctx);
            return (T)request.getResponse(HttpUtil.getBytes((InputStream)httpResponse.getEntity().getContent()), httpResponse.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while executing request", e);
        }
    }

    private HttpRequestBase getHttpRequestBase(Http.Method httpMethod, String endpoint) {
        switch (httpMethod) {
            case GET: {
                return new HttpGet(endpoint);
            }
            case PUT: {
                return new HttpPut(endpoint);
            }
            case POST: {
                return new HttpPost(endpoint);
            }
            case DELETE: {
                return new HttpDelete(endpoint);
            }
        }
        throw new UnsupportedOperationException(httpMethod + " is not a supported request type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = this.createExecutorService();
                }
            }
        }
        return this.executorService;
    }

    protected ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setDaemon(true);
                return t;
            }
        });
    }

    protected DefaultHttpClient getHttpClient() {
        SSLSocketFactory ssf = new SSLSocketFactory(Heroku.herokuSSLContext());
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager();
        if (!Heroku.Config.ENDPOINT.isDefault()) {
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry sr = ccm.getSchemeRegistry();
            sr.register(new Scheme("https", (SocketFactory)ssf, 443));
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)ccm);
        defaultHttpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        defaultHttpClient.getParams().setParameter("http.auth.target-scheme-pref", Arrays.asList("Basic"));
        return defaultHttpClient;
    }

    public void close() {
        this.getExecutorService().shutdownNow();
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }

    public static class Provider
    implements ConnectionProvider {
        public Connection getConnection() {
            return new HttpClientConnection();
        }
    }
}

