/*
 * Decompiled with CFR 0.152.
 */
package play.modules.httpmock;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import play.Logger;
import play.Play;
import play.libs.Codec;
import play.libs.Files;
import play.libs.IO;
import play.libs.WS;
import play.libs.ws.WSAsync;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSMock
extends WSAsync {
    public static boolean useCacheRequests = true;
    public static boolean recordCacheRequests = true;

    public WS.WSRequest newRequest(String url) {
        return new WSMockRequest(url);
    }

    public WSCachedResponse createResponseFrom(File file) {
        return new WSCachedResponse(file);
    }

    public void writeResponseIntoFile(WSCachedResponse response, File file) throws IOException {
        response.writeIntoFile(file);
    }

    public static File getFileByUrl(String urlStr) {
        File dir = Play.getFile((String)"httpmock/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, Codec.hexMD5((String)urlStr));
    }

    public static File getUrlsFile() {
        File dir = Play.getFile((String)"httpmock/");
        dir.mkdirs();
        return new File(dir, "urls");
    }

    public static void saveUrls(Map<String, String> urls) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(WSMock.getUrlsFile()));
            for (String key : urls.keySet()) {
                writer.write(key + " " + urls.get(key));
                writer.newLine();
            }
            writer.close();
            WSMock.retrieveUrls();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> retrieveUrls() {
        HashMap<String, String> urls = new HashMap<String, String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(WSMock.getUrlsFile()));
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                int indexOf = line.indexOf(" ");
                if (indexOf != -1) {
                    String key = line.substring(0, indexOf);
                    String value = line.substring(indexOf + 1);
                    File file = Play.getFile((String)("httpmock/" + key));
                    if (file.exists() && file.isFile()) {
                        urls.put(key, value);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return urls;
    }

    public static Map<String, String> getUrls() {
        return WSMock.retrieveUrls();
    }

    public static void removeUrl(String id) {
        Play.getFile((String)("httpmock/" + id)).delete();
        Map<String, String> urls = WSMock.getUrls();
        urls.remove(id);
        WSMock.saveUrls(urls);
    }

    public static void removeUrls() {
        File dir = Play.getFile((String)"httpmock/");
        if (dir.exists()) {
            Files.deleteDirectory((File)dir);
        }
        WSMock.retrieveUrls();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WSCachedResponse
    extends WS.HttpResponse
    implements Serializable {
        Map<String, String> headersMap = new HashMap<String, String>();
        List<Http.Header> headers;
        Integer status;
        InputStream stream;

        public WSCachedResponse(WS.HttpResponse r) {
            this.headers = r.getHeaders();
            for (Http.Header h : this.headers) {
                this.headersMap.put(h.name, h.value());
            }
            this.status = r.getStatus();
            this.stream = r.getStream();
        }

        public WSCachedResponse(File file) {
            try {
                this.status = 200;
                this.headers = new ArrayList<Http.Header>();
                final BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null && line.length() > 0) {
                    int indexOf = line.indexOf(": ");
                    if (indexOf != -1) {
                        String key = line.substring(0, indexOf);
                        String value = line.substring(indexOf + 2);
                        this.headersMap.put(key, value);
                        this.headers.add(new Http.Header(key, value));
                    }
                    line = reader.readLine();
                }
                this.stream = new InputStream(){

                    public int read() throws IOException {
                        return reader.read();
                    }
                };
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void writeIntoFile(File file) throws IOException {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            for (String key : this.headersMap.keySet()) {
                writer.write(key + ": " + this.headersMap.get(key));
                writer.newLine();
            }
            writer.newLine();
            writer.write(IO.readContentAsString((InputStream)this.stream));
            writer.close();
        }

        public String getHeader(String key) {
            return this.headersMap.get(key);
        }

        public List<Http.Header> getHeaders() {
            return this.headers;
        }

        public Integer getStatus() {
            return this.status;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public String getString() {
            return IO.readContentAsString((InputStream)this.stream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WSMockRequest
    extends WSAsync.WSAsyncRequest {
        public WSMockRequest(String url) {
            super((WSAsync)WSMock.this, url);
        }

        private WS.HttpResponse cachedGet() {
            WS.HttpResponse r = null;
            File f = WSMock.getFileByUrl(this.url);
            if (f != null) {
                if (!f.exists()) {
                    if (recordCacheRequests && (r = super.get()) != null) {
                        Logger.debug((String)"WSMockRequest: GET on %s : caching ...", (Object[])new Object[]{this.url});
                        try {
                            WSMock.this.writeResponseIntoFile(new WSCachedResponse(r), f);
                            Map<String, String> urls = WSMock.getUrls();
                            urls.put(f.getName(), this.url);
                            WSMock.saveUrls(urls);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (useCacheRequests) {
                    Logger.debug((String)"WSMockRequest: GET on %s : using cached request", (Object[])new Object[]{this.url});
                    r = WSMock.this.createResponseFrom(f);
                }
            }
            if (r == null) {
                r = super.get();
            }
            return r;
        }

        public WS.HttpResponse get() {
            return this.cachedGet();
        }

        public Future<WS.HttpResponse> getAsync() {
            return new Future<WS.HttpResponse>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public WS.HttpResponse get() throws InterruptedException, ExecutionException {
                    return WSMockRequest.this.cachedGet();
                }

                @Override
                public WS.HttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return WSMockRequest.this.cachedGet();
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return false;
                }
            };
        }
    }
}

