import sys,os,inspect

from play.utils import *

MODULE = 'ivy'

COMMANDS = ['ivy:init','ivy:up','ivy:update','ivy:re','ivy:refresh','ivy:dep','ivy:dependencies']

def execute(**kargs):
    command = kargs.get("command")
    app = kargs.get("app")
    args = kargs.get("args")
    env = kargs.get("env")
    if command == 'ivy:init': _copy_files(app)

    if command == 'ivy:up' or command == 'ivy:update':
        print "~"
        print "~ Retriving dependencies..."
        print "~"
        os.system('ant')

    if command == 'ivy:re' or command == 'ivy:refresh':
        print "~"
        print "~ Refresh dependencies..."
        print "~"
        os.system('ant clean resolve')

    if command == 'ivy:dep' or command == 'ivy:dependencies' :
        print "~~~~~~~~~~~~~~~~~~~~~"
        print "~ Core dependencies ~"
        print "~~~~~~~~~~~~~~~~~~~~~"
        for jar in os.listdir(os.path.join(play_base, 'framework/lib')):
            if jar.endswith('.jar'):
                print(jar)
        print "\n"
        print "~~~~~~~~~~~~~~~~~~~~~~~"
        print "~ Module dependencies ~"
        print "~~~~~~~~~~~~~~~~~~~~~~~"
        for module in modules:
            if os.path.exists(os.path.join(module, 'lib')):
                libs = os.path.join(module, 'lib')
                if os.path.exists(libs):
                    for jar in os.listdir(libs):
                        if jar.endswith('.jar'):
                                print(jar)
        print "\n"
        print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
        print "~ Application dependencies ~"
        print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
        for jar in os.listdir(os.path.join(app.path, 'lib')):
            print(jar) 
        print "\n"

    sys.exit(0)    

def after(**kargs):
    command = kargs.get("command")
    app = kargs.get("app")
    args = kargs.get("args")
    env = kargs.get("env")
    if command == 'new': _copy_files()

def _copy_files(app):
    module_dir = inspect.getfile(inspect.currentframe()).replace("commands.py","")
    shutil.copyfile(os.path.join(module_dir,'resources/build.xml'), os.path.join(app.path, 'build.xml'))
    shutil.copyfile(os.path.join(module_dir,'resources/ivy.xml'), os.path.join(app.path, 'ivy.xml'))
