/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.util.StringUtils;
import cn.bran.japid.util.UrlMapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang.text.StrSubstitutor;
import play.Play;
import play.classloading.enhancers.LocalvariablesNamesEnhancer;
import play.exceptions.ActionNotFoundException;
import play.exceptions.NoRouteFoundException;
import play.exceptions.PlayException;
import play.exceptions.UnexpectedException;
import play.mvc.ActionInvoker;
import play.mvc.Http;
import play.mvc.Router;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteAdapter
implements UrlMapper {
    static ThreadLocal<HashMap<String, String>> staticCache = new ThreadLocal();
    static ThreadLocal<HashMap<String, String>> actionReverseCache = new ThreadLocal();
    static ThreadLocal<HashMap<String, String[]>> actionParamNamesCache = new ThreadLocal();

    public String lookup(String actionString, Object[] params) {
        return RouteAdapter.reverseWithCache(actionString, params);
    }

    public String lookupAbs(String action, Object[] args) {
        return Http.Request.current().getBase() + this.lookup(action, args);
    }

    public String lookupStatic(String resource) {
        return RouteAdapter.reverseStaticLookup(resource);
    }

    public String lookupStaticAbs(String resource) {
        return Http.Request.current().getBase() + this.lookupStatic(resource);
    }

    public static String reverseWithCache(String actionString, Object[] params) {
        try {
            String controllerName = Http.Request.current().controller;
            String action = actionString;
            String methodName = actionString;
            if (actionString.indexOf(".") > 0) {
                int lastIndexOf = actionString.lastIndexOf(46);
                methodName = actionString.substring(lastIndexOf + 1);
                controllerName = actionString.substring(0, lastIndexOf);
            } else {
                action = controllerName + "." + actionString;
            }
            if (action.endsWith(".call")) {
                action = action.substring(0, action.length() - 5);
            }
            try {
                String[] targetParamNames = RouteAdapter.getActionParamCache().get(action);
                if (targetParamNames == null) {
                    Method actionMethod = (Method)ActionInvoker.getActionMethod((String)action)[1];
                    Class<?> actionClass = actionMethod.getDeclaringClass();
                    Integer methodHash = LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.computeMethodHash((Class[])actionMethod.getParameterTypes());
                    String synthFieldForMethod = "$" + actionMethod.getName() + methodHash;
                    targetParamNames = (String[])actionClass.getDeclaredField(synthFieldForMethod).get(null);
                    RouteAdapter.getActionParamCache().put(action, targetParamNames);
                }
                if (targetParamNames.length < params.length) {
                    throw new NoRouteFoundException(action, null);
                }
                String k = action;
                for (String p : targetParamNames) {
                    k = k + "_" + p;
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                for (int i = 0; i < params.length; ++i) {
                    String key = i < targetParamNames.length ? targetParamNames[i] : "";
                    String value = params[i] == null ? null : params[i].toString();
                    paramMap.put(key, value);
                }
                String urlPattern = RouteAdapter.getActionCache().get(k);
                if (urlPattern != null) {
                    if ("/{controller}/{action}".equals(urlPattern)) {
                        String qs = StringUtils.buildQuery(paramMap);
                        return "/" + controllerName + "/" + methodName + "?" + qs;
                    }
                    StrSubstitutor sub = new StrSubstitutor(paramMap);
                    sub.setVariablePrefix("{");
                    sub.setVariableSuffix("}");
                    String url = sub.replace(urlPattern);
                    return url;
                }
                Router.ActionDefinition actionDef = Router.reverse((String)action, paramMap);
                return actionDef.toString();
            }
            catch (ActionNotFoundException e) {
                throw new NoRouteFoundException(action, null);
            }
        }
        catch (Exception e) {
            if (e instanceof PlayException) {
                throw (PlayException)e;
            }
            throw new UnexpectedException((Throwable)e);
        }
    }

    private static HashMap<String, String> getActionCache() {
        HashMap hash = (HashMap)Http.Request.current().args.get("actionReverseCache");
        if (hash == null) {
            hash = new HashMap();
            Http.Request.current().args.put("actionReverseCache", hash);
        }
        return hash;
    }

    private static HashMap<String, String[]> getActionParamCache() {
        HashMap hash = (HashMap)Http.Request.current().args.get("actionParamNamesCache");
        if (hash == null) {
            hash = new HashMap();
            Http.Request.current().args.put("actionParamNamesCache", hash);
        }
        return hash;
    }

    public static String reverseStaticLookup(String resource) {
        HashMap<String, String> hash = RouteAdapter.getStaticCache();
        String url = hash.get(resource);
        if (url == null) {
            url = Router.reverseWithCheck((String)resource, (VirtualFile)Play.getVirtualFile((String)resource));
            hash.put(resource, url);
        }
        return url;
    }

    private static HashMap<String, String> getStaticCache() {
        HashMap<String, String> hash = staticCache.get();
        if (hash == null) {
            hash = new HashMap();
            staticCache.set(hash);
        }
        return hash;
    }
}

