/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.ant;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.compiler.JapidTemplateTransformer;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.SourceFileScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslateTemplateTask
extends MatchingTask {
    private List<Class<?>> staticImports = new ArrayList();
    private List<String> imports = new ArrayList<String>();
    private File[] changedFiles;
    private File destDir = null;
    private File srcDir = null;
    private boolean listFiles = false;
    List<Class<? extends Annotation>> typeAnnotations = new ArrayList<Class<? extends Annotation>>();

    public File[] getChangedFiles() {
        return this.changedFiles;
    }

    public void setDestdir(File p_destDir) {
        this.destDir = p_destDir;
    }

    public void setSrcdir(File p_srcDir) {
        this.srcDir = p_srcDir;
    }

    public void setClasspath(Path p_classpath) throws IOException {
        String[] paths = p_classpath.list();
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = new URL("file", null, paths[i]);
        }
    }

    public void setListFiles(boolean p_listFiles) {
        this.listFiles = p_listFiles;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir == null) {
            this.destDir = this.srcDir;
        }
        if (!this.srcDir.exists() && !this.srcDir.isDirectory()) {
            throw new BuildException("source directory \"" + this.srcDir + "\" does not exist or is not a directory", this.getLocation());
        }
        this.destDir.mkdirs();
        if (!this.destDir.exists() || !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir \"" + this.srcDir + "\" does not exist!", this.getLocation());
        }
        SourceFileScanner sfs = new SourceFileScanner((Task)this);
        this.changedFiles = sfs.restrictAsFiles(this.getDirectoryScanner(this.srcDir).getIncludedFiles(), this.srcDir, this.destDir, (FileNameMapper)new JapidFileNameMapper());
        if (this.changedFiles.length > 0) {
            this.log("Processing " + this.changedFiles.length + " template" + (this.changedFiles.length == 1 ? "" : "s") + " to " + this.destDir);
            JapidTemplateTransformer tran = new JapidTemplateTransformer(this.srcDir.getPath(), null);
            for (Class<?> clazz : this.staticImports) {
                tran.addImportStatic(clazz);
            }
            for (String string : this.imports) {
                tran.addImportLine(string);
            }
            for (Class clazz : this.typeAnnotations) {
                tran.addAnnotation(clazz);
            }
            for (int i = 0; i < this.changedFiles.length; ++i) {
                File file = this.changedFiles[i];
                System.out.println("transforming template: " + file.getPath() + " to: " + file.getName().replace("html", "java"));
                if (this.listFiles) {
                    this.log(file.getAbsolutePath());
                }
                try {
                    String relativePath = JapidTemplateTransformer.getRelativePath(file, this.srcDir);
                    tran.generate(relativePath);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BuildException(e.getClass().getName() + ":" + e.getMessage(), new Location(file.getAbsoluteFile().toString()));
                }
            }
        }
    }

    public void importStatic(Class<?> clz) {
        this.staticImports.add(clz);
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    public void addImport(Class<?> clz) {
        this.imports.add(clz.getName());
    }

    public void addAnnotation(Class<? extends Annotation> anno) {
        this.typeAnnotations.add(anno);
    }

    public void setUseStreaming(boolean streaming) {
        AbstractTemplateClassMetaData.streaming = streaming;
    }

    private static class JapidFileNameMapper
    implements FileNameMapper {
        private JapidFileNameMapper() {
        }

        public void setFrom(String p_from) {
        }

        public void setTo(String p_to) {
        }

        public String[] mapFileName(String sourceName) {
            String targetFileName = sourceName;
            int i = targetFileName.lastIndexOf(46);
            if (i > 0 && "html".equals(targetFileName.substring(i + 1))) {
                targetFileName = targetFileName.substring(0, i);
                return new String[]{targetFileName + ".java"};
            }
            return null;
        }
    }
}

