/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.classmeta;

import cn.bran.japid.classmeta.InnerClassMeta;
import cn.bran.japid.classmeta.LayoutClassMetaData;
import cn.bran.japid.tags.Each;
import cn.bran.japid.template.JapidTemplateBase;
import cn.bran.japid.template.JapidTemplateBaseStreaming;
import cn.bran.japid.template.RenderResult;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTemplateClassMetaData {
    private static final String SPACE = " ";
    private static final String STATIC = "static";
    private static final String IMPORT = "import";
    private static Set<String> globalStaticImports = new HashSet<String>();
    private Set<String> staticImports = new HashSet<String>();
    private String originalTemplate;
    public static boolean streaming = false;
    boolean stopWatch = false;
    public StringBuilder sb = new StringBuilder();
    protected static final String SEMI = ";";
    protected static final String TAB = "\t";
    protected static final String RENDER_RESULT = RenderResult.class.getName();
    public String packageName;
    public String className;
    List<String> statics = new ArrayList<String>();
    int staticCounter = 0;
    public String body;
    protected List<InnerClassMeta> innersforTagCalls = new ArrayList<InnerClassMeta>();
    public String superClass;
    private static Set<String> globalImports = new HashSet<String>();
    private Set<String> imports = new HashSet<String>();
    static Set<Class<? extends Annotation>> typeAnnotations = new HashSet<Class<? extends Annotation>>();
    String contentType;
    private boolean trimStaticContent = false;

    public String getOriginalTemplate() {
        return this.originalTemplate;
    }

    public void setOriginalTemplate(String originalTemplate) {
        this.originalTemplate = originalTemplate.replace('\\', '/');
    }

    protected void pln(Object ... ss) {
        for (Object o : ss) {
            this.sb.append(o);
        }
        this.sb.append("\n");
    }

    void p(String s) {
        this.sb.append(s);
    }

    public void addCallTagBodyInnerClass(String className, int count, String classArgs, String body) {
        this.innersforTagCalls.add(new InnerClassMeta(className, count, classArgs, body));
    }

    public void printHeaders() {
        if (this.packageName != null) {
            this.pln("package " + this.packageName + SEMI);
        }
        this.pln("import java.util.*;");
        this.pln("import java.io.*;");
        if (streaming) {
            this.pln("import " + cn.bran.japid.tags.streaming.Each.class.getName() + SEMI);
        } else {
            this.pln("import " + Each.class.getName() + SEMI);
        }
        for (String l : globalImports) {
            if (!(l = l.trim()).endsWith(SEMI)) {
                l = l + SEMI;
            }
            if (!l.startsWith(IMPORT)) {
                l = "import " + l;
            }
            this.pln(l);
        }
        for (String l : this.imports) {
            if (!(l = l.trim()).endsWith(SEMI)) {
                l = l + SEMI;
            }
            if (!l.startsWith(IMPORT)) {
                l = "import " + l;
            }
            this.pln(l);
        }
        for (String l : globalStaticImports) {
            if (!(l = l.trim()).startsWith(IMPORT)) {
                l = "import static " + l;
            }
            if (!l.endsWith(".*;")) {
                l = l + ".*;";
            }
            this.pln(l);
        }
        for (String l : this.staticImports) {
            if (!(l = l.trim()).startsWith(IMPORT)) {
                l = "import static " + l;
            }
            if (!l.endsWith(".*;")) {
                l = l + ".*;";
            }
            this.pln(l);
        }
        this.pln("// NOTE: This file was generated from: " + this.originalTemplate);
        this.pln("// Change to this file will be lost next time the template file is compiled.");
    }

    protected void embedSourceTemplateName() {
        this.pln("\tpublic static final String sourceTemplate = \"" + this.originalTemplate + "\";");
    }

    protected void embedContentType() {
        String t = this.contentType == null ? "text/html" : this.contentType;
        this.pln("\tpublic static final String contentType = \"" + t + "\";");
    }

    protected void callTags() {
        for (InnerClassMeta inner : this.innersforTagCalls) {
            String tagClassName = inner.tagName;
            String field = "private " + tagClassName + " _" + inner.tagName + inner.counter + " = new " + tagClassName + "(getOut());";
            this.pln(TAB + field);
            if (inner.renderBody == null) continue;
            this.pln(inner.toString());
        }
    }

    protected void printAnnotations() {
        for (Class<? extends Annotation> anno : typeAnnotations) {
            this.pln("@" + anno.getName());
        }
    }

    public static void addImportLineGlobal(String imp) {
        if ((imp = imp.trim()).startsWith(IMPORT)) {
            imp = imp.substring(IMPORT.length()).trim();
        }
        globalImports.add(imp);
    }

    protected void buildStatics() {
        for (int i = 0; i < this.statics.size(); ++i) {
            if (streaming) {
                this.pln("static private final byte[] static_" + i + " = getBytes(" + this.statics.get(i) + ");");
                continue;
            }
            this.pln("static private final String static_" + i + " = " + this.statics.get(i) + SEMI);
        }
    }

    protected void addConstructors() {
        if (!streaming) {
            this.pln("\tpublic " + this.className + "() {\r\n" + "\t\tsuper(null);\r\n" + "\t}");
        }
        if (streaming) {
            this.pln("\tpublic " + this.className + "(OutputStream out) {");
        } else {
            this.pln("\tpublic " + this.className + "(StringBuilder out) {");
        }
        this.pln("\t\tsuper(out);");
        this.pln("\t}");
    }

    protected void classDeclare() {
        if (this.superClass == null) {
            String superName = JapidTemplateBase.class.getName();
            if (streaming) {
                superName = JapidTemplateBaseStreaming.class.getName();
            }
            if (this.getClass() == LayoutClassMetaData.class) {
                this.pln("public abstract class " + this.className + " extends " + superName + "{");
            } else {
                this.pln("public class " + this.className + " extends " + superName + "{");
            }
        } else {
            this.pln("public class " + this.className + " extends " + this.superClass + "{");
        }
    }

    public static void addImportStatic(Class<?> class1) {
        String className = class1.getName();
        globalStaticImports.add(className);
    }

    public static void addImportStaticGlobal(String imp) {
        if (imp.startsWith(IMPORT)) {
            imp = imp.substring(IMPORT.length()).trim();
        }
        if (imp.startsWith(STATIC)) {
            imp = imp.substring(IMPORT.length()).trim();
        }
        globalStaticImports.add(imp);
    }

    public void addImport(Class<?> class1) {
        String className = class1.getName();
        this.addImportLine(className);
    }

    public String addStaticText(String text) {
        if (text != null && !text.isEmpty()) {
            if (this.trimStaticContent && text.trim().length() == 0) {
                return null;
            }
            this.statics.add(text);
            return "static_" + (this.statics.size() - 1);
        }
        return null;
    }

    public static void addAnnotation(Class<? extends Annotation> anno) {
        typeAnnotations.add(anno);
    }

    public void setContentType(String contentType) {
    }

    public void turnOnStopwatch() {
        this.stopWatch = true;
    }

    public void addStaticImports(String im) {
        this.staticImports.add(im);
    }

    public void addImportLine(String line) {
        this.imports.add(line);
    }

    public void trimStaticContent() {
        this.trimStaticContent = true;
    }

    public boolean getTrimStaticContent() {
        return this.trimStaticContent;
    }
}

