/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.RenderResult;
import cn.bran.play.JapidResult;
import play.cache.Cache;
import play.classloading.enhancers.ControllersEnhancer;

public abstract class CacheablePlayActionRunner
extends ActionRunner {
    Object[] key = null;
    String ttl = null;

    public CacheablePlayActionRunner(String ttl, Object ... args) {
        this.key = args;
        this.ttl = ttl;
    }

    public RenderResult run() {
        if (this.key != null && this.key.length > 0 && this.ttl != null && this.ttl.length() > 0) {
            String keyString = this.buildKey();
            RenderResult rr = (RenderResult)Cache.get((String)keyString);
            if (rr != null) {
                return rr;
            }
            try {
                ControllersEnhancer.ControllerInstrumentation.initActionCall();
                this.runPlayAction();
            }
            catch (JapidResult jr) {
                rr = jr.getRenderResult();
                Cache.set((String)keyString, (Object)rr, (String)this.ttl);
                return rr;
            }
        }
        try {
            ControllersEnhancer.ControllerInstrumentation.initActionCall();
            this.runPlayAction();
        }
        catch (JapidResult jr) {
            RenderResult rr = jr.getRenderResult();
            return rr;
        }
        throw new RuntimeException("No render result from running play action. Probably the action was not using Japid templates.");
    }

    private String buildKey() {
        String keyString = "";
        for (Object k : this.key) {
            keyString = keyString + ":" + String.valueOf(k);
        }
        return keyString;
    }

    public abstract void runPlayAction() throws JapidResult;
}

