/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.ant.TranslateTemplateTask;
import cn.bran.play.DirUtil;
import cn.bran.play.JapidPlayAdapter;
import cn.bran.play.NoEnhance;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import play.data.validation.Validation;
import play.templates.JavaExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidCommands {
    private static final String APP = "app";

    public static void main(String[] args) {
        if ("gen".equals(args[0])) {
            JapidCommands.gen();
        } else if ("regen".equals(args[0])) {
            JapidCommands.regen();
        } else if ("clean".equals(args[0])) {
            JapidCommands.delAllGeneratedJava();
        } else if ("mkdir".equals(args[0])) {
            JapidCommands.mkdir(".");
        }
    }

    public static List<File> mkdir(String root) {
        File[] controllers;
        Mkdir t = new Mkdir();
        Project proj = new Project();
        t.setProject(proj);
        proj.init();
        String sep = File.separator;
        String japidViews = root + sep + APP + sep + "japidviews" + sep;
        File javatags = new File(japidViews + "_javatags");
        t.setDir(javatags);
        t.execute();
        System.out.println("created: " + javatags.getPath());
        File layouts = new File(japidViews + "_layouts");
        t.setDir(layouts);
        t.execute();
        System.out.println("created: " + layouts.getPath());
        File tags = new File(japidViews + "_tags");
        t.setDir(tags);
        t.execute();
        System.out.println("created: " + tags.getPath());
        File[] dirs = new File[]{javatags, layouts, tags};
        ArrayList<File> res = new ArrayList<File>();
        res.addAll(Arrays.asList(dirs));
        System.out.println("create default packages for controllers.");
        for (File f : controllers = JapidCommands.getAllControllers(root + sep + APP + sep + "controllers")) {
            String cp = japidViews + f.getPath();
            File ff = new File(cp);
            t.setDir(ff);
            t.execute();
            res.add(ff);
            System.out.println("created: " + cp);
        }
        return res;
    }

    public static void regen() {
        JapidCommands.delAllGeneratedJava();
        JapidCommands.gen();
    }

    public static void delAllGeneratedJava() {
        Delete t = new Delete();
        FileSet fs = new FileSet();
        fs.setDir(new File(APP));
        fs.setIncludes("japidviews/**/*.java");
        fs.setExcludes("japidviews/_javatags/**");
        t.addFileset(fs);
        Project proj = new Project();
        t.setProject(proj);
        proj.init();
        t.setTaskType("deljava");
        t.setTaskName("deljava");
        t.setOwningTarget(new Target());
        t.execute();
        System.out.println("removed: all java files in japidviews");
    }

    public static void gen() {
        File[] changedFiles = JapidCommands.reloadChanged();
        if (changedFiles.length > 0) {
            for (File f : changedFiles) {
                System.out.println("updated: " + f.getName().replace("html", "java"));
            }
        } else {
            System.out.println("No java files need to be updated.");
        }
        JapidCommands.rmOrphanJava();
    }

    public static File[] reloadChanged() {
        TranslateTemplateTask t = new TranslateTemplateTask();
        Project proj = new Project();
        t.setProject(proj);
        proj.init();
        t.setSrcdir(new File(APP));
        t.setIncludes("japidviews/**/*.html");
        t.importStatic(JapidPlayAdapter.class);
        t.importStatic(Validation.class);
        t.importStatic(JavaExtensions.class);
        t.addAnnotation(NoEnhance.class);
        t.addImport("japidviews._layouts.*");
        t.addImport("japidviews._javatags.*");
        t.addImport("japidviews._tags.*");
        t.addImport("models.*");
        t.addImport("controllers.*");
        t.setTaskType("foo");
        t.setTaskName("foo");
        t.setOwningTarget(new Target());
        t.execute();
        File[] changedFiles = t.getChangedFiles();
        return changedFiles;
    }

    public static File[] getAllControllers(String root) {
        String[] allFiles = DirUtil.getAllFiles(new File(root), new String[]{"**/*.java"});
        File[] fs = new File[allFiles.length];
        int i = 0;
        for (String f : allFiles) {
            String path = f.replace(".java", "");
            fs[i++] = new File(path);
        }
        return fs;
    }

    public static boolean rmOrphanJava() {
        boolean hasRealOrphan = false;
        try {
            String pathname = APP + File.separator + "japidviews";
            File src = new File(pathname);
            if (!src.exists()) {
                System.out.println("Could not find required Japid package structure: " + pathname);
                System.out.println("Please use \"play japid:mkdir\" command to create the Japid view structure.");
                return hasRealOrphan;
            }
            Set<File> oj = DirUtil.findOrphanJava(src, null);
            for (File j : oj) {
                if (j.getName().contains("_javatags")) continue;
                hasRealOrphan = true;
                String realfile = pathname + File.separator + j.getPath();
                File file = new File(realfile);
                boolean r = file.delete();
                if (r) {
                    System.out.println("JapidPlugin: deleted orphan " + realfile);
                    continue;
                }
                System.out.println("JapidPlugin: failed to delete: " + realfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasRealOrphan;
    }
}

