/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplateBase;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.StackTraceUtils;
import cn.bran.play.JapidResult;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import play.Play;
import play.cache.Cache;
import play.mvc.Controller;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidController
extends Controller {
    protected static <T extends JapidTemplateBase> void render(Class<T> c, Object ... args) {
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            paramTypes[i] = args[i].getClass();
        }
        try {
            Constructor<T> ctor = c.getConstructor(StringBuilder.class);
            Method renderMeth = c.getMethod("render", paramTypes);
            StringBuilder sb = new StringBuilder(8000);
            JapidTemplateBase t = (JapidTemplateBase)ctor.newInstance(sb);
            RenderResult rr = (RenderResult)renderMeth.invoke((Object)t, args);
            throw new JapidResult(rr);
        }
        catch (Exception e) {
            if (e instanceof JapidResult) {
                throw (JapidResult)((Object)e);
            }
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected static void render(RenderResult rr) {
        throw new JapidResult(rr);
    }

    protected static void renderJapid(Object ... objects) {
        String action = Http.Request.current().action.replace(".", "/");
        String templateClassName = "japidviews" + File.separator + action;
        Class tClass = Play.classloader.getClassIgnoreCase(templateClassName.replace('/', '.').replace('\\', '.'));
        if (tClass == null) {
            throw new RuntimeException("There is no default Japid renderer by the name of: " + templateClassName);
        }
        if (!JapidTemplateBase.class.isAssignableFrom(tClass)) {
            throw new RuntimeException("The found class is not a Japid template class: " + templateClassName);
        }
        JapidController.render(tClass, objects);
    }

    protected static void cache(RenderResult rr, String ttl, Object ... objs) {
        String caller = JapidController.buildKey(null, objs);
        Cache.set((String)caller, (Object)rr, (String)ttl);
    }

    protected static void cache(RenderResult rr, String ttl, String keyBase, Object ... objs) {
        String caller = JapidController.buildKey(keyBase, objs);
        Cache.set((String)caller, (Object)rr, (String)ttl);
    }

    protected static RenderResult getFromCache(Object ... objs) {
        String caller = JapidController.buildKey(null, objs);
        Object object = Cache.get((String)caller);
        if (object instanceof RenderResult) {
            return (RenderResult)object;
        }
        return null;
    }

    protected static RenderResult getFromCache(String keyBase, Object ... objs) {
        String caller = JapidController.buildKey(keyBase, objs);
        Object object = Cache.get((String)caller);
        if (object instanceof RenderResult) {
            return (RenderResult)object;
        }
        return null;
    }

    private static String buildKey(String base, Object ... objs) {
        String caller = base;
        if (base == null) {
            caller = StackTraceUtils.getCaller2();
        }
        for (Object o : objs) {
            caller = caller + "-" + String.valueOf(o);
        }
        return caller;
    }

    protected static void runWithCache(ActionRunner runner, String ttl, Object ... objects) {
        String base;
        RenderResult rr;
        if (ttl == null || ttl.trim().length() == 0) {
            throw new RuntimeException("Cache expiration time must be defined.");
        }
        if (Character.isDigit((ttl = ttl.trim()).charAt(ttl.length() - 1))) {
            ttl = ttl + "s";
        }
        if ((rr = JapidController.getFromCache(base = StackTraceUtils.getCaller(), objects)) == null) {
            rr = runner.run();
            JapidController.cache(rr, ttl, base, objects);
        }
        throw new JapidResult(rr);
    }

    protected static void runWithCache(ActionRunner runner, String ttl) {
        JapidController.runWithCache(runner, ttl, new Object[0]);
    }
}

