/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExprParser {
    private String source;
    Stack<Token> emthodCallStackInExpr = new Stack();
    private int end;
    private int begin;
    private int end2;
    private int begin2;
    private int len;
    private Token state = Token.PLAIN;

    public ExprParser(String source) {
        this.source = source;
        this.len = source.length();
        this.emthodCallStackInExpr.push(Token.PLAIN);
    }

    private Token found(Token newState, int skip) {
        this.begin2 = this.begin;
        this.end2 = --this.end;
        this.begin = this.end += skip;
        Token lastState = this.state;
        this.state = newState;
        return lastState;
    }

    private void skip(int skip) {
        this.end2 = --this.end;
        this.end += skip;
    }

    public Integer getLine() {
        String token = this.source.substring(0, this.begin2);
        if (token.indexOf("\n") == -1) {
            return 1;
        }
        return token.split("\n").length;
    }

    public String getToken() {
        return this.source.substring(this.begin2, this.end2);
    }

    public String checkNext() {
        if (this.end2 < this.source.length()) {
            return this.source.charAt(this.end2) + "";
        }
        return "";
    }

    public Token nextToken() {
        block10: while (true) {
            int left;
            if ((left = this.len - this.end) == 0) {
                ++this.end;
                return this.found(Token.EOF, 0);
            }
            char c = this.source.charAt(this.end++);
            char c1 = left > 1 ? this.source.charAt(this.end) : (char)'\u0000';
            char c2 = left > 2 ? this.source.charAt(this.end + 1) : (char)'\u0000';
            switch (this.state) {
                case PLAIN: {
                    if (Character.isJavaIdentifierStart(c)) {
                        return this.found(Token.EXPR, 0);
                    }
                    if (Character.isDigit(c)) {
                        return this.found(Token.NUMBER, 0);
                    }
                    if ('\"' != c) break;
                    return this.found(Token.STRING_LITERAL, 1);
                }
                case EXPR: {
                    if ('(' == c) {
                        this.skipAhread(Token.EXPR_NATURAL_METHOD_CALL, 1);
                        break;
                    }
                    if ('[' == c) {
                        this.skipAhread(Token.ARRAY_OP, 1);
                        break;
                    }
                    if ('<' == c) {
                        this.skipAhread(Token.GENERICS, 1);
                        break;
                    }
                    if ('\"' == c) {
                        this.skipAhread(Token.EXPR_STRING_LITERAL, 1);
                        break;
                    }
                    if (Character.isWhitespace(c) && !this.nextNoneSpaceCharValidExprContinuation()) {
                        this.emthodCallStackInExpr.push(Token.PLAIN);
                        return this.found(Token.PLAIN, 0);
                    }
                    if (',' == c) {
                        this.emthodCallStackInExpr.push(Token.PLAIN);
                        return this.found(Token.PLAIN, 1);
                    }
                    if (Character.isWhitespace(c) || Character.isJavaIdentifierPart(c) || c == '?' || c == '.' || c == ':' || c == '=') continue block10;
                    this.state = Token.EXPR;
                    this.emthodCallStackInExpr.push(Token.PLAIN);
                    return this.found(Token.PLAIN, 0);
                }
                case EXPR_NATURAL_METHOD_CALL: {
                    if ('(' == c) {
                        this.skipAhread(Token.EXPR_NATURAL_METHOD_CALL, 1);
                        break;
                    }
                    if (')' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case ARRAY_OP: {
                    if ('[' == c) {
                        this.skipAhread(Token.ARRAY_OP, 1);
                        break;
                    }
                    if (']' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case GENERICS: {
                    Token laststate;
                    if ('<' == c) {
                        this.skipAhread(Token.GENERICS, 1);
                        break;
                    }
                    if ('>' != c) break;
                    this.state = laststate = this.emthodCallStackInExpr.pop();
                    if (laststate != Token.GENERICS) {
                        ++this.end;
                        return this.found(Token.PLAIN, 0);
                    }
                    this.skip(1);
                    break;
                }
                case EXPR_STRING_LITERAL: {
                    if ('\\' == c && '\"' == c1) {
                        this.skip(2);
                    }
                    if ('\"' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case STRING_LITERAL: {
                    if ('\\' == c && '\"' == c1) {
                        this.skip(2);
                    }
                    if ('\"' != c) break;
                    Token prestate = this.emthodCallStackInExpr.pop();
                    if (Character.isJavaIdentifierStart(c1) || '.' == c1) {
                        --this.begin;
                        this.skipAhread(Token.EXPR, 1);
                        break;
                    }
                    return this.found(prestate, 1);
                }
                case NUMBER: {
                    if (Character.isDigit(c)) break;
                    if (!Character.isWhitespace(c)) {
                        if (',' == c) {
                            return this.found(Token.PLAIN, 1);
                        }
                        throw new RuntimeException("bad expression: number must be terminated with a space.");
                    }
                    return this.found(Token.PLAIN, 0);
                }
            }
        }
    }

    private boolean nextNoneSpaceCharValidExprContinuation() {
        char c = this.nextNoneSpaceChar();
        return c == '.' || c == '[' || c == '<';
    }

    private char nextNoneSpaceChar() {
        for (int p = this.end; p < this.len; ++p) {
            char c = this.source.charAt(p);
            if (Character.isWhitespace(c)) continue;
            return c;
        }
        return '\u0000';
    }

    private void skipAhread(Token exprNatural, int i) {
        this.emthodCallStackInExpr.push(this.state);
        this.state = exprNatural;
        this.skip(i);
    }

    void reset() {
        this.begin2 = 0;
        this.end2 = 0;
        this.begin = 0;
        this.end = 0;
        this.state = Token.PLAIN;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<String> split() {
        ArrayList<String> tl = new ArrayList<String>();
        while (true) {
            Token state = this.nextToken();
            switch (state) {
                case EOF: {
                    return tl;
                }
                case EXPR: 
                case STRING_LITERAL: 
                case NUMBER: {
                    String tokenstring = this.getToken();
                    tl.add(tokenstring);
                    break;
                }
                case PLAIN: 
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        EOF,
        PLAIN,
        EXPR,
        NUMBER,
        EXPR_NATURAL_METHOD_CALL,
        EXPR_STRING_LITERAL,
        ARRAY_OP,
        STRING_LITERAL,
        GENERICS;

    }
}

