/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.compiler.JapidParser;
import cn.bran.japid.compiler.TagArgsParser;
import cn.bran.japid.compiler.TagInvocationLineParser;
import cn.bran.japid.compiler.TemplateSyntaxException;
import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplate;
import cn.bran.japid.template.RenderResult;
import java.io.File;
import java.util.List;
import java.util.Stack;

public abstract class JapidAbstractCompiler {
    private static final String JAPID_RESULT = "cn.bran.play.JapidResult";
    private static final String ARGS = "args";
    protected static final String HTML = ".html";
    protected static final String SPACE = " ";
    protected static final String NEW_LINE = "\n";
    protected JapidTemplate template;
    protected JapidParser parser;
    protected boolean doNextScan = true;
    protected Stack<Tag> tagsStack = new Stack();
    protected int tagIndex;
    protected boolean skipLineBreak;
    protected int currentLine = 1;
    protected int indentLevel = 0;
    JapidParser.Token state;

    public void compile(JapidTemplate t) {
        this.template = t;
        this.getTemplateClassMetaData().setOriginalTemplate(t.name);
        this.hop();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parse() {
        while (true) {
            if (this.doNextScan) {
                this.state = this.parser.nextToken();
            } else {
                this.doNextScan = true;
            }
            switch (this.state) {
                case EOF: {
                    return;
                }
                case PLAIN: {
                    this.plain();
                    break;
                }
                case SCRIPT: {
                    this.script();
                    break;
                }
                case SCRIPT_LINE: {
                    this.script();
                    break;
                }
                case EXPR: {
                    this.expr();
                    break;
                }
                case MESSAGE: {
                    this.message();
                    break;
                }
                case ACTION: {
                    this.action(false);
                    break;
                }
                case ABS_ACTION: {
                    this.action(true);
                    break;
                }
                case COMMENT: {
                    this.skipLineBreak = true;
                    break;
                }
                case START_TAG: {
                    this.startTag();
                    break;
                }
                case END_TAG: {
                    this.endTag();
                    break;
                }
                case TEMPLATE_ARGS: {
                    this.templateArgs();
                }
            }
        }
    }

    protected void plain() {
        String text = this.parser.getToken().replace("\\", "\\\\").replaceAll("\"", "\\\\\"");
        if (this.skipLineBreak && text.startsWith(NEW_LINE)) {
            text = text.substring(1);
        }
        if (this.getTemplateClassMetaData().getTrimStaticContent()) {
            String r = text.trim();
            if (r.length() == 0) {
                return;
            }
            text = text.trim();
        }
        String lines = JapidAbstractCompiler.composeValidMultiLines(text);
        String ref = this.getTemplateClassMetaData().addStaticText(lines);
        if (ref != null) {
            this.print("p(");
            this.print(ref);
            this.print(");");
            this.markLine(this.parser.getLine());
            this.println();
        }
    }

    public static String composeValidMultiLines(String text) {
        String[] lines = text.split(NEW_LINE, 10000);
        String result = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            result = result + "\"" + line;
            result = i == lines.length - 1 && !text.endsWith(NEW_LINE) ? result + "\"\n" : (i == lines.length - 1 && line.equals("") ? result + "\"" : result + "\\n\" + \n");
        }
        return result;
    }

    protected abstract void startTag();

    protected abstract void endTag();

    protected void println() {
        this.print(NEW_LINE);
        ++this.currentLine;
    }

    protected void print(String text) {
        Tag currentScope = this.tagsStack.peek();
        currentScope.bodyBuffer.append(text);
    }

    protected void println(String text) {
        this.print(text);
        this.println();
        int i = 0;
        while (i++ < this.indentLevel) {
            this.print("\t");
        }
    }

    protected void markLine(int line) {
        if (!this.getTemplateClassMetaData().getTrimStaticContent()) {
            this.print("// line " + line);
        }
        this.template.linesMatrix.put(this.currentLine, line);
    }

    protected void script() {
        String text = this.parser.getToken();
        String[] lines = new String[]{text};
        if (text.indexOf(NEW_LINE) > -1) {
            lines = this.parser.getToken().split(NEW_LINE);
        }
        for (int i = 0; i < lines.length; ++i) {
            String sw;
            String contentType;
            String line = lines[i].trim();
            if (line.startsWith("import ") || line.startsWith("import\t")) {
                this.getTemplateClassMetaData().addImportLine(line);
                continue;
            }
            if (line.startsWith("//")) continue;
            if (line.startsWith("extends ") || line.startsWith("extends\t")) {
                String layoutName = line.substring("extends".length()).trim();
                layoutName = layoutName.replace("'", "");
                if ((layoutName = layoutName.replace("\"", "")).endsWith(";")) {
                    layoutName = layoutName.substring(0, layoutName.length() - 1);
                }
                if (layoutName.endsWith(HTML)) {
                    layoutName = layoutName.substring(0, layoutName.indexOf(HTML));
                }
                if (layoutName.startsWith("/")) {
                    layoutName = layoutName.substring(1);
                }
                this.getTemplateClassMetaData().superClass = layoutName.replace('/', '.');
                continue;
            }
            if (line.startsWith("contentType ") || line.startsWith("contentType\t")) {
                contentType = line.substring("contentType".length()).trim().replace("'", "").replace("\"", "");
                if (contentType.endsWith(";")) {
                    contentType = contentType.substring(0, contentType.length());
                }
                this.getTemplateClassMetaData().setContentType(contentType);
                continue;
            }
            if (line.startsWith("setHeader ") || line.startsWith("setHeader\t")) {
                String headerkv = line.substring("setHeader".length()).trim();
                String[] split = headerkv.split("[ |\t]");
                if (split.length < 2) {
                    throw new RuntimeException("setHeaader must take a key and a value string");
                }
                String name = split[0];
                String value = headerkv.substring(name.length()).trim();
                this.getTemplateClassMetaData().setHeader(name, value);
                continue;
            }
            if (line.startsWith("args ") || line.startsWith("args\t")) {
                contentType = line.substring(ARGS.length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                Tag currentTag = this.tagsStack.peek();
                currentTag.bodyArgsString = contentType;
                continue;
            }
            if (line.startsWith("trim ") || line.startsWith("trim\t")) {
                sw = line.substring("trim".length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                if (!"on".equals(sw) && !"true".equals(sw)) continue;
                this.getTemplateClassMetaData().trimStaticContent();
                continue;
            }
            if (line.startsWith("stopwatch ") || line.startsWith("stopwatch\t")) {
                sw = line.substring("stopwatch".length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                if (!"on".equals(sw)) continue;
                this.getTemplateClassMetaData().turnOnStopwatch();
                continue;
            }
            if (line.startsWith("log") || line.startsWith("log\t")) {
                String args = line.substring("log".length()).trim().replace(";", "");
                if (args.trim().length() == 0) {
                    args = "\"\"";
                }
                String logLine = "System.out.println(\"" + this.template.name.replace('\\', '/') + "(line " + (this.parser.getLine() + i) + "): \" + " + args + ");";
                this.println(logLine);
                continue;
            }
            this.print(line);
            this.markLine(this.parser.getLine() + i);
            this.println();
        }
        this.skipLineBreak = true;
    }

    protected void expr() {
        String expr = this.parser.getToken().trim();
        this.print("p(" + expr + ");");
        this.markLine(this.parser.getLine());
        this.println();
    }

    protected void message() {
        String expr = this.parser.getToken().trim().replace('\'', '\"');
        this.print(";p(getMessage(" + expr + "));");
        this.markLine(this.parser.getLine());
        this.println();
    }

    protected void action(boolean absolute) {
        String action = this.parser.getToken().trim();
        if (action.matches("^'.*'$") || action.matches("^\".*\"$")) {
            action = action.replace('\'', '\"');
            if (absolute) {
                this.print("p(lookupStaticAbs(" + action + "));");
            } else {
                this.print("p(lookupStatic(" + action + "));");
            }
        } else {
            int indexOfParam;
            if (!action.endsWith(")")) {
                action = action + "()";
            }
            if ((indexOfParam = action.indexOf("(")) < 1) {
                throw new TemplateSyntaxException("action needs pair of ()", this.template.name, action, this.currentLine);
            }
            String actionPart = action.substring(0, indexOfParam).trim();
            String params = action.substring(indexOfParam + 1);
            if ((params = params.substring(0, params.length() - 1).trim()).length() == 0) {
                params = "new Object[]{}";
            }
            if (absolute) {
                this.print("p(lookupAbs(\"" + actionPart + "\", " + params + "));");
            } else {
                this.print("p(lookup(\"" + actionPart + "\", " + params + "));");
            }
        }
        this.markLine(this.parser.getLine());
        this.println();
    }

    protected void hop() {
        int lastIndexOf;
        String source = this.template.source;
        Tag rootTag = new Tag(){
            {
                this.tagName = "root";
                this.startLine = 0;
                this.hasBody = true;
            }
        };
        this.tagsStack.push(rootTag);
        this.parser = new JapidParser(source);
        String tempName = this.template.name.replace("-", "_");
        if (tempName.endsWith(HTML)) {
            tempName = tempName.substring(0, tempName.indexOf(HTML));
        }
        if ((lastIndexOf = tempName.lastIndexOf(File.separator)) > 0) {
            String path = tempName.substring(0, lastIndexOf);
            path = path.replace('/', '.');
            this.getTemplateClassMetaData().packageName = path = path.replace('\\', '.');
            this.getTemplateClassMetaData().className = tempName.substring(lastIndexOf + 1);
        } else {
            this.getTemplateClassMetaData().className = tempName;
        }
        this.parse();
        Tag tag = this.tagsStack.pop();
        assert (this.tagsStack.empty());
        this.getTemplateClassMetaData().body = tag.bodyBuffer.toString().replace("p(\"\")", "").replace("pln(\"\")", "pln()");
        this.postParsing(tag);
        this.template.javaSource = this.getTemplateClassMetaData().toString();
    }

    protected abstract void postParsing(Tag var1);

    protected abstract AbstractTemplateClassMetaData getTemplateClassMetaData();

    protected void templateArgs() {
        String args;
        Tag currentTag = this.tagsStack.peek();
        currentTag.bodyArgsString = args = this.parser.getToken();
    }

    protected Tag buildTag() {
        String tagText = this.parser.getToken().trim().replaceAll(NEW_LINE, SPACE);
        boolean hasBody = !this.parser.checkNext().endsWith("/");
        Tag tag = new TagInvocationLineParser().parse(tagText);
        if (tag.tagName == null || tag.tagName.length() == 0) {
            throw new RuntimeException("tag name was empty: " + tagText);
        }
        tag.startLine = this.parser.getLine();
        tag.hasBody = hasBody;
        tag.tagIndex = this.tagIndex++;
        return tag;
    }

    protected static String createActionRunner(String actionInvocationWithCache) {
        List<String> params = new TagArgsParser(actionInvocationWithCache).split();
        if (params.size() == 1) {
            return JapidAbstractCompiler.createActionRunner(actionInvocationWithCache, null, null, null);
        }
        String action = params.get(0);
        int left = action.indexOf(40);
        if (left < 1) {
            throw new RuntimeException("invoke: action needs pair of ()");
        }
        String actionPath = "\"" + action.substring(0, left) + "\"";
        if (params.size() == 2) {
            return JapidAbstractCompiler.createActionRunner(action, params.get(1), actionPath, "");
        }
        String args = "";
        for (int i = 2; i < params.size(); ++i) {
            args = args + params.get(i) + ",";
        }
        args = args.substring(0, args.length() - 1);
        return JapidAbstractCompiler.createActionRunner(action, params.get(1), actionPath, args);
    }

    protected void printActionInvocation(String action) {
        this.println(JapidAbstractCompiler.createActionRunner(action));
    }

    protected void regularTagInvoke(Tag tag) {
        String tagVar = "_" + tag.tagName + tag.tagIndex;
        this.println(tagVar + ".setActionRunners(getActionRunners());");
        if (tag.hasBody) {
            this.println(tagVar + ".render(" + tag.args + ", _" + tag.tagName + tag.tagIndex + "DoBody);");
        } else {
            this.println(tagVar + ".render(" + tag.args + ");");
        }
    }

    protected void invokeAction(Tag tag) {
        if (tag.hasBody) {
            throw new JapidCompilationException(this.template, this.currentLine, "invoke tag cannot have a body. Must be ended with /}");
        }
        this.getTemplateClassMetaData().setHasActionInvocation();
        String action = tag.args;
        this.printActionInvocation(action);
    }

    protected void endRegularTag(Tag tag) {
        if (tag.hasBody) {
            this.getTemplateClassMetaData().addCallTagBodyInnerClass(tag.tagName, tag.tagIndex, tag.bodyArgsString, tag.bodyBuffer.toString());
        } else if (!"doLayout".equals(tag.tagName)) {
            this.getTemplateClassMetaData().addCallTagBodyInnerClass(tag.tagName, tag.tagIndex, null, null);
        }
    }

    protected void def(Tag tag) {
    }

    protected void endDef(Tag tag) {
        if (tag.hasBody) {
            this.getTemplateClassMetaData().addDefTag(tag);
        }
    }

    static String createActionRunner(String action, String ttl, String base, String keys) {
        String actionEscaped = action.replace("\"", "\\\"");
        if (ttl == null) {
            String template = "\t\t%s.put(getOut().length(), new %s() {\n\t\t\t@Override\n\t\t\tpublic %s run() {\n\t\t\t\ttry {\n\t\t\t\t\tplay.classloading.enhancers.ControllersEnhancer.ControllerInstrumentation.initActionCall();\n\t\t\t\t\t%s;\n\t\t\t\t} catch (%s jr) {\n\t\t\t\t\treturn jr.getRenderResult();\n\t\t\t\t}\n\t\t\t\tthrow new RuntimeException(\"No render result from running: %s\");\n\t\t\t}\n\t\t});";
            return String.format(template, "actionRunners", ActionRunner.class.getName(), RenderResult.class.getName(), action, JAPID_RESULT, actionEscaped);
        }
        String template = "\t\t%s.put(getOut().length(), new %s(%s, %s, %s) {\r\n\t\t\t@Override\r\n\t\t\tpublic void runPlayAction() throws %s {\r\n\t\t\t\t%s; //\r\n\t\t\t}\r\n\t\t});\r\n";
        return String.format(template, "actionRunners", "cn.bran.play.CacheablePlayActionRunner", ttl, base, "".equals(keys) ? "\"\"" : keys, JAPID_RESULT, action);
    }

    public static class Tag {
        public String tagName;
        public int startLine;
        public boolean hasBody;
        public String bodyArgsString = "";
        public StringBuffer bodyBuffer = new StringBuffer(2000);
        public String innerClassName;
        public String args = "";
        public int tagIndex;
    }
}

