/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.classmeta.LayoutClassMetaData;
import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JapidCompilationException;

public class JapidLayoutCompiler
extends JapidAbstractCompiler {
    LayoutClassMetaData cmd = new LayoutClassMetaData();

    protected void templateArgs() {
        JapidAbstractCompiler.Tag currentTag = (JapidAbstractCompiler.Tag)this.tagsStack.peek();
        if ("root".equals(currentTag.tagName)) {
            throw new RuntimeException("Layouts don't take script level parameters!");
        }
        super.templateArgs();
    }

    protected void startTag() {
        JapidAbstractCompiler.Tag tag = this.buildTag();
        if ("get".equals(tag.tagName)) {
            if (tag.hasBody) {
                throw new RuntimeException("get tag cannot have a body. not closed?");
            }
            String var = tag.args;
            var = var.replace("'", "");
            var = var.replace("\"", "");
            this.cmd.get(var);
            this.print("\t" + var + "();");
        } else if ("doLayout".equals(tag.tagName)) {
            this.print("\tdoLayout();");
        } else if (tag.tagName.equals("invoke")) {
            this.invokeAction(tag);
        } else {
            this.regularTagInvoke(tag);
        }
        this.tagsStack.push(tag);
        this.markLine(this.parser.getLine());
        this.println();
        this.skipLineBreak = true;
    }

    protected void endTag() {
        String tagName = this.parser.getToken().trim();
        if (this.tagsStack.isEmpty()) {
            throw new JapidCompilationException(this.template, this.currentLine, "#{/" + tagName + "} is not opened.");
        }
        JapidAbstractCompiler.Tag tag = (JapidAbstractCompiler.Tag)this.tagsStack.pop();
        String lastInStack = tag.tagName;
        if (tagName.equals("")) {
            tagName = lastInStack;
        }
        if (!lastInStack.equals(tagName)) {
            throw new JapidCompilationException(this.template, tag.startLine, "#{" + tag.tagName + "} is not closed.");
        }
        if (!"get".equals(tagName) && !tagName.equals("invoke")) {
            this.endRegularTag(tag);
        }
        this.markLine(tag.startLine);
        this.println();
        this.skipLineBreak = true;
    }

    protected AbstractTemplateClassMetaData getTemplateClassMetaData() {
        return this.cmd;
    }

    protected void postParsing(JapidAbstractCompiler.Tag tag) {
    }
}

