/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.classmeta.TemplateClassMetaData;
import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JapidCompilationException;

public class JapidTemplateCompiler
extends JapidAbstractCompiler {
    private static final String DO_BODY = "doBody";
    TemplateClassMetaData cmd = new TemplateClassMetaData();

    protected void startTag() {
        JapidAbstractCompiler.Tag tag = this.buildTag();
        if ("extends".equals(tag.tagName)) {
            String layoutName = tag.args;
            layoutName = layoutName.replace("'", "");
            if ((layoutName = layoutName.replace("\"", "")).endsWith(".html")) {
                layoutName = layoutName.substring(0, layoutName.indexOf(".html"));
            }
            if (layoutName.startsWith("/")) {
                layoutName = layoutName.substring(1);
            }
            this.cmd.superClass = layoutName.replace('/', '.');
        } else if (tag.tagName.equals(DO_BODY)) {
            this.cmd.doBody(tag.args);
            this.println("if (body != null)");
            this.println("\tbody.render(" + tag.args + ");");
        } else if ("set".equals(tag.tagName)) {
            if (tag.args.contains(":")) {
                if (tag.hasBody) {
                    throw new JapidCompilationException(this.template, this.currentLine, "set tag cannot have value in tag and in body");
                }
                int i = tag.args.indexOf(":");
                String key = tag.args.substring(0, i).trim().replace("\"", "").replace("'", "");
                String value = tag.args.substring(i + 1);
                this.cmd.addSetTag(key, "p(" + value + ");");
            }
        } else if (tag.tagName.equals("invoke")) {
            this.invokeAction(tag);
        } else if (tag.tagName.equals("def")) {
            this.def(tag);
        } else {
            this.regularTagInvoke(tag);
        }
        this.tagsStack.push(tag);
        this.markLine(this.parser.getLine());
        this.println();
        this.skipLineBreak = true;
    }

    protected void endTag() {
        String tagName = this.parser.getToken().trim();
        if (this.tagsStack.isEmpty()) {
            throw new JapidCompilationException(this.template, this.currentLine, "#{/" + tagName + "} is not opened.");
        }
        JapidAbstractCompiler.Tag tag = (JapidAbstractCompiler.Tag)this.tagsStack.pop();
        String lastInStack = tag.tagName;
        if (tagName.equals("")) {
            tagName = lastInStack;
        }
        if (!lastInStack.equals(tagName)) {
            throw new JapidCompilationException(this.template, tag.startLine, "#{" + tag.tagName + "} is not closed.");
        }
        if ("set".equals(tagName)) {
            if (tag.hasBody) {
                String key = tag.args;
                this.cmd.addSetTag(key, tag.bodyBuffer.toString());
            }
        } else if ("def".equals(tagName)) {
            this.endDef(tag);
        } else if (!(tagName.equals(DO_BODY) || tagName.equals("invoke") || tagName.equals("extends"))) {
            this.endRegularTag(tag);
        }
        this.markLine(tag.startLine);
        this.println();
        this.skipLineBreak = true;
    }

    protected void postParsing(JapidAbstractCompiler.Tag tag) {
        this.cmd.renderArgs = tag.bodyArgsString;
    }

    protected AbstractTemplateClassMetaData getTemplateClassMetaData() {
        return this.cmd;
    }
}

