/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplateBase;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.StackTraceUtils;
import cn.bran.play.CacheableRunner;
import cn.bran.play.JapidResult;
import cn.bran.play.RenderResultCache;
import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.commons.beanutils.MethodUtils;
import play.Play;
import play.cache.Cache;
import play.classloading.enhancers.ControllersEnhancer;
import play.mvc.Controller;
import play.mvc.results.RenderTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidController
extends Controller {
    private static final char DOT = '.';
    private static final String HTML = ".html";

    public static <T extends JapidTemplateBase> void render(Class<T> c, Object ... args) {
        try {
            String methodName = "render";
            Constructor<T> ctor = c.getConstructor(StringBuilder.class);
            StringBuilder sb = new StringBuilder(8000);
            JapidTemplateBase t = (JapidTemplateBase)ctor.newInstance(sb);
            RenderResult rr = (RenderResult)MethodUtils.invokeMethod((Object)t, (String)methodName, (Object[])args);
            throw new JapidResult(rr);
        }
        catch (Exception e) {
            if (e instanceof JapidResult) {
                throw (JapidResult)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    protected static void render(RenderResult rr) {
        throw new JapidResult(rr);
    }

    protected static void renderJapid(Object ... objects) {
        String action = JapidController.template();
        JapidController.renderJapidWith(action, objects);
    }

    public static void renderJapidWith(String template, Object ... args) {
        if (template.endsWith(HTML)) {
            template = template.substring(0, template.length() - HTML.length());
        }
        if (template.startsWith("controllers.")) {
            template = template.substring(template.indexOf(46) + 1);
        }
        String templateClassName = "japidviews" + File.separator + template;
        Class tClass = Play.classloader.getClassIgnoreCase(templateClassName = templateClassName.replace('/', '.').replace('\\', '.'));
        if (tClass == null) {
            String templateFileName = templateClassName.replace('.', '/') + HTML;
            throw new RuntimeException("Could not find a Japid template with the name of: " + templateFileName);
        }
        if (!JapidTemplateBase.class.isAssignableFrom(tClass)) {
            throw new RuntimeException("The found class is not a Japid template class: " + templateClassName);
        }
        JapidController.render(tClass, args);
    }

    protected static void cache(RenderResult rr, String ttl, Object ... objs) {
        String caller = JapidController.buildKey(null, objs);
        Cache.set((String)caller, (Object)rr, (String)ttl);
    }

    protected static void cache(RenderResult rr, String ttl, String keyBase, Object ... objs) {
        String caller = JapidController.buildKey(keyBase, objs);
        Cache.set((String)caller, (Object)rr, (String)ttl);
    }

    protected static RenderResult getFromCache(Object ... objs) {
        if (RenderResultCache.shouldIgnoreCache()) {
            return null;
        }
        String caller = JapidController.buildKey(null, objs);
        Object object = Cache.get((String)caller);
        if (object instanceof RenderResult) {
            return (RenderResult)object;
        }
        return null;
    }

    protected static RenderResult getFromCache(String keyBase, Object ... objs) {
        if (RenderResultCache.shouldIgnoreCache()) {
            return null;
        }
        String caller = JapidController.buildKey(keyBase, objs);
        Object object = Cache.get((String)caller);
        if (object instanceof RenderResult) {
            return (RenderResult)object;
        }
        return null;
    }

    private static String buildKey(String base, Object ... objs) {
        String caller = base;
        if (base == null) {
            caller = StackTraceUtils.getCaller2();
        }
        for (Object o : objs) {
            caller = caller + "-" + String.valueOf(o);
        }
        return caller;
    }

    protected static void runWithCache(ActionRunner runner, String ttl, Object ... objects) {
        String base;
        RenderResult rr;
        if (ttl == null || ttl.trim().length() == 0) {
            throw new RuntimeException("Cache expiration time must be defined.");
        }
        if (Character.isDigit((ttl = ttl.trim()).charAt(ttl.length() - 1))) {
            ttl = ttl + "s";
        }
        if ((rr = JapidController.getFromCache(base = StackTraceUtils.getCaller(), objects)) == null) {
            rr = runner.run();
            JapidController.cache(rr, ttl, base, objects);
        }
        throw new JapidResult(rr);
    }

    protected static void runWithCache(ActionRunner runner, String ttl) {
        JapidController.runWithCache(runner, ttl, new Object[0]);
    }

    protected static void render(CacheableRunner r) {
        RenderResult rr = r.run();
        throw new JapidResult(rr);
    }

    public static void ignoreCache() {
        RenderResultCache.setIgnoreCache(true);
    }

    public static void ignoreCacheNowAndNext() {
        RenderResultCache.setIgnoreCacheInCurrentAndNextReq(true);
    }

    protected static void dontRedirect() {
        ControllersEnhancer.ControllerInstrumentation.initActionCall();
    }

    protected static void renderText(String s) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain; charset=utf-8");
        JapidController.render(new RenderResult(headers, new StringBuilder(s), -1L));
    }

    protected static void renderText(Object o) {
        String str = o == null ? "" : o.toString();
        JapidController.renderText(str);
    }

    protected static void renderText(int o) {
        JapidController.renderText(new Integer(o));
    }

    protected static void renderText(long o) {
        JapidController.renderText(new Long(o));
    }

    protected static void renderText(float o) {
        JapidController.renderText(new Float(o));
    }

    protected static void renderText(double o) {
        JapidController.renderText(new Double(o));
    }

    protected static void renderText(boolean o) {
        JapidController.renderText(new Boolean(o));
    }

    protected static void renderText(char o) {
        JapidController.renderText(new String(new char[]{o}));
    }

    protected static void renderJson(Object o) {
        String json = new Gson().toJson(o);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; charset=utf-8");
        JapidController.render(new RenderResult(headers, new StringBuilder(json), -1L));
    }

    protected static String getResultFromAction(Runnable runnable) {
        JapidController.dontRedirect();
        try {
            runnable.run();
            System.out.println("JapidController.getResultFromAction() warning: the runnable did not generate a result.");
            return "";
        }
        catch (JapidResult e) {
            return e.content;
        }
        catch (RenderTemplate rt) {
            return rt.getContent();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    protected static String getFreshResultFromAction(Runnable runnable) {
        JapidController.ignoreCache();
        return JapidController.getResultFromAction(runnable);
    }
}

