/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.play.Japid;
import cn.bran.play.JapidCommands;
import cn.bran.play.JapidController;
import cn.bran.play.RenderResultCache;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.Play;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Result;

public class JapidPlugin
extends PlayPlugin {
    private static final String RENDER_JAPID_WITH = "/renderJapidWith";
    private static final String NO_CACHE = "no-cache";
    private static AtomicLong lastTimeChecked = new AtomicLong(0L);
    public static final String JAPIDVIEWS_ROOT = "japidviews";
    public static final String JAVATAGS = "_javatags";
    public static final String LAYOUTDIR = "_layouts";
    public static final String TAGSDIR = "_tags";
    private static Pattern renderJapidWithPattern = Pattern.compile(".*/renderJapidWith/(.+)");

    public void onLoad() {
        this.beforeDetectingChanges();
    }

    public void beforeDetectingChanges() {
        if (System.currentTimeMillis() - lastTimeChecked.get() < 1000L) {
            return;
        }
        List<File> changed = JapidCommands.reloadChanged();
        if (changed.size() > 0) {
            for (File file : changed) {
            }
        }
        boolean hasRealOrphan = JapidCommands.rmOrphanJava();
        lastTimeChecked.set(System.currentTimeMillis());
        if (hasRealOrphan) {
            Play.classes.clear();
            throw new RuntimeException("found orphan template Java artifacts. reload to be safe.");
        }
    }

    public void onApplicationStop() {
        try {
            Japid.shutdown();
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public void beforeActionInvocation(Method actionMethod) {
        String string;
        String property = Play.configuration.getProperty("japid.dump.request");
        Http.Request current = Http.Request.current();
        if ("yes".equals(property) || "true".equals(property)) {
            System.out.println("---->>" + current.method + " : " + current.url + " [" + current.action + "]");
        }
        if ((string = Scope.Flash.current().get("j.rtf")) != null) {
            RenderResultCache.setIgnoreCache(true);
        } else {
            Http.Header header = (Http.Header)Http.Request.current().headers.get("cache-control");
            if (header != null) {
                List list = header.values;
                if (list.contains(NO_CACHE)) {
                    RenderResultCache.setIgnoreCache(true);
                }
            } else {
                header = (Http.Header)Http.Request.current().headers.get("pragma");
                if (header != null) {
                    List list = header.values;
                    if (list.contains(NO_CACHE)) {
                        RenderResultCache.setIgnoreCache(true);
                    }
                } else {
                    RenderResultCache.setIgnoreCacheInCurrentAndNextReq(false);
                }
            }
        }
    }

    public void onActionInvocationResult(Result result) {
        Scope.Flash fl = Scope.Flash.current();
        if (RenderResultCache.shouldIgnoreCacheInCurrentAndNextReq()) {
            fl.put("j.rtf", "yes");
        } else {
            fl.remove("j.rtf");
            fl.discard("j.rtf");
        }
        RenderResultCache.setIgnoreCacheInCurrentAndNextReq(false);
    }

    public void afterActionInvocation() {
    }

    public void detectChange() {
    }

    public void beforeInvocation() {
    }

    public void afterApplicationStart() {
        Japid.startup();
    }

    public void onApplicationStart() {
        super.onApplicationStart();
    }

    public void onEvent(String message, Object context) {
    }

    public void routeRequest(Http.Request request) {
        String path = request.path;
        Matcher matcher = renderJapidWithPattern.matcher(path);
        if (matcher.matches()) {
            String template = matcher.group(1);
            JapidController.renderJapidWith(template, new Object[0]);
        }
    }
}

