/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.RenderResult;
import cn.bran.play.CacheableRunner;
import cn.bran.play.CachedRenderResult;
import cn.bran.play.JapidController;
import cn.bran.play.JapidPlugin;
import cn.bran.play.JapidResult;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import play.cache.Cache;
import play.cache.CacheFor;
import play.classloading.enhancers.ControllersEnhancer;
import play.mvc.After;
import play.mvc.Before;
import play.mvc.Finally;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheablePlayActionRunner
extends CacheableRunner {
    String controllerActionString;
    private boolean gotFromCacheForCache;
    private String cacheForVal;

    public CacheablePlayActionRunner(String ttl, Object ... args) {
        super(ttl, args);
        if (args != null && args.length > 0) {
            this.controllerActionString = (String)args[0];
        }
    }

    public CacheablePlayActionRunner(String ttl) {
        super(ttl);
    }

    protected abstract void runPlayAction() throws JapidResult;

    @Override
    protected RenderResult render() {
        try {
            ControllersEnhancer.ControllerInstrumentation.initActionCall();
            this.runPlayAction();
            throw new RuntimeException("No render result from running play action. Probably the action was not using Japid templates.");
        }
        catch (JapidResult jr) {
            if (this.cacheForVal != null && this.cacheForVal.length() > 0 && !this.gotFromCacheForCache) {
                Cache.set((String)this.keyString, (Object)jr, (String)this.cacheForVal);
            }
            return jr.getRenderResult();
        }
    }

    protected void checkActionCacheFor(Class<? extends JapidController> class1, String actionName) {
        String className = class1.getName();
        String cacheForKey = className + "_" + actionName;
        this.cacheForVal = (String)JapidPlugin.getCache().get(cacheForKey);
        if (this.cacheForVal == null) {
            Method[] mths;
            for (Method m : mths = class1.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(actionName) || !Modifier.isPublic(m.getModifiers()) || m.isAnnotationPresent(Before.class) || m.isAnnotationPresent(After.class) || m.isAnnotationPresent(Finally.class)) continue;
                CacheFor cacheFor = m.getAnnotation(CacheFor.class);
                this.cacheForVal = cacheFor == null ? "" : cacheFor.value();
                JapidPlugin.getCache().put(cacheForKey, this.cacheForVal);
            }
        }
        if (this.cacheForVal != null && this.cacheForVal.length() > 0) {
            String key = this.keyString;
            Object v = Cache.get((String)key);
            if (v != null) {
                if (v instanceof JapidResult) {
                    this.gotFromCacheForCache = true;
                    throw (JapidResult)v;
                }
                if (v instanceof CachedRenderResult) {
                    this.gotFromCacheForCache = true;
                    throw new JapidResult(((CachedRenderResult)v).rr);
                }
            }
            return;
        }
    }
}

