/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.RenderResult;
import cn.bran.play.JapidController;
import cn.bran.play.JapidResult;
import cn.bran.play.RenderResultCache;
import cn.bran.play.ShouldRefreshException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public abstract class CacheableRunner
extends ActionRunner
implements Serializable {
    private String ttlAbs = null;
    public String keyString;
    private boolean noCache;
    private boolean readThru;

    public CacheableRunner(String ttl, Object ... args) {
        if (args == null || args.length == 0) {
            this.noCache = true;
        }
        if (ttl == null || ttl.trim().length() == 0) {
            this.noCache = true;
        } else if (ttl.startsWith("-")) {
            this.ttlAbs = ttl.substring(1);
            this.readThru = true;
        } else {
            this.ttlAbs = ttl;
        }
        this.keyString = CacheableRunner.buildKey(args);
    }

    public CacheableRunner(String ttl) {
        this(ttl, JapidController.genCacheKey());
    }

    public RenderResult run() {
        if (this.noCache) {
            return this.render();
        }
        RenderResult rr = null;
        if (!this.readThru) {
            try {
                rr = RenderResultCache.get(this.keyString);
                if (rr != null) {
                    return rr;
                }
            }
            catch (ShouldRefreshException e) {
                // empty catch block
            }
        }
        try {
            RenderResult rr1 = this.render();
            RenderResultCache.set(this.keyString, rr1, this.ttlAbs);
            return rr1;
        }
        catch (JapidResult e) {
            RenderResult rr1 = e.getRenderResult();
            RenderResultCache.set(this.keyString, rr1, this.ttlAbs);
            return rr1;
        }
    }

    public static String buildKey(Object[] keys) {
        String keyString = "";
        for (Object k : keys) {
            keyString = keyString + ":" + String.valueOf(k);
        }
        if (keyString.startsWith(":")) {
            keyString = keyString.length() > 1 ? keyString.substring(1) : "";
        }
        return keyString;
    }

    protected abstract RenderResult render();

    public static void deleteCache(Object ... objects) {
        RenderResultCache.delete(CacheableRunner.buildKey(objects));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.ttlAbs);
        out.writeUTF(this.keyString);
        out.writeBoolean(this.noCache);
        out.writeBoolean(this.readThru);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ttlAbs = in.readUTF();
        this.keyString = in.readUTF();
        this.noCache = in.readBoolean();
        this.readThru = in.readBoolean();
    }
}

