/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import java.util.Stack;

public class JapidParser {
    private String pageSource;
    Stack<Token> emthodCallStackInExpr = new Stack();
    private int end;
    private int begin;
    private int end2;
    private int begin2;
    private int len;
    private Token state = Token.PLAIN;
    private Token lastState;

    public JapidParser(String pageSource) {
        this.pageSource = pageSource;
        this.len = pageSource.length();
    }

    private Token found(Token newState, int skip) {
        this.begin2 = this.begin;
        this.end2 = --this.end;
        this.begin = this.end += skip;
        this.lastState = this.state == Token.EXPR_NATURAL ? Token.EXPR : this.state;
        this.state = newState;
        return this.lastState;
    }

    private void skip(int skip) {
        this.end2 = --this.end;
        this.end += skip;
    }

    public Integer getLineNumber() {
        String token = this.pageSource.substring(0, this.begin2);
        if (token.indexOf("\n") == -1) {
            return 1;
        }
        return token.split("\n").length;
    }

    public String getToken() {
        String tokenString = this.pageSource.substring(this.begin2, this.end2);
        if (this.lastState == Token.PLAIN) {
            tokenString = tokenString.replace("``", "`");
        }
        return tokenString;
    }

    public String checkNext() {
        if (this.end2 < this.pageSource.length()) {
            return this.pageSource.charAt(this.end2) + "";
        }
        return "";
    }

    public Token nextToken() {
        block18: while (true) {
            int left;
            if ((left = this.len - this.end) == 0) {
                ++this.end;
                return this.found(Token.EOF, 0);
            }
            char c = this.pageSource.charAt(this.end++);
            char c1 = left > 1 ? this.pageSource.charAt(this.end) : (char)'\u0000';
            char c2 = left > 2 ? this.pageSource.charAt(this.end + 1) : (char)'\u0000';
            switch (this.state) {
                case PLAIN: {
                    if (c == '%' && c1 == '{') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '{' && c1 == '%') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '~' && c1 == '{') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '~' && c1 == '[') {
                        return this.found(Token.SCRIPT, 2);
                    }
                    if (c == '$' && c1 == '{') {
                        return this.found(Token.EXPR, 2);
                    }
                    if (c == '~' && c1 == '(') {
                        return this.found(Token.TEMPLATE_ARGS, 2);
                    }
                    if (c == '~' && c1 != '~' && (Character.isJavaIdentifierStart(c1) || '\'' == c1)) {
                        return this.found(Token.EXPR_NATURAL, 1);
                    }
                    if (c == '$' && c1 != '$' && (Character.isJavaIdentifierStart(c1) || '\'' == c1)) {
                        return this.found(Token.EXPR_NATURAL, 1);
                    }
                    if (c == '#' && c1 == '{' && c2 == '/') {
                        return this.found(Token.END_TAG, 3);
                    }
                    if (c == '#' && c1 == '{') {
                        return this.found(Token.START_TAG, 2);
                    }
                    if (c == '&' && c1 == '{') {
                        return this.found(Token.MESSAGE, 2);
                    }
                    if (c == '@' && c1 == '@' && c2 == '{') {
                        return this.found(Token.ABS_ACTION, 3);
                    }
                    if (c == '@' && c1 == '{') {
                        return this.found(Token.ACTION, 2);
                    }
                    if (c == '*' && c1 == '{') {
                        return this.found(Token.COMMENT, 2);
                    }
                    if (c != '`') break;
                    if (c1 == '`') {
                        this.skip(2);
                        break;
                    }
                    return this.found(Token.SCRIPT_LINE, 1);
                }
                case SCRIPT: {
                    if (c == '}' && c1 == '%') {
                        return this.found(Token.PLAIN, 2);
                    }
                    if (c == '%' && c1 == '}') {
                        return this.found(Token.PLAIN, 2);
                    }
                    if (c == '}' && c1 == '~') {
                        return this.found(Token.PLAIN, 2);
                    }
                    if (c != ']' || c1 != '~') continue block18;
                    return this.found(Token.PLAIN, 2);
                }
                case SCRIPT_LINE: {
                    if (c == '\r') {
                        if (c1 == '\n') {
                            return this.found(Token.PLAIN, 2);
                        }
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '\n') break;
                    return this.found(Token.PLAIN, 1);
                }
                case COMMENT: {
                    if (c != '}' || c1 != '*') continue block18;
                    return this.found(Token.PLAIN, 2);
                }
                case START_TAG: {
                    if (c == '}') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '/' || c1 != '}') continue block18;
                    return this.found(Token.END_TAG, 1);
                }
                case END_TAG: {
                    if (c != '}') break;
                    return this.found(Token.PLAIN, 1);
                }
                case EXPR: {
                    if (c != '}') break;
                    return this.found(Token.PLAIN, 1);
                }
                case TEMPLATE_ARGS: {
                    if (c != ')') break;
                    return this.found(Token.PLAIN, 1);
                }
                case EXPR_NATURAL: {
                    if ('(' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_METHOD_CALL, 1);
                        break;
                    }
                    if ('[' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_ARRAY_OP, 1);
                        break;
                    }
                    if ('\'' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_STRING_LITERAL, 1);
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        this.state = Token.EXPR;
                        return this.found(Token.PLAIN, 0);
                    }
                    if (Character.isJavaIdentifierPart(c)) break;
                    if (c != '?' && c != '.' && c != ':' && c != '=') {
                        this.state = Token.EXPR;
                        return this.found(Token.PLAIN, 0);
                    }
                    if (Character.isJavaIdentifierStart(c1)) break;
                    if (c == '=' && c1 == '=') {
                        if (Character.isWhitespace(c2)) {
                            this.state = Token.EXPR;
                            return this.found(Token.PLAIN, 0);
                        }
                        this.skip(2);
                        break;
                    }
                    this.state = Token.EXPR;
                    return this.found(Token.PLAIN, 0);
                }
                case EXPR_NATURAL_METHOD_CALL: {
                    if ('(' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_METHOD_CALL, 1);
                        break;
                    }
                    if (')' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case EXPR_NATURAL_ARRAY_OP: {
                    if ('[' == c) {
                        this.skipAhead(Token.EXPR_NATURAL_ARRAY_OP, 1);
                        break;
                    }
                    if (']' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case EXPR_NATURAL_STRING_LITERAL: {
                    if ('\\' == c && '\'' == c1) {
                        this.skip(2);
                    }
                    if ('\'' != c) break;
                    this.state = this.emthodCallStackInExpr.pop();
                    this.skip(1);
                    break;
                }
                case ACTION: {
                    if (c == '}') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '{') break;
                    this.skipAhead(Token.ACTION_CURLY, 1);
                    break;
                }
                case ABS_ACTION: {
                    if (c == '}') {
                        return this.found(Token.PLAIN, 1);
                    }
                    if (c != '{') break;
                    this.skipAhead(Token.ACTION_CURLY, 1);
                    break;
                }
                case ACTION_CURLY: {
                    if (c == '}') {
                        this.state = this.emthodCallStackInExpr.pop();
                        this.skip(1);
                        break;
                    }
                    if (c != '{') break;
                    this.skipAhead(Token.ACTION_CURLY, 1);
                    break;
                }
                case MESSAGE: {
                    if (c != '}') break;
                    return this.found(Token.PLAIN, 1);
                }
            }
        }
    }

    private void skipAhead(Token token, int i) {
        this.emthodCallStackInExpr.push(this.state);
        this.state = token;
        this.skip(i);
    }

    void reset() {
        this.begin2 = 0;
        this.end2 = 0;
        this.begin = 0;
        this.end = 0;
        this.state = Token.PLAIN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        EOF,
        PLAIN,
        SCRIPT,
        SCRIPT_LINE,
        EXPR,
        START_TAG,
        END_TAG,
        MESSAGE,
        ACTION,
        ABS_ACTION,
        ACTION_CURLY,
        COMMENT,
        EXPR_WING,
        EXPR_NATURAL,
        EXPR_NATURAL_METHOD_CALL,
        EXPR_NATURAL_ARRAY_OP,
        EXPR_NATURAL_STRING_LITERAL,
        TEMPLATE_ARGS;

    }
}

