/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JapidLayoutCompiler;
import cn.bran.japid.compiler.JapidTemplateCompiler;
import cn.bran.japid.template.JapidTemplate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidTemplateTransformer {
    private static final String HTML = ".html";
    private String sourceFolder;
    private String targetFolder;

    public JapidTemplateTransformer(String sourceFolder, String targetFolder) {
        this.sourceFolder = sourceFolder;
        this.targetFolder = targetFolder;
    }

    public void addImportLine(String importLine) {
        AbstractTemplateClassMetaData.addImportLineGlobal(importLine);
    }

    public void addImportStatic(Class<?> class1) {
        AbstractTemplateClassMetaData.addImportStatic(class1);
    }

    public File generate(String fileName) throws Exception {
        String target;
        String realTargetFile;
        File f;
        String realSrcFile = this.sourceFolder == null ? fileName : this.sourceFolder + "/" + fileName;
        String src = this.readFileAsString(realSrcFile);
        JapidTemplate temp = new JapidTemplate(fileName, src);
        JapidAbstractCompiler c = null;
        c = src.indexOf("#{doLayout") >= 0 || src.indexOf("#{get") >= 0 ? new JapidLayoutCompiler() : new JapidTemplateCompiler();
        c.compile(temp);
        String jsrc = temp.javaSource;
        String fileNameRoot = fileName;
        if (fileName.endsWith(HTML)) {
            fileNameRoot = fileName.substring(0, fileName.indexOf(HTML));
        }
        if (!(f = new File(realTargetFile = (target = this.targetFolder == null ? this.sourceFolder : this.targetFolder) == null ? fileNameRoot + ".java" : target + "/" + fileNameRoot + ".java")).exists()) {
            String parent = f.getParent();
            new File(parent).mkdirs();
        }
        BufferedOutputStream bf = new BufferedOutputStream(new FileOutputStream(f));
        bf.write(jsrc.getBytes("UTF-8"));
        bf.close();
        return f;
    }

    private String readFileAsString(String filePath) throws Exception {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = new BufferedInputStream(new FileInputStream(filePath));
        f.read(buffer);
        f.close();
        return new String(buffer, "UTF-8");
    }

    public static String getRelativePath(File child, File parent) throws IOException {
        String curPath = parent.getCanonicalPath();
        String childPath = child.getCanonicalPath();
        assert (childPath.startsWith(curPath));
        String srcRelative = childPath.substring(curPath.length());
        if (srcRelative.startsWith(File.separator)) {
            srcRelative = srcRelative.substring(File.separator.length());
        }
        return srcRelative;
    }

    public File generate(File file) throws Exception {
        String rela = JapidTemplateTransformer.getRelativePath(file, new File("."));
        return this.generate(rela);
    }

    public void addAnnotation(Class<? extends Annotation> anno) {
        AbstractTemplateClassMetaData.addAnnotation(anno);
    }
}

