/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirUtil {
    public static Set<File> findOrphanJava(File src, File target) {
        if (target == null) {
            target = src;
        }
        String[] allSrc = DirUtil.getAllFileNames(src, new String[]{".java", ".html"});
        HashSet<String> javas = new HashSet<String>();
        HashSet<String> htmls = new HashSet<String>();
        for (String s : allSrc) {
            if (s.endsWith(".java")) {
                javas.add(s);
                continue;
            }
            if (!s.endsWith(".html")) continue;
            htmls.add(s.substring(0, s.lastIndexOf(46)) + ".java");
        }
        javas.removeAll(htmls);
        HashSet<File> re = new HashSet<File>();
        for (String j : javas) {
            re.add(new File(j));
        }
        return re;
    }

    public static String[] getAllFileNames(File dir, String[] exts) {
        ArrayList<String> files = new ArrayList<String>();
        DirUtil.getAllFileNames("", dir, files, exts);
        String[] ret = new String[files.size()];
        return files.toArray(ret);
    }

    public static Set<File> getAllFiles(File dir, String[] exts, Set<File> fs) {
        Set<File> scanFiles = DirUtil.scanFiles(dir, exts, fs);
        return scanFiles;
    }

    private static Set<File> scanFiles(File dir, String[] exts, Set<File> fs) {
        File[] flist;
        for (File f : flist = dir.listFiles()) {
            if (f.isDirectory()) {
                DirUtil.getAllFiles(f, exts, fs);
                continue;
            }
            if (!DirUtil.match(f, exts)) continue;
            fs.add(f);
        }
        return fs;
    }

    private static void getAllFileNames(String leadingPath, File dir, List<String> files, String[] exts) {
        File[] flist = dir.listFiles();
        if (flist == null) {
            throw new RuntimeException("directory exists? " + dir.getPath());
        }
        for (File f : flist) {
            if (f.isDirectory()) {
                DirUtil.getAllFileNames(leadingPath + f.getName() + File.separatorChar, f, files, exts);
                continue;
            }
            if (!DirUtil.match(f, exts)) continue;
            files.add(leadingPath + f.getName());
        }
    }

    static boolean match(File f, String[] exts) {
        for (String ext : exts) {
            if (!f.getName().endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static List<File> findChangedHtmlFiles(File src) {
        Set<File> allSrc = new HashSet<File>();
        allSrc = DirUtil.getAllFiles(src, new String[]{".java", ".html"}, allSrc);
        HashMap<String, Long> javas = new HashMap<String, Long>();
        HashMap<String, Long> htmls = new HashMap<String, Long>();
        for (File s : allSrc) {
            String path = s.getPath();
            if (path.endsWith(".java")) {
                javas.put(path.substring(0, path.length() - 5), s.lastModified());
                continue;
            }
            if (!path.endsWith(".html")) continue;
            htmls.put(path.substring(0, path.length() - 5), s.lastModified());
        }
        ArrayList<File> rs = new ArrayList<File>();
        for (String k : htmls.keySet()) {
            Long t = (Long)javas.get(k);
            if (t == null) {
                rs.add(new File(k + ".html"));
                continue;
            }
            if (((Long)htmls.get(k)).compareTo(t) <= 0) continue;
            rs.add(new File(k + ".html"));
        }
        return rs;
    }
}

