/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.util;

import cn.bran.japid.template.JapidTemplateBase;
import cn.bran.japid.template.RenderResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerUtils {
    private static final String RENDER_METHOD = "render";

    public static <T extends JapidTemplateBase> RenderResult render(T t, Object ... args) {
        String className = t.getClass().getName();
        Method[] methods = t.getClass().getDeclaredMethods();
        if (args == null) {
            args = new Object[]{null};
        }
        for (Method m : methods) {
            if (!m.getName().equals(RENDER_METHOD)) continue;
            Class<?>[] types = m.getParameterTypes();
            if (types.length != args.length) {
                throw new RuntimeException("The number of arguments does not match the template's parameters: " + className);
            }
            try {
                Object invoke = m.invoke(t, args);
                return (RenderResult)invoke;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Template argument type mismatch: " + className);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                te.printStackTrace();
                throw new RuntimeException("error in running the renderer: " + te.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Could not find a render() in the template: " + className);
    }
}

