/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.compiler.TranslateTemplateTask;
import cn.bran.japid.util.DirUtil;
import cn.bran.play.JapidPlayAdapter;
import cn.bran.play.NoEnhance;
import cn.bran.play.WebUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import play.data.validation.Error;
import play.data.validation.Validation;
import play.mvc.Http;
import play.mvc.Scope;
import play.templates.JavaExtensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidCommands {
    private static final String APP = "app";
    private static final String JapidWebUtil = "package japidviews._javatags;\n\n/**\n * a well-know place to add all the static method you want to use in your\n * templates.\n * \n * All the public static methods will be automatically \"import static \" to the\n * generated Java classes by the Japid compiler.\n * \n */\npublic class JapidWebUtil {\n\tpublic static String hi() {\n\t\treturn \"Hi\";\n\t}\n\t// your utility methods...\n\t\n}\n";

    public static void main(String[] args) throws IOException {
        String arg0 = args[0];
        if ("gen".equals(arg0)) {
            JapidCommands.gen(APP);
        } else if ("regen".equals(arg0)) {
            JapidCommands.regen(APP);
        } else if ("clean".equals(arg0)) {
            JapidCommands.delAllGeneratedJava(APP + File.separatorChar + "japidviews");
        } else if ("mkdir".equals(arg0)) {
            JapidCommands.mkdir(APP);
        } else {
            JapidCommands.log("not known: " + arg0);
        }
    }

    public static List<File> mkdir(String root) throws IOException {
        File notifiers;
        File tags;
        File layouts;
        File webutil;
        String sep = File.separator;
        String japidViews = root + sep + "japidviews" + sep;
        File javatags = new File(japidViews + "_javatags");
        if (!javatags.exists()) {
            boolean mkdirs = javatags.mkdirs();
            assert (mkdirs);
            JapidCommands.log("created: " + javatags.getPath());
        }
        if (!(webutil = new File(javatags, "JapidWebUtil.java")).exists()) {
            FileUtils.writeStringToFile((File)webutil, (String)JapidWebUtil, (String)"UTF-8");
            JapidCommands.log("created JapidWebUtil.java.");
        }
        if (!(layouts = new File(japidViews + "_layouts")).exists()) {
            boolean mkdirs = layouts.mkdirs();
            assert (mkdirs);
            JapidCommands.log("created: " + layouts.getPath());
        }
        if (!(tags = new File(japidViews + "_tags")).exists()) {
            boolean mkdirs = tags.mkdirs();
            assert (mkdirs);
            JapidCommands.log("created: " + tags.getPath());
        }
        if (!(notifiers = new File(japidViews + "_notifiers")).exists()) {
            boolean mkdirs = notifiers.mkdirs();
            assert (mkdirs);
            JapidCommands.log("created: " + notifiers.getPath());
        }
        File[] dirs = new File[]{javatags, layouts, tags};
        ArrayList<File> res = new ArrayList<File>();
        res.addAll(Arrays.asList(dirs));
        try {
            File[] controllers;
            for (File f : controllers = JapidCommands.getAllJavaFilesInDir(root + sep + "controllers")) {
                String cp = japidViews + f.getPath();
                File ff = new File(cp);
                if (ff.exists()) continue;
                boolean mkdirs = ff.mkdirs();
                assert (mkdirs);
                res.add(ff);
                JapidCommands.log("created: " + cp);
            }
        }
        catch (Exception e) {
            JapidCommands.log(e.toString());
        }
        try {
            File[] controllers;
            String notifiersDir = root + sep + "notifiers";
            File notifiersDirFile = new File(notifiersDir);
            if (!notifiersDirFile.exists()) {
                if (notifiersDirFile.mkdir()) {
                    JapidCommands.log("created the email notifiers directory. ");
                } else {
                    JapidCommands.log("email notifiers directory did not exist and could not be created for unknow reason. ");
                }
            }
            for (File f : controllers = JapidCommands.getAllJavaFilesInDir(notifiersDir)) {
                String cp = japidViews + "_notifiers" + sep + f.getPath();
                File ff = new File(cp);
                if (ff.exists()) continue;
                boolean mkdirs = ff.mkdirs();
                assert (mkdirs);
                res.add(ff);
                JapidCommands.log("created: " + cp);
            }
        }
        catch (Exception e) {
            JapidCommands.log(e.toString());
        }
        return res;
    }

    public static void regen() throws IOException {
        JapidCommands.regen(APP);
    }

    public static void regen(String root) throws IOException {
        String pathname = root + File.separatorChar + "japidviews";
        JapidCommands.delAllGeneratedJava(pathname);
        JapidCommands.gen(root);
    }

    public static void delAllGeneratedJava(String pathname) {
        String[] javas;
        for (String j : javas = DirUtil.getAllFileNames((File)new File(pathname), (String[])new String[]{"java"})) {
            if (j.contains("_javatags")) continue;
            JapidCommands.log("removed: " + j);
            boolean delete = new File(pathname + File.separatorChar + j).delete();
            if (delete) continue;
            throw new RuntimeException("file was not deleted: " + j);
        }
    }

    public static void gen(String packageRoot) throws IOException {
        List<File> changedFiles = JapidCommands.reloadChanged(packageRoot);
        if (changedFiles.size() > 0) {
            for (File f : changedFiles) {
                JapidCommands.log("updated: " + f.getName().replace("html", "java"));
            }
        } else {
            JapidCommands.log("No java files need to be updated.");
        }
        JapidCommands.rmOrphanJava();
    }

    public static List<File> reloadChanged(String root) {
        try {
            JapidCommands.mkdir(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TranslateTemplateTask t = new TranslateTemplateTask();
        File rootDir = new File(root);
        t.setPackageRoot(rootDir);
        t.setInclude(new File(rootDir, "japidviews"));
        t.importStatic(JapidPlayAdapter.class);
        t.importStatic(Validation.class);
        t.importStatic(JavaExtensions.class);
        t.importStatic(WebUtils.class);
        t.addAnnotation(NoEnhance.class);
        t.addImport("japidviews._layouts.*");
        t.addImport("japidviews._javatags.*");
        t.addImport("japidviews._tags.*");
        t.addImport(Scope.class.getName() + ".*");
        t.addImport(Http.class.getName() + ".*");
        t.addImport(Validation.class.getName());
        t.addImport(Error.class.getName());
        t.addImport("models.*");
        t.addImport("controllers.*");
        t.addImport("static  japidviews._javatags.JapidWebUtil.*");
        t.execute();
        List changedFiles = t.getChangedFiles();
        return changedFiles;
    }

    public static File[] getAllJavaFilesInDir(String root) {
        String[] allFiles = DirUtil.getAllFileNames((File)new File(root), (String[])new String[]{".java"});
        File[] fs = new File[allFiles.length];
        int i = 0;
        for (String f : allFiles) {
            String path = f.replace(".java", "");
            fs[i++] = new File(path);
        }
        return fs;
    }

    public static boolean rmOrphanJava() {
        boolean hasRealOrphan = false;
        try {
            String pathname = APP + File.separator + "japidviews";
            File src = new File(pathname);
            if (!src.exists()) {
                JapidCommands.log("Could not find required Japid package structure: " + pathname);
                JapidCommands.log("Please use \"play japid:mkdir\" command to create the Japid view structure.");
                return hasRealOrphan;
            }
            Set oj = DirUtil.findOrphanJava((File)src, null);
            for (File j : oj) {
                String path = j.getPath();
                if (path.contains("_javatags")) continue;
                hasRealOrphan = true;
                String realfile = pathname + File.separator + path;
                File file = new File(realfile);
                boolean r = file.delete();
                if (r) {
                    JapidCommands.log("deleted orphan " + realfile);
                    continue;
                }
                JapidCommands.log("failed to delete: " + realfile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasRealOrphan;
    }

    public static List<File> reloadChanged() {
        return JapidCommands.reloadChanged(APP);
    }

    private static void log(String m) {
        System.out.println("[JapidCommands]: " + m);
    }
}

