/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JapidLayoutCompiler;
import cn.bran.japid.compiler.JapidTemplateCompiler;
import cn.bran.japid.template.JapidTemplate;
import cn.bran.japid.util.DirUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidTemplateTransformer {
    private static final String HTML = ".html";
    private String sourceFolder;
    private String targetFolder;
    static Pattern doLayoutTag = Pattern.compile(".*\\#\\{\\s*doLayout\\s*.*");
    static Pattern doLayoutDirective = Pattern.compile(".*`doLayout\\s*");
    static Pattern getTag = Pattern.compile(".*\\#\\{\\s*get\\s*.*");
    static Pattern getDirective = Pattern.compile(".*`get\\s+\\w+\\s*");

    public JapidTemplateTransformer(String sourceFolder, String targetFolder) {
        this.sourceFolder = sourceFolder;
        this.targetFolder = targetFolder;
    }

    public void addImportLine(String importLine) {
        AbstractTemplateClassMetaData.addImportLineGlobal(importLine);
    }

    public void addImportStatic(Class<?> class1) {
        AbstractTemplateClassMetaData.addImportStatic(class1);
    }

    public static boolean looksLikeLayout(String src) {
        String[] split;
        for (String line : split = src.split("[\r\n]")) {
            if (!doLayoutTag.matcher(line).matches() && !doLayoutDirective.matcher(line).matches() && !getTag.matcher(line).matches() && !getDirective.matcher(line).matches()) continue;
            return true;
        }
        return false;
    }

    public File generate(String fileName) throws Exception {
        String realSrcFile = this.sourceFolder == null ? fileName : this.sourceFolder + "/" + fileName;
        String src = this.readFileAsString(realSrcFile);
        JapidTemplate temp = new JapidTemplate(fileName, src);
        JapidAbstractCompiler c = null;
        c = JapidTemplateTransformer.looksLikeLayout(src) ? new JapidLayoutCompiler() : new JapidTemplateCompiler();
        c.compile(temp);
        String jsrc = temp.javaSource;
        String fileNameRoot = DirUtil.mapSrcToJava(fileName);
        String target = this.targetFolder == null ? this.sourceFolder : this.targetFolder;
        String realTargetFile = target == null ? fileNameRoot : target + "/" + fileNameRoot;
        File f = new File(realTargetFile);
        if (!f.exists()) {
            String parent = f.getParent();
            new File(parent).mkdirs();
        }
        BufferedOutputStream bf = new BufferedOutputStream(new FileOutputStream(f));
        bf.write(jsrc.getBytes("UTF-8"));
        bf.close();
        return f;
    }

    private String readFileAsString(String filePath) throws Exception {
        byte[] buffer = new byte[(int)new File(filePath).length()];
        BufferedInputStream f = new BufferedInputStream(new FileInputStream(filePath));
        f.read(buffer);
        f.close();
        return new String(buffer, "UTF-8");
    }

    public static String getRelativePath(File child, File parent) throws IOException {
        String curPath = parent.getCanonicalPath();
        String childPath = child.getCanonicalPath();
        assert (childPath.startsWith(curPath));
        String srcRelative = childPath.substring(curPath.length());
        if (srcRelative.startsWith(File.separator)) {
            srcRelative = srcRelative.substring(File.separator.length());
        }
        return srcRelative;
    }

    public File generate(File file) throws Exception {
        String rela = JapidTemplateTransformer.getRelativePath(file, new File("."));
        return this.generate(rela);
    }

    public void addAnnotation(Class<? extends Annotation> anno) {
        AbstractTemplateClassMetaData.addAnnotation(anno);
    }
}

