/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.compiler.JapidAbstractCompiler;
import cn.bran.japid.compiler.JavaSyntaxTool;

public class TagInvocationLineParser {
    public JapidAbstractCompiler.Tag parse(String line) {
        String original = line;
        JapidAbstractCompiler.Tag tag = new JapidAbstractCompiler.Tag();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '/') continue;
            if (Character.isWhitespace(c) || c == '(' || c == '|') {
                tag.tagName = line.substring(0, i).replace('/', '.');
                if (tag.tagName.startsWith("..")) {
                    tag.tagName = tag.tagName.substring(1);
                }
                line = line.substring(i).trim();
                break;
            }
            throw new RuntimeException(" tag invocation syntax error: " + c);
        }
        if (tag.tagName == null) {
            tag.tagName = line.replace('/', '.');
            return tag;
        }
        int vertline = line.lastIndexOf(124);
        if (vertline >= 0) {
            String closureArgs = line.substring(vertline + 1).trim();
            JavaSyntaxTool.parseParams(closureArgs);
            tag.callbackArgs = closureArgs;
            tag.hasBody = true;
            line = line.substring(0, vertline).trim();
        }
        if (line.length() == 0) {
            return tag;
        }
        char firstC = line.charAt(0);
        char lastC = line.charAt(line.length() - 1);
        if ('(' == firstC) {
            if (')' != lastC) {
                throw new RuntimeException("The tag argument part is not valid");
            }
            tag.args = line.substring(1, line.length() - 1);
        } else {
            tag.args = line;
        }
        return tag;
    }
}

