/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.play;

import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplateBase;
import cn.bran.japid.template.JapidTemplateBaseWithoutPlay;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.RenderInvokerUtils;
import cn.bran.japid.util.StackTraceUtils;
import cn.bran.play.CacheableRunner;
import cn.bran.play.JapidResult;
import cn.bran.play.RenderResultCache;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import play.Play;
import play.cache.Cache;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.ControllersEnhancer;
import play.mvc.After;
import play.mvc.Before;
import play.mvc.Controller;
import play.mvc.Finally;
import play.mvc.Http;
import play.mvc.results.RenderTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapidController
extends Controller {
    private static final char DOT = '.';
    private static final String HTML = ".html";

    public static <T extends JapidTemplateBase> void render(Class<T> c, Object ... args) {
        try {
            RenderResult rr = JapidController.invokeRender(c, args);
            throw new JapidResult(rr);
        }
        catch (Exception e) {
            if (e instanceof JapidResult) {
                throw (JapidResult)((Object)e);
            }
            throw new RuntimeException(e);
        }
    }

    private static <T extends JapidTemplateBase> RenderResult invokeRender(Class<T> c, Object ... args) {
        int modifiers = c.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new RuntimeException("Cannot init the template class since it's an abstract class: " + c.getName());
        }
        try {
            Constructor<T> ctor = c.getConstructor(StringBuilder.class);
            StringBuilder sb = new StringBuilder(8000);
            JapidTemplateBase t = (JapidTemplateBase)ctor.newInstance(sb);
            RenderResult rr = (RenderResult)RenderInvokerUtils.render((JapidTemplateBaseWithoutPlay)t, (Object[])args);
            return rr;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not match the arguments with the template args.");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate the template object. Abstract?");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Could not invoke the template object: " + e);
        }
    }

    protected static void render(RenderResult rr) {
        throw new JapidResult(rr);
    }

    protected static void renderJapid(Object ... objects) {
        String action = JapidController.template();
        JapidController.renderJapidWith(action, objects);
    }

    protected static void renderJapidEager(Object ... objects) {
        String action = JapidController.template();
        JapidController.renderJapidWithEager(action, objects);
    }

    public static void renderJapidWith(String template, Object ... args) {
        throw new JapidResult(JapidController.getRenderResultWith(template, args));
    }

    public static void renderJapidWithEager(String template, Object ... args) {
        throw new JapidResult(JapidController.getRenderResultWith(template, args)).eval();
    }

    protected static String template() {
        StackTraceElement[] stes;
        for (StackTraceElement st : stes = new Throwable().getStackTrace()) {
            ApplicationClasses.ApplicationClass appClass;
            Method actionMethod;
            Class controllerClass;
            String controller = st.getClassName();
            String action = st.getMethodName();
            ApplicationClasses.ApplicationClass conAppClass = Play.classes.getApplicationClass(controller);
            if (conAppClass == null || !JapidController.class.isAssignableFrom(controllerClass = conAppClass.javaClass) || (actionMethod = JapidController.findActionMethod(action, controllerClass)) == null) continue;
            String expr = controller + "." + action;
            String format = Http.Request.current().format;
            if ("html".equals(format)) {
                return expr;
            }
            String expr_format = expr + "_" + format;
            if (expr_format.startsWith("controllers.")) {
                expr_format = "japidviews" + expr_format.substring(expr_format.indexOf(46));
            }
            if ((appClass = Play.classes.getApplicationClass(expr_format)) != null) {
                return expr_format;
            }
            return expr;
        }
        throw new RuntimeException("The calling stack does not contain a valid controller. Should not have happended...");
    }

    public static Method findActionMethod(String name, Class clazz) {
        while (!clazz.getName().equals("java.lang.Object")) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(name) || m.isAnnotationPresent(Before.class) || m.isAnnotationPresent(After.class) || m.isAnnotationPresent(Finally.class)) continue;
                return m;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public static RenderResult getRenderResultWith(String template, Object ... args) {
        if (template == null || template.length() == 0) {
            template = JapidController.template();
        }
        if (template.endsWith(HTML)) {
            template = template.substring(0, template.length() - HTML.length());
        }
        if (template.startsWith("@")) {
            template = JapidController.request.controller + "/" + template.substring(1);
        }
        if (template.startsWith("controllers.")) {
            template = template.substring(template.indexOf(46) + 1);
        }
        String templateClassName = template.startsWith("japidviews") ? template : "japidviews" + File.separator + template;
        ApplicationClasses.ApplicationClass appClass = Play.classes.getApplicationClass(templateClassName = templateClassName.replace('/', '.').replace('\\', '.'));
        if (appClass == null) {
            String templateFileName = templateClassName.replace('.', '/') + HTML;
            throw new RuntimeException("Could not find a Japid template with the name of: " + templateFileName);
        }
        Class tClass = appClass.javaClass;
        if (JapidTemplateBase.class.isAssignableFrom(tClass)) {
            RenderResult rr = JapidController.invokeRender(tClass, args);
            return rr;
        }
        throw new RuntimeException("The found class is not a Japid template class: " + templateClassName);
    }

    protected static void cache(RenderResult rr, String ttl, Object ... objs) {
        String caller = JapidController.buildKey(null, objs);
        Cache.set((String)caller, (Object)rr, (String)ttl);
    }

    protected static void cache(RenderResult rr, String ttl, String keyBase, Object ... objs) {
        String caller = JapidController.buildKey(keyBase, objs);
        Cache.set((String)caller, (Object)rr, (String)ttl);
    }

    protected static RenderResult getFromCache(Object ... objs) {
        if (RenderResultCache.shouldIgnoreCache()) {
            return null;
        }
        String caller = JapidController.buildKey(null, objs);
        Object object = Cache.get((String)caller);
        if (object instanceof RenderResult) {
            return (RenderResult)object;
        }
        return null;
    }

    protected static RenderResult getFromCache(String keyBase, Object ... objs) {
        if (RenderResultCache.shouldIgnoreCache()) {
            return null;
        }
        String caller = JapidController.buildKey(keyBase, objs);
        Object object = Cache.get((String)caller);
        if (object instanceof RenderResult) {
            return (RenderResult)object;
        }
        return null;
    }

    private static String buildKey(String base, Object ... objs) {
        String caller = base;
        if (base == null) {
            caller = StackTraceUtils.getCaller2();
        }
        for (Object o : objs) {
            caller = caller + "-" + String.valueOf(o);
        }
        return caller;
    }

    protected static void runWithCache(ActionRunner runner, String ttl, Object ... objects) {
        String base;
        RenderResult rr;
        if (ttl == null || ttl.trim().length() == 0) {
            throw new RuntimeException("Cache expiration time must be defined.");
        }
        if (Character.isDigit((ttl = ttl.trim()).charAt(ttl.length() - 1))) {
            ttl = ttl + "s";
        }
        if ((rr = JapidController.getFromCache(base = StackTraceUtils.getCaller(), objects)) == null) {
            rr = runner.run();
            JapidController.cache(rr, ttl, base, objects);
        }
        throw new JapidResult(rr);
    }

    protected static void runWithCache(ActionRunner runner, String ttl) {
        JapidController.runWithCache(runner, ttl, new Object[0]);
    }

    protected static void render(CacheableRunner r) {
        RenderResult rr = r.run();
        throw new JapidResult(rr);
    }

    public static void ignoreCache() {
        RenderResultCache.setIgnoreCache(true);
    }

    public static void ignoreCacheNowAndNext() {
        RenderResultCache.setIgnoreCacheInCurrentAndNextReq(true);
    }

    protected static void dontRedirect() {
        ControllersEnhancer.ControllerInstrumentation.initActionCall();
    }

    protected static void renderText(String s) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain; charset=utf-8");
        JapidController.render(new RenderResult(headers, new StringBuilder(s), -1L));
    }

    protected static void renderText(Object o) {
        String str = o == null ? "" : o.toString();
        JapidController.renderText(str);
    }

    protected static void renderText(int o) {
        JapidController.renderText(new Integer(o));
    }

    protected static void renderText(long o) {
        JapidController.renderText(new Long(o));
    }

    protected static void renderText(float o) {
        JapidController.renderText(new Float(o));
    }

    protected static void renderText(double o) {
        JapidController.renderText(new Double(o));
    }

    protected static void renderText(boolean o) {
        JapidController.renderText(new Boolean(o));
    }

    protected static void renderText(char o) {
        JapidController.renderText(new String(new char[]{o}));
    }

    protected static String getResultFromAction(Runnable runnable) {
        JapidController.dontRedirect();
        try {
            runnable.run();
            System.out.println("JapidController.getResultFromAction() warning: the runnable did not generate a result.");
            return "";
        }
        catch (JapidResult e) {
            return e.extractContent();
        }
        catch (RenderTemplate rt) {
            return rt.getContent();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    protected static String getFreshResultFromAction(Runnable runnable) {
        JapidController.ignoreCache();
        return JapidController.getResultFromAction(runnable);
    }

    public static String genCacheKey() {
        return "japidcache:" + Http.Request.current().action + ":" + Http.Request.current().querystring;
    }
}

