/*
 * Decompiled with CFR 0.152.
 */
package cn.bran.japid.compiler;

import cn.bran.japid.classmeta.AbstractTemplateClassMetaData;
import cn.bran.japid.classmeta.InnerClassMeta;
import cn.bran.japid.classmeta.MimeTypeEnum;
import cn.bran.japid.compiler.JapidCompilationException;
import cn.bran.japid.compiler.JapidParser;
import cn.bran.japid.compiler.Tag;
import cn.bran.japid.compiler.TagArgsParser;
import cn.bran.japid.compiler.TagInvocationLineParser;
import cn.bran.japid.compiler.TemplateSyntaxException;
import cn.bran.japid.template.ActionRunner;
import cn.bran.japid.template.JapidTemplate;
import cn.bran.japid.template.RenderResult;
import cn.bran.japid.util.DirUtil;
import cn.bran.japid.util.WebUtils;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JapidAbstractCompiler {
    public static final String DO_LAYOUT = "doLayout";
    private static final String ELVIS = "?:";
    static final String ELSE_IF_PATTERN_STRING = "\\s*\\}\\s*else\\s*if\\s+([^\\(].*)\\s*";
    static final Pattern ELSE_IF_PATTERN = Pattern.compile("\\s*\\}\\s*else\\s*if\\s+([^\\(].*)\\s*");
    static final String OPEN_ELSE_IF_PATTERN_STRING = "\\s*else\\s*if\\s+([^\\(].*)\\s*";
    static final Pattern OPEN_ELSE_IF_PATTERN = Pattern.compile("\\s*else\\s*if\\s+([^\\(].*)\\s*");
    static final String OPEN_ELSE_STRING = "\\s*else\\s*";
    static final String SPACE_OR_NONE = "\\s*";
    static final String SPACE_AT_LEAST_ONE = "\\s+";
    static final String OPEN_FOR_PATTERN_STRING = "for\\s+([^\\(].+)\\s*:\\s*(.+[^\\{])";
    static final Pattern OPEN_FOR_PATTERN = Pattern.compile("for\\s+([^\\(].+)\\s*:\\s*(.+[^\\{])");
    static final String OPEN_IF_PATTERN1 = "if\\s+[^\\(].*";
    private static final String JAPID_RESULT = "cn.bran.play.JapidResult";
    private static final String ARGS = "args";
    protected static final String HTML = ".html";
    protected static final String SPACE = " ";
    protected static final String NEW_LINE = "\n";
    protected JapidTemplate template;
    protected JapidParser parser;
    protected boolean doNextScan = true;
    private Stack<Tag> tagsStack = new Stack();
    private Stack<Tag> tagsStackShadow = new Stack();
    protected int tagIndex;
    protected boolean skipLineBreak;
    protected boolean useWithPlay = true;
    protected int currentLine = 1;
    protected int indentLevel = 0;
    JapidParser.Token state;
    JapidParser.Token previousState;
    JapidParser.Token stateBeforePreviousState;

    public void compile(JapidTemplate t) {
        this.template = t;
        this.getTemplateClassMetaData().setOriginalTemplate(t.name);
        this.getTemplateClassMetaData().useWithPlay = this.useWithPlay;
        this.hop();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parse() {
        while (true) {
            if (this.doNextScan) {
                this.stateBeforePreviousState = this.previousState;
                this.previousState = this.state;
                this.state = this.parser.nextToken();
            } else {
                this.doNextScan = true;
            }
            String token = this.parser.getToken();
            switch (this.state) {
                case EOF: {
                    return;
                }
                case PLAIN: {
                    this.plain(token);
                    break;
                }
                case VERBATIM: {
                    this.plain(token);
                    break;
                }
                case SCRIPT: {
                    this.script(token);
                    break;
                }
                case CLOSING_BRACE: {
                    this.closingBrace(token);
                    break;
                }
                case SCRIPT_LINE: {
                    String spacer;
                    if (this.previousState == JapidParser.Token.PLAIN && this.stateBeforePreviousState == JapidParser.Token.SCRIPT_LINE && (spacer = this.getTemplateClassMetaData().removeLastSingleEmptyLine()) != null) {
                        Tag currentScope = this.tagsStack.peek();
                        int lastIndex = currentScope.bodyTextList.size() - 1;
                        currentScope.bodyTextList.remove(lastIndex);
                        currentScope.bodyTextList.set(lastIndex - 1, spacer);
                    }
                    this.scriptline(token);
                    break;
                }
                case EXPR: {
                    this.expr(token);
                    break;
                }
                case MESSAGE: {
                    this.message(token);
                    break;
                }
                case ACTION: {
                    this.action(token, false);
                    break;
                }
                case ABS_ACTION: {
                    this.action(token, true);
                    break;
                }
                case COMMENT: {
                    this.skipLineBreak = true;
                    break;
                }
                case START_TAG: {
                    this.startTag(this.buildTag(token));
                    break;
                }
                case END_TAG: {
                    String tagName = token.trim();
                    if (this.tagsStack.isEmpty()) {
                        throw new JapidCompilationException(this.template, this.currentLine, "#{/" + tagName + "} is not opened.");
                    }
                    Tag tag = this.popStack();
                    this.endTag(tag);
                    break;
                }
                case TEMPLATE_ARGS: {
                    this.templateArgs(token);
                }
            }
        }
    }

    private Tag popStack() {
        return this.tagsStack.pop();
    }

    protected void closingBrace(String token) {
        this.print("}");
    }

    protected void plain(String token) {
        String text = token.replace("\\", "\\\\").replaceAll("\"", "\\\\\"");
        if (this.skipLineBreak && text.startsWith(NEW_LINE)) {
            text = text.substring(1);
        }
        if (this.getTemplateClassMetaData().getTrimStaticContent()) {
            String r = text.trim();
            if (r.length() == 0) {
                return;
            }
            text = text.trim();
        }
        String lines = JapidAbstractCompiler.composeValidMultiLines(text);
        String ref = this.getTemplateClassMetaData().addStaticText(lines, text);
        if (ref != null) {
            this.print("p(" + lines + ");");
            this.markLine(this.parser.getLineNumber());
            this.println();
        }
    }

    public static String composeValidMultiLines(String text) {
        String[] lines = text.split(NEW_LINE, 10000);
        String result = "";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            result = result + "\"" + line;
            result = i == lines.length - 1 && !text.endsWith(NEW_LINE) ? result + "\"" : (i == lines.length - 1 && line.equals("") ? result + "\"" : result + "\\n\" + \n");
        }
        String emptySuffix = " + \n\"\"";
        if (result.endsWith(emptySuffix)) {
            result = result.substring(0, result.length() - emptySuffix.length());
        }
        return result;
    }

    protected abstract void startTag(Tag var1);

    protected void println() {
        Tag currentScope = this.tagsStack.peek();
        currentScope.bodyTextList.add("");
        ++this.currentLine;
    }

    protected void print(String text) {
        Tag currentScope = this.tagsStack.peek();
        int lastIndex = currentScope.bodyTextList.size() - 1;
        String lastLine = currentScope.bodyTextList.get(lastIndex);
        lastLine = lastLine + text;
        currentScope.bodyTextList.set(lastIndex, lastLine);
    }

    protected void println(String text) {
        this.print(text);
        this.println();
        int i = 0;
        while (i++ < this.indentLevel) {
            this.print("\t");
        }
    }

    protected void markLine(int line) {
        if (!this.getTemplateClassMetaData().getTrimStaticContent()) {
            this.print("// line " + line);
        }
        this.template.linesMatrix.put(this.currentLine, line);
    }

    protected void scriptline(String token) {
        this.script(token);
    }

    protected void script(String token) {
        String[] lines = new String[]{token};
        if (token.indexOf(NEW_LINE) > -1) {
            lines = this.parser.getToken().split(NEW_LINE);
        }
        for (int i = 0; i < lines.length; ++i) {
            Tag tagShadow;
            String expr;
            Tag get;
            String tagline;
            String sw;
            String args;
            Tag tag;
            String line = lines[i];
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "import")) {
                this.getTemplateClassMetaData().addImportLine(line);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "//")) continue;
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "extends")) {
                int p;
                String layout = line.trim().substring("extends".length()).trim();
                boolean hasParam = false;
                for (p = 0; p < layout.length(); ++p) {
                    char c = layout.charAt(p);
                    if (c != ' ' && c != '\t' && c != '(') continue;
                    hasParam = true;
                    break;
                }
                if (!hasParam) {
                    layout = layout.replace("'", "");
                    layout = layout.replace("\"", "");
                    layout = this.removeEndingString(layout, ";");
                    layout = this.removeEndingString(layout, HTML);
                    if ((layout = this.removeEndingString(layout, "/")).startsWith(".")) {
                        layout = layout.startsWith("./") ? this.getTemplateClassMetaData().packageName + layout.substring(1) : this.getTemplateClassMetaData().packageName + layout;
                    }
                    this.getTemplateClassMetaData().superClass = layout.replace('/', '.');
                    continue;
                }
                String layoutName = layout.substring(0, p);
                layoutName = layoutName.replace("'", "");
                layoutName = layoutName.replace("\"", "");
                layoutName = layoutName.replace('/', '.');
                layoutName = this.removeEndingString(layoutName, HTML);
                tag = new TagInvocationLineParser().parse(layoutName + layout.substring(p));
                if (tag.tagName.startsWith(".")) {
                    tag.tagName = this.getTemplateClassMetaData().packageName + tag.tagName;
                }
                this.getTemplateClassMetaData().superClass = tag.tagName;
                this.getTemplateClassMetaData().superClassRenderArgs = tag.args;
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "contentType")) {
                String contentType = line.trim().substring("contentType".length()).trim().replace("'", "").replace("\"", "");
                if (contentType.endsWith(";")) {
                    contentType = contentType.substring(0, contentType.length());
                }
                this.getTemplateClassMetaData().setContentType(contentType);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "setHeader")) {
                String headerkv = line.trim().substring("setHeader".length()).trim();
                String[] split = headerkv.split("[ |\t]");
                if (split.length < 2) {
                    throw new RuntimeException("setHeaader must take a key and a value string");
                }
                String name = split[0];
                String value = headerkv.substring(name.length()).trim();
                this.getTemplateClassMetaData().setHeader(name, value);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, ARGS)) {
                args = line.trim().substring(ARGS.length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                Tag currentTag = this.tagsStack.peek();
                currentTag.callbackArgs = args;
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "trim")) {
                sw = line.trim().substring("trim".length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                if (!"on".equals(sw) && !"true".equals(sw)) continue;
                this.getTemplateClassMetaData().trimStaticContent();
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "stopwatch")) {
                sw = line.trim().substring("stopwatch".length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                if (!"on".equals(sw)) continue;
                this.getTemplateClassMetaData().turnOnStopwatch();
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "log") || line.trim().equals("log")) {
                args = line.trim().substring("log".length()).trim().replace(";", "");
                if (args.trim().length() == 0) {
                    args = "\"\"";
                }
                String logLine = "System.out.println(\"" + this.template.name.replace('\\', '/') + "(line " + (this.parser.getLineNumber() + i) + "): \" + " + args + ");";
                this.println(logLine);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "invoke")) {
                args = line.trim().substring("invoke".length()).trim().replace(";", "");
                this.doActionInvokeDirective(args);
                continue;
            }
            if (this.startsWith(line, "a")) {
                args = line.substring(2).trim().replace(";", "");
                this.doActionInvokeDirective(args);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "suppressNull") || line.trim().equals("suppressNull")) {
                String npe = line.trim().substring("suppressNull".length()).trim().replace(";", "").replace("'", "").replace("\"", "");
                if (!"on".equals(npe) && !"yes".equals(npe) && !"".equals(npe)) continue;
                this.getTemplateClassMetaData().suppressNull();
                continue;
            }
            if (line.trim().equals("abstract")) {
                this.getTemplateClassMetaData().setAbstract(true);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "tag")) {
                tagline = line.trim().substring(4);
                this.doTagDirective(tagline);
                continue;
            }
            if (this.startsWith(line, "t")) {
                tagline = line.substring(2);
                this.doTagDirective(tagline);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "each") || JapidAbstractCompiler.startsWithIgnoreSpace(line, "Each")) {
                Tag tag2 = this.buildTagDirective(line);
                tag2.tagName = "Each";
                tag2.hasBody = true;
                this.startTag(tag2);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "set")) {
                Tag set = this.buildTagDirective(line);
                set.hasBody = !line.contains(":");
                this.startTag(set);
                if (set.hasBody) continue;
                set = this.popStack();
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "get")) {
                get = this.buildTagDirective(line);
                get.hasBody = false;
                this.startTag(get);
                get = this.popStack();
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "def")) {
                get = this.buildTagDirective(line);
                get.hasBody = true;
                this.startTag(get);
                continue;
            }
            if (line.trim().startsWith("noplay")) {
                this.getTemplateClassMetaData().useWithPlay = false;
                continue;
            }
            if (line.trim().equalsIgnoreCase("xml")) {
                this.getTemplateClassMetaData().setContentType(MimeTypeEnum.xml.header);
                continue;
            }
            if (line.trim().equalsIgnoreCase("json")) {
                this.getTemplateClassMetaData().setContentType(MimeTypeEnum.json.header);
                continue;
            }
            if (line.trim().equalsIgnoreCase("css")) {
                this.getTemplateClassMetaData().setContentType(MimeTypeEnum.css.header);
                continue;
            }
            if (line.trim().equalsIgnoreCase("txt") || line.trim().equalsIgnoreCase("text")) {
                this.getTemplateClassMetaData().setContentType(MimeTypeEnum.txt.header);
                continue;
            }
            if (line.trim().equalsIgnoreCase("js") || line.trim().equalsIgnoreCase("javascript")) {
                this.getTemplateClassMetaData().setContentType(MimeTypeEnum.js.header);
                continue;
            }
            if (line.trim().startsWith("verbatim")) {
                this.parser.verbatim = true;
                get = this.buildTagDirective(line);
                get.hasBody = true;
                this.startTag(get);
                continue;
            }
            if (JapidAbstractCompiler.startsWithIgnoreSpace(line, "if")) {
                expr = line.trim();
                if (expr.matches(OPEN_IF_PATTERN1)) {
                    String trim = expr.substring(2).trim();
                    boolean negative = trim.startsWith("!");
                    if (negative) {
                        trim = trim.substring(1).trim();
                    }
                    if (trim.endsWith("{")) {
                        expr = this.removeEndingString(trim, "{").trim();
                        expr = "if(" + (negative ? "!" : "") + "asBoolean(" + expr + ")) {";
                    } else {
                        Tag.TagIf iftag = new Tag.TagIf(trim, this.parser.getLineNumber());
                        this.pushToStack(iftag);
                        expr = "if(" + (negative ? "!" : "") + "asBoolean(" + trim + ")) {";
                    }
                    this.print(expr);
                    this.markLine(this.parser.getLineNumber() + i);
                    this.println();
                    continue;
                }
                this.print(expr);
                this.markLine(this.parser.getLineNumber() + i);
                this.println();
                continue;
            }
            if (line.matches(ELSE_IF_PATTERN_STRING)) {
                expr = line.trim();
                Matcher matcher = ELSE_IF_PATTERN.matcher(line);
                if (matcher.matches()) {
                    expr = matcher.group(1).trim();
                    boolean negative = expr.startsWith("!");
                    if (negative) {
                        expr = expr.substring(1).trim();
                    }
                    expr = "} else if(" + (negative ? "!" : "") + "asBoolean(" + this.removeEndingString(expr, "{") + ")) {";
                    this.print(expr);
                    this.markLine(this.parser.getLineNumber() + i);
                    this.println();
                    continue;
                }
                this.print(expr);
                this.markLine(this.parser.getLineNumber() + i);
                this.println();
                continue;
            }
            if (line.matches(OPEN_ELSE_IF_PATTERN_STRING)) {
                expr = line.trim();
                Matcher matcher = OPEN_ELSE_IF_PATTERN.matcher(line);
                if (matcher.matches()) {
                    Tag tagShadow2;
                    expr = matcher.group(1).trim();
                    boolean negative = expr.startsWith("!");
                    if (negative) {
                        expr = expr.substring(1).trim();
                    }
                    if ((tagShadow2 = this.tagsStackShadow.peek()) instanceof Tag.TagIf) {
                        this.tagsStackShadow.pop();
                        Tag.TagIf iftag = new Tag.TagIf(expr, this.parser.getLineNumber());
                        this.pushToStack(iftag);
                        expr = "} else if(" + (negative ? "!" : "") + "asBoolean(" + expr + ")) {";
                    } else {
                        throw new RuntimeException("the open \"else if\" statement is not properly matched to a previous if");
                    }
                }
                this.print(expr);
                this.markLine(this.parser.getLineNumber() + i);
                this.println();
                continue;
            }
            if (line.matches(OPEN_ELSE_STRING)) {
                tagShadow = this.tagsStackShadow.peek();
                if (tagShadow instanceof Tag.TagIf) {
                    this.tagsStackShadow.pop();
                    this.print("} else {");
                    this.markLine(this.parser.getLineNumber() + i);
                    this.println();
                    Tag.TagIf iftag = new Tag.TagIf("", this.parser.getLineNumber());
                    this.pushToStack(iftag);
                    continue;
                }
                throw new RuntimeException("the open \"else\" statement is not properly matched to a previous if");
            }
            if (line.trim().matches(OPEN_FOR_PATTERN_STRING)) {
                expr = line.trim();
                Matcher matcher = OPEN_FOR_PATTERN.matcher(expr);
                if (matcher.matches()) {
                    String instanceDecl = matcher.group(1);
                    instanceDecl = JapidAbstractCompiler.cleanDeclPrimitive(instanceDecl);
                    String collection = matcher.group(2);
                    expr = "each " + collection + " | " + instanceDecl;
                    tag = this.buildTagDirective(expr);
                    tag.tagName = "Each";
                    tag.hasBody = true;
                    this.startTag(tag);
                    continue;
                }
                this.print(expr);
                this.markLine(this.parser.getLineNumber() + i);
                this.println();
                continue;
            }
            if (line.trim().length() == 0) {
                try {
                    Tag tag3;
                    tagShadow = this.tagsStackShadow.peek();
                    if (tagShadow.isRoot()) continue;
                    tagShadow = this.tagsStackShadow.pop();
                    if (tagShadow instanceof Tag.TagIf) {
                        this.print("}");
                        this.markLine(this.parser.getLineNumber() + i);
                        this.println();
                        continue;
                    }
                    if (this.tagsStack.empty() || (tag3 = this.tagsStack.peek()).isRoot()) continue;
                    tag3 = this.popStack();
                    this.endTag(tag3);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
                continue;
            }
            this.print(line);
            this.markLine(this.parser.getLineNumber() + i);
            this.println();
        }
        this.skipLineBreak = true;
    }

    private String removeEndingString(String string, String ending) {
        if (string.endsWith(ending)) {
            return string.substring(0, string.lastIndexOf(ending));
        }
        return string;
    }

    protected static boolean startsWithIgnoreSpace(String line, String string) {
        return (line = line.trim()).startsWith(string + SPACE) || line.startsWith(string + "\t");
    }

    private boolean startsWith(String line, String string) {
        return line.startsWith(string + SPACE) || line.startsWith(string + "\t");
    }

    private void doActionInvokeDirective(String args) {
        if (!this.getTemplateClassMetaData().useWithPlay) {
            throw new RuntimeException("action invocation is only supported in Play environment. ");
        }
        this.getTemplateClassMetaData().setHasActionInvocation();
        if (args.trim().length() == 0) {
            args = "whatyouwantoinvoke()";
        }
        this.printActionInvocation(args);
    }

    private void doTagDirective(String tagline) {
        Tag tag = this.buildTagDirective(tagline);
        this.startTag(tag);
        if (!tag.hasBody) {
            tag = this.tagsStackShadow.pop();
            tag = this.popStack();
            this.endTag(tag);
        }
    }

    protected void expr(String token) {
        String expr = token;
        int i = token.indexOf(ELVIS);
        String substitute = null;
        if (i > 0) {
            expr = token.substring(0, i);
            substitute = token.substring(i + ELVIS.length()).trim();
            if (substitute.startsWith("\"")) {
                substitute = substitute.substring(1);
            }
            if (substitute.endsWith("\"")) {
                substitute = substitute.substring(0, substitute.length() - 1);
            }
        }
        if (substitute != null) {
            this.printLine("try { Object o = " + expr + "; " + "if (o.toString().length() ==0) { " + "p(\"" + substitute + "\"); } " + "else { p(o); } } " + "catch (NullPointerException npe) { " + "p(\"" + substitute + "\"); }");
        } else if (this.getTemplateClassMetaData().suppressNull) {
            this.printLine("try { p(" + expr + "); } catch (NullPointerException npe) {}");
        } else {
            this.printLine("p(" + expr + ");");
        }
    }

    private void printLine(String string) {
        this.print(string);
        this.markLine(this.parser.getLineNumber());
        this.println();
    }

    protected void message(String token) {
        String expr = token.trim().replace('\'', '\"');
        this.print(";p(getMessage(" + expr + "));");
        this.markLine(this.parser.getLineNumber());
        this.println();
    }

    protected void action(String token, boolean absolute) {
        String action = token.trim();
        if (action.matches("^'.*'$") || action.matches("^\".*\"$")) {
            action = action.replace('\'', '\"');
            if (absolute) {
                this.print("p(lookupStaticAbs(" + action + "));");
            } else {
                this.print("p(lookupStatic(" + action + "));");
            }
        } else {
            int indexOfParam;
            if (!action.endsWith(")")) {
                action = action + "()";
            }
            if ((indexOfParam = action.indexOf("(")) < 1) {
                throw new TemplateSyntaxException("action arguments must be enclosed in parenthesis.", this.template.name, action, this.currentLine);
            }
            String actionPart = action.substring(0, indexOfParam).trim();
            String params = action.substring(indexOfParam + 1);
            if ((params = params.substring(0, params.length() - 1).trim()).length() == 0) {
                params = "new Object[]{}";
            }
            if (absolute) {
                this.print("p(lookupAbs(\"" + actionPart + "\", " + params + "));");
            } else {
                this.print("p(lookup(\"" + actionPart + "\", " + params + "));");
            }
        }
        this.markLine(this.parser.getLineNumber());
        this.println();
    }

    protected void hop() {
        String source = this.template.source;
        Tag rootTag = new Tag(){
            {
                this.tagName = "_root";
                this.startLine = 0;
                this.hasBody = true;
            }
        };
        this.tagsStack.push(rootTag);
        this.tagsStackShadow.push(rootTag);
        this.parser = new JapidParser(source);
        String tempName = this.template.name.replace("-", "_");
        String contentTypeHeader = MimeTypeEnum.getHeader(tempName.substring(tempName.lastIndexOf(46)));
        this.getTemplateClassMetaData().setContentType(contentTypeHeader);
        tempName = DirUtil.mapSrcToJava(tempName);
        tempName = tempName.substring(0, tempName.lastIndexOf(".java"));
        tempName = tempName.replace('\\', '/');
        int lastSep = tempName.lastIndexOf(47);
        if (lastSep > 0) {
            String path = tempName.substring(0, lastSep);
            path = path.replace('/', '.');
            this.getTemplateClassMetaData().packageName = path = path.replace('\\', '.');
            this.getTemplateClassMetaData().setClassName(tempName.substring(lastSep + 1));
        } else {
            this.getTemplateClassMetaData().setClassName(tempName);
        }
        this.parse();
        Tag tag = this.popStack();
        if (!this.tagsStack.empty()) {
            throw new RuntimeException("There is(are) " + this.tagsStack.size() + " unclosed tag(s) in the template: " + this.template.name);
        }
        this.getTemplateClassMetaData().body = tag.getBodyText().replace("p(\"\")", "").replace("pln(\"\")", "pln()");
        this.postParsing(tag);
        this.template.javaSource = this.getTemplateClassMetaData().generateCode();
    }

    protected void postParsing(Tag tag) {
        this.getTemplateClassMetaData().renderArgs = tag.callbackArgs;
    }

    protected abstract AbstractTemplateClassMetaData getTemplateClassMetaData();

    protected void templateArgs(String token) {
        String args;
        Tag currentTag = this.tagsStack.peek();
        currentTag.callbackArgs = args = token;
    }

    protected Tag buildTag(String token) {
        String tagText = token.trim().replaceAll(NEW_LINE, SPACE);
        boolean hasBody = !this.parser.checkNext().endsWith("/");
        Tag tag = new TagInvocationLineParser().parse(tagText);
        if (tag.tagName == null || tag.tagName.length() == 0) {
            throw new RuntimeException("tag name was empty: " + tagText);
        }
        if (tag.tagName.startsWith(".")) {
            tag.tagName = this.getTemplateClassMetaData().packageName + tag.tagName;
        }
        tag.startLine = this.parser.getLineNumber();
        tag.hasBody = hasBody;
        tag.tagIndex = this.tagIndex++;
        return tag;
    }

    protected Tag buildTagDirective(String token) {
        String tagText = token.trim();
        Tag tag = new TagInvocationLineParser().parse(tagText);
        if (tag.tagName == null || tag.tagName.length() == 0) {
            throw new RuntimeException("tag name was empty: " + tagText);
        }
        if (tag.tagName.startsWith(".")) {
            tag.tagName = this.getTemplateClassMetaData().packageName + tag.tagName;
        }
        tag.startLine = this.parser.getLineNumber();
        tag.tagIndex = this.tagIndex++;
        return tag;
    }

    protected static String createActionRunner(String actionInvocationWithCache) {
        List<String> params = new TagArgsParser(actionInvocationWithCache).split();
        String action = params.get(0);
        int left = action.indexOf(40);
        if (left < 1) {
            throw new RuntimeException("invoke: action arguments must be enclosed in parenthesis.");
        }
        int right = action.lastIndexOf(41);
        String actionPath = "\"" + action.substring(0, left) + "\"";
        String args = action.substring(left + 1, right).trim();
        String ttl = "\"\"";
        if (params.size() >= 2) {
            ttl = params.get(1);
            if (params.size() > 2) {
                for (int i = 2; i < params.size(); ++i) {
                    args = args + "," + params.get(i);
                }
                if (args.startsWith(",")) {
                    args = args.substring(1);
                }
                if (args.endsWith(",")) {
                    args = args.substring(0, args.length() - 1);
                }
            }
        }
        return JapidAbstractCompiler.createActionRunner(action, ttl, actionPath, args);
    }

    protected void printActionInvocation(String action) {
        this.println(JapidAbstractCompiler.createActionRunner(action));
    }

    protected void regularTagInvoke(Tag tag) {
        if ("extends".equals(tag.tagName)) {
            String layoutName = tag.args;
            layoutName = layoutName.replace("'", "");
            layoutName = layoutName.replace("\"", "");
            layoutName = this.removeEndingString(layoutName, HTML);
            layoutName = this.removeEndingString(layoutName, "/");
            this.getTemplateClassMetaData().superClass = layoutName.replace('/', '.');
        } else if (tag.tagName.equals("invoke")) {
            this.invokeAction(tag);
        } else {
            String tagVar = "_" + tag.getTagVarName() + tag.tagIndex;
            if (!tag.hasBody) {
                String tagline = tagVar + ".setOut(getOut()); ";
                tagline = tagline + tagVar + ".render(" + tag.args + ");";
                this.println(tagline);
            }
        }
    }

    protected void invokeAction(Tag tag) {
        if (tag.hasBody) {
            throw new JapidCompilationException(this.template, this.currentLine, "invoke tag cannot have a body. Must be ended with /}");
        }
        this.getTemplateClassMetaData().setHasActionInvocation();
        String action = tag.args;
        this.printActionInvocation(action);
    }

    protected void endRegularTag(Tag tag) {
        if (tag.hasBody) {
            InnerClassMeta inner = this.getTemplateClassMetaData().addCallTagBodyInnerClass(tag.tagName, tag.tagIndex, tag.callbackArgs, tag.getBodyText());
            if (inner == null) {
                System.out.println(tag.tagName + " not allowed to have instance of this tag");
            }
            String tagVar = "_" + tag.getTagVarName() + tag.tagIndex;
            String tagLine = tagVar + ".setOut(getOut()); ";
            tagLine = tagLine + tagVar + ".render(" + (WebUtils.asBoolean(tag.args) ? tag.args + ", " : "") + inner.getAnonymous() + ");";
            this.println(tagLine);
        } else {
            this.getTemplateClassMetaData().addCallTagBodyInnerClass(tag.tagName, tag.tagIndex, null, null);
        }
    }

    protected void def(Tag tag) {
    }

    protected void endDef(Tag tag) {
        if (tag.hasBody) {
            this.getTemplateClassMetaData().addDefTag(tag);
        }
    }

    protected void endTag(Tag tag) {
        String lastInStack = tag.tagName;
        String tagName = lastInStack;
        if (tagName.equals("def")) {
            this.endDef(tag);
        } else if (!(tagName.equals("doBody") || tagName.equals("extends") || tagName.equals("get") || tagName.equals("invoke") || tagName.equals(DO_LAYOUT) || this.endTagSpecial(tag))) {
            this.endRegularTag(tag);
        }
        this.markLine(tag.startLine);
        this.println();
        this.skipLineBreak = true;
    }

    protected boolean endTagSpecial(Tag tag) {
        return false;
    }

    static String createActionRunner(String action, String ttl, String base, String keys) {
        String actionEscaped = action.replace("\"", "\\\"");
        String controllerActionPart = action.substring(0, action.indexOf(40));
        int lastDot = controllerActionPart.lastIndexOf(46);
        String controllerName = controllerActionPart.substring(0, lastDot);
        String actionName = controllerActionPart.substring(lastDot + 1);
        if (ttl == null) {
            String template = "\t\t%s.put(getOut().length(), new %s() {\n\t\t\t@Override\n\t\t\tpublic %s run() {\n\t\t\t\ttry {\n\t\t\t\t\tplay.classloading.enhancers.ControllersEnhancer.ControllerInstrumentation.initActionCall();\n\t\t\t\t\t%s;\n\t\t\t\t} catch (%s jr) {\n\t\t\t\t\treturn jr.getRenderResult();\n\t\t\t\t}\n\t\t\t\tthrow new RuntimeException(\"No render result from running: %s\");\n\t\t\t}\n\t\t});";
            return String.format(template, "actionRunners", ActionRunner.class.getName(), RenderResult.class.getName(), action, JAPID_RESULT, actionEscaped);
        }
        String template = "\t\t%s.put(getOut().length(), new %s(%s, %s, %s, %s) {\r\n\t\t\t@Override\r\n\t\t\tpublic void runPlayAction() throws %s {\r\n\t\t\t\t%s; //\r\n\t\t\t}\r\n\t\t});\r\n";
        return String.format(template, "actionRunners", "cn.bran.play.CacheablePlayActionRunner", ttl, controllerName + ".class", "\"" + actionName + "\"", "".equals(keys) ? "\"\"" : keys, JAPID_RESULT, action);
    }

    public void setUseWithPlay(boolean play) {
        this.useWithPlay = play;
    }

    protected void pushToStack(Tag tag) {
        this.tagsStackShadow.push(tag);
        if (!(tag instanceof Tag.TagIf)) {
            this.tagsStack.push(tag);
        }
    }

    static String cleanDeclPrimitive(String decl) {
        decl = decl.trim();
        int i = decl.length();
        String var = "";
        String type = "";
        while (--i >= 0) {
            char c = decl.charAt(i);
            if (c != ' ' && c != '\t') continue;
            var = decl.substring(i + 1);
            type = decl.substring(0, i).trim();
            break;
        }
        if ("int".equals(type)) {
            decl = "Integer " + var;
        } else if ("long".equals(type)) {
            decl = "Long " + var;
        } else if ("float".equals(type)) {
            decl = "Float " + var;
        } else if ("double".equals(type)) {
            decl = "Double " + var;
        } else if ("char".equals(type)) {
            decl = "Character " + var;
        } else if ("boolean".equals(type)) {
            decl = "Boolean " + var;
        } else if ("byte".equals(type)) {
            decl = "Byte " + var;
        }
        return decl;
    }
}

